/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.actions.withdraw;

import org.kuali.kra.printing.PrintingException;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.ProtocolVersionService;
import org.kuali.kra.protocol.actions.correspondence.ProtocolActionCorrespondenceGenerationService;
import org.kuali.kra.protocol.actions.correspondence.ProtocolActionsCorrespondenceBase;
import org.kuali.kra.protocol.actions.submit.ProtocolActionService;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.actions.withdraw.ProtocolAdministrativelyIncompleteBean;
import org.kuali.kra.protocol.actions.withdraw.ProtocolAdministrativelyWithdrawBean;
import org.kuali.kra.protocol.actions.withdraw.ProtocolWithdrawBean;
import org.kuali.kra.protocol.actions.withdraw.ProtocolWithdrawService;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;

public abstract class ProtocolWithdrawServiceImplBase
implements ProtocolWithdrawService {
    protected DocumentService documentService;
    protected BusinessObjectService businessObjectService;
    protected ProtocolActionService protocolActionService;
    protected ProtocolVersionService protocolVersionService;
    protected ProtocolActionCorrespondenceGenerationService protocolActionCorrespondenceGenerationService;
    protected ProtocolOnlineReviewService protocolOnlineReviewService;
    protected static final String WITHDRAW_FINALIZE_OLR_ANNOTATION = "Online Review finalized as part of withdraw action on protocol.";

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setProtocolActionCorrespondenceGenerationService(ProtocolActionCorrespondenceGenerationService protocolActionCorrespondenceGenerationService) {
        this.protocolActionCorrespondenceGenerationService = protocolActionCorrespondenceGenerationService;
    }

    public void setProtocolActionService(ProtocolActionService protocolActionService) {
        this.protocolActionService = protocolActionService;
    }

    public void setProtocolVersionService(ProtocolVersionService protocolVersionService) {
        this.protocolVersionService = protocolVersionService;
    }

    @Override
    public abstract ProtocolDocumentBase withdraw(ProtocolBase var1, ProtocolWithdrawBean var2) throws Exception;

    protected void generateCorrespondenceDocumentAndAttach(ProtocolBase protocol, ProtocolWithdrawBean withdrawBean) throws PrintingException {
        ProtocolActionsCorrespondenceBase correspondence = withdrawBean.getCorrespondence();
        correspondence.setProtocol(protocol);
        this.protocolActionCorrespondenceGenerationService.generateCorrespondenceDocumentAndAttach(correspondence);
    }

    protected void cancelWorkflow(ProtocolBase protocol) throws WorkflowException {
        this.documentService.cancelDocument((Document)protocol.getProtocolDocument(), null);
    }

    protected ProtocolSubmissionBase getSubmission(ProtocolBase protocol) {
        for (ProtocolSubmissionBase submission : protocol.getProtocolSubmissions()) {
            if (!this.isWithdrawable(submission)) continue;
            return submission;
        }
        return null;
    }

    protected boolean isWithdrawable(ProtocolSubmissionBase submission) {
        return this.isAllowedStatus(submission) && this.isNormalSubmission(submission);
    }

    protected abstract boolean isAllowedStatus(ProtocolSubmissionBase var1);

    protected abstract boolean isNormalSubmission(ProtocolSubmissionBase var1);

    public void setProtocolOnlineReviewService(ProtocolOnlineReviewService protocolOnlineReviewService) {
        this.protocolOnlineReviewService = protocolOnlineReviewService;
    }

    @Override
    public abstract ProtocolDocumentBase administrativelyWithdraw(ProtocolBase var1, ProtocolAdministrativelyWithdrawBean var2) throws Exception;

    @Override
    public abstract ProtocolDocumentBase administrativelyMarkIncomplete(ProtocolBase var1, ProtocolAdministrativelyIncompleteBean var2) throws Exception;
}

