/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.auth;

import org.apache.commons.lang.StringUtils;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.auth.ProtocolAuthorizerBase;
import org.kuali.kra.protocol.auth.ProtocolTaskBase;

public class IrbAcknowledgementUnavailableAuthorizer
extends ProtocolAuthorizerBase {
    @Override
    public boolean isAuthorized(String userId, ProtocolTaskBase task) {
        return !this.isValidToPerform(task) && this.hasPermission(userId, task.getProtocol(), "Perform IRB Actions on a Protocol");
    }

    private boolean isValidToPerform(ProtocolTaskBase task) {
        boolean isValid = false;
        ProtocolBase protocol = task.getProtocol();
        if (protocol.getNotifyIrbSubmissionId() != null) {
            for (ProtocolSubmissionBase submission : protocol.getProtocolSubmissions()) {
                if (!submission.getSubmissionId().equals(protocol.getNotifyIrbSubmissionId())) continue;
                isValid = this.isValidFYI(submission);
            }
        }
        if (!isValid) {
            protocol.setNotifyIrbSubmissionId(null);
            isValid = this.canExecuteAction(task.getProtocol(), "209");
        }
        return isValid;
    }

    private boolean isValidFYI(ProtocolSubmissionBase submission) {
        return this.isFYISubmission(submission.getSubmissionTypeCode()) && this.isFYIReview(submission.getProtocolReviewTypeCode()) && this.isStatusValid(submission.getSubmissionStatusCode());
    }

    private boolean isFYISubmission(String submissionTypeCode) {
        return StringUtils.isNotBlank((String)submissionTypeCode) && "112".equals(submissionTypeCode);
    }

    private boolean isFYIReview(String reviewTypeCode) {
        return StringUtils.isNotBlank((String)reviewTypeCode);
    }

    private boolean isStatusValid(String submissionStatusCode) {
        return StringUtils.isNotBlank((String)submissionStatusCode) && ("100".equals(submissionStatusCode) || "101".equals(submissionStatusCode));
    }
}

