/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.auth;

import org.apache.commons.lang.StringUtils;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.auth.ProtocolAuthorizerBase;
import org.kuali.kra.protocol.auth.ProtocolTaskBase;
import org.kuali.rice.krad.document.Document;

public class ProtocolAssignReviewersAuthorizer
extends ProtocolAuthorizerBase {
    @Override
    public boolean isAuthorized(String username, ProtocolTaskBase task) {
        ProtocolBase protocol = task.getProtocol();
        return this.isOnNode(protocol) && this.isPendingOrSubmittedToCommittee(protocol) && this.isInSchedule(protocol) && this.hasPermission(username, protocol, "Perform IRB Actions on a Protocol");
    }

    public boolean isOnNode(ProtocolBase protocol) {
        return this.kraWorkflowService.isDocumentOnNode((Document)protocol.getProtocolDocument(), "IRBReview");
    }

    private boolean isPendingOrSubmittedToCommittee(ProtocolBase protocol) {
        return this.findSubmission(protocol) != null;
    }

    private boolean isInSchedule(ProtocolBase protocol) {
        ProtocolSubmissionBase submission = this.findSubmission(protocol);
        return submission != null && !StringUtils.isBlank((String)submission.getCommitteeId()) && !StringUtils.isBlank((String)submission.getScheduleId());
    }

    private ProtocolSubmissionBase findSubmission(ProtocolBase protocol) {
        for (ProtocolSubmissionBase submission : protocol.getProtocolSubmissions()) {
            if (!StringUtils.equals((String)submission.getSubmissionStatusCode(), (String)"102") && !StringUtils.equals((String)submission.getSubmissionStatusCode(), (String)"100")) continue;
            return submission;
        }
        return null;
    }
}

