/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.auth;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.authorization.ApplicationTask;
import org.kuali.kra.authorization.KcTransactionalDocumentAuthorizerBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.auth.ProtocolTaskBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.document.Document;

public abstract class ProtocolDocumentAuthorizerBase
extends KcTransactionalDocumentAuthorizerBase {
    private static final long serialVersionUID = -7155315639701623791L;

    public Set<String> getEditModes(Document document, Person user, Set<String> currentEditModes) {
        HashSet<String> editModes = new HashSet<String>();
        ProtocolDocumentBase protocolDocument = (ProtocolDocumentBase)document;
        String userId = user.getPrincipalId();
        if (protocolDocument.getProtocol().getProtocolId() == null) {
            if (this.canCreateProtocol(user)) {
                editModes.add("fullEntry");
            } else {
                editModes.add("unviewable");
            }
        } else {
            if (this.canExecuteProtocolTask(userId, protocolDocument, "modifyProtocol")) {
                editModes.add("fullEntry");
            } else if (this.canExecuteProtocolTask(userId, protocolDocument, "viewProtocol")) {
                editModes.add("viewOnly");
            } else {
                editModes.add("unviewable");
            }
            if (this.canExecuteProtocolTask(userId, protocolDocument, "maintainProtocolOnlineReviews")) {
                editModes.add("maintainProtocolOnlineReviews");
            }
            if (this.canViewReviewComments((Document)protocolDocument, user)) {
                editModes.add("viewReviewComments");
            }
        }
        return editModes;
    }

    public boolean canViewReviewComments(Document document, Person user) {
        ProtocolDocumentBase protocolDoc = (ProtocolDocumentBase)document;
        List<ProtocolPersonBase> participants = protocolDoc.getProtocol().getProtocolPersons();
        for (ProtocolPersonBase participant : participants) {
            String statusCode;
            if (!StringUtils.equalsIgnoreCase((String)(participant.getPersonId() + ""), (String)user.getPrincipalId()) || !(statusCode = protocolDoc.getProtocol().getProtocolStatusCode()).equalsIgnoreCase("101")) continue;
            return false;
        }
        return true;
    }

    public boolean canInitiate(String documentTypeName, Person user) {
        return this.canCreateProtocol(user);
    }

    public boolean canOpen(Document document, Person user) {
        ProtocolDocumentBase protocolDocument = (ProtocolDocumentBase)document;
        if (protocolDocument.getProtocol().getProtocolId() == null) {
            return this.canCreateProtocol(user);
        }
        return this.canExecuteProtocolTask(user.getPrincipalId(), (ProtocolDocumentBase)document, "viewProtocol");
    }

    private boolean canCreateProtocol(Person user) {
        ApplicationTask task = new ApplicationTask("createProtocol");
        TaskAuthorizationService taskAuthenticationService = KraServiceLocator.getService(TaskAuthorizationService.class);
        return taskAuthenticationService.isAuthorized(user.getPrincipalId(), task);
    }

    private boolean canExecuteProtocolTask(String userId, ProtocolDocumentBase doc, String taskName) {
        ProtocolTaskBase task = this.createNewProtocolTaskInstanceHook(taskName, doc.getProtocol());
        TaskAuthorizationService taskAuthenticationService = KraServiceLocator.getService(TaskAuthorizationService.class);
        return taskAuthenticationService.isAuthorized(userId, task);
    }

    protected abstract ProtocolTaskBase createNewProtocolTaskInstanceHook(String var1, ProtocolBase var2);

    @Override
    public boolean canEdit(Document document, Person user) {
        return this.canExecuteProtocolTask(user.getPrincipalId(), (ProtocolDocumentBase)document, "modifyProtocol");
    }

    @Override
    public boolean canSave(Document document, Person user) {
        return this.canEdit(document, user);
    }

    @Override
    public boolean canCopy(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canCancel(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canRoute(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canBlanketApprove(Document document, Person user) {
        return false;
    }

    public boolean canSendNoteFyi(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canFyi(Document document, Person user) {
        return false;
    }
}

