/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.noteattachment;

import java.io.Serializable;
import java.util.Comparator;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentProtocolBase;

public abstract class ProtocolAttachmentFilterBase
implements Serializable {
    private static final long serialVersionUID = 53138457226971783L;
    protected String filterBy;
    protected String sortBy;

    public String getFilterBy() {
        return this.filterBy;
    }

    public void setFilterBy(String filterBy) {
        this.filterBy = filterBy;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public Comparator<ProtocolAttachmentProtocolBase> getProtocolAttachmentComparator() {
        return new ProtocolAttachmentComparatorFactory().getProtocolAttachmentComparator(this.getSortBy());
    }

    private class ProtocolAttachmentLastUpdatedByComparator
    implements Comparator<ProtocolAttachmentProtocolBase> {
        private ProtocolAttachmentLastUpdatedByComparator() {
        }

        @Override
        public int compare(ProtocolAttachmentProtocolBase o1, ProtocolAttachmentProtocolBase o2) {
            return o1.getUpdateUserFullName().compareTo(o2.getUpdateUserFullName());
        }
    }

    private class ProtocolAttachmentLastUpdatedComparator
    implements Comparator<ProtocolAttachmentProtocolBase> {
        private ProtocolAttachmentLastUpdatedComparator() {
        }

        @Override
        public int compare(ProtocolAttachmentProtocolBase o1, ProtocolAttachmentProtocolBase o2) {
            return o1.getUpdateTimestamp().compareTo(o2.getUpdateTimestamp());
        }
    }

    private class ProtocolAttachmentAttachmentTypeComparator
    implements Comparator<ProtocolAttachmentProtocolBase> {
        private ProtocolAttachmentAttachmentTypeComparator() {
        }

        @Override
        public int compare(ProtocolAttachmentProtocolBase o1, ProtocolAttachmentProtocolBase o2) {
            return o1.getType().getDescription().compareTo(o2.getType().getDescription());
        }
    }

    private class ProtocolAttachmentDescriptionComparator
    implements Comparator<ProtocolAttachmentProtocolBase> {
        private ProtocolAttachmentDescriptionComparator() {
        }

        @Override
        public int compare(ProtocolAttachmentProtocolBase arg0, ProtocolAttachmentProtocolBase arg1) {
            return arg0.getDescription().compareTo(arg1.getDescription());
        }
    }

    class ProtocolAttachmentComparatorFactory {
        ProtocolAttachmentComparatorFactory() {
        }

        public Comparator<ProtocolAttachmentProtocolBase> getProtocolAttachmentComparator(String sortBy) {
            if ("DESC".equalsIgnoreCase(sortBy)) {
                return new ProtocolAttachmentDescriptionComparator();
            }
            if ("ATTP".equalsIgnoreCase(sortBy)) {
                return new ProtocolAttachmentAttachmentTypeComparator();
            }
            if ("LAUP".equalsIgnoreCase(sortBy)) {
                return new ProtocolAttachmentLastUpdatedComparator();
            }
            if ("UPBY".equalsIgnoreCase(sortBy)) {
                return new ProtocolAttachmentLastUpdatedByComparator();
            }
            return null;
        }
    }
}

