/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.notification;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.common.notification.NotificationRendererBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.notification.ProtocolReplacementParameters;
import org.kuali.kra.service.KcPersonService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class ProtocolNotificationRendererBase
extends NotificationRendererBase {
    private static final long serialVersionUID = 7966684994606021231L;
    private ProtocolBase protocol;
    private transient BusinessObjectService businessObjectService;
    private transient KcPersonService kcPersonService;

    public ProtocolNotificationRendererBase(ProtocolBase protocol) {
        this.protocol = protocol;
    }

    @Override
    public Map<String, String> getDefaultReplacementParameters() {
        String[] replacementParameters = ProtocolReplacementParameters.REPLACEMENT_PARAMETERS;
        Map<String, String> params = super.getDefaultReplacementParameters();
        String key = null;
        for (int i = 0; i < replacementParameters.length; ++i) {
            key = replacementParameters[i];
            if (StringUtils.equals((String)key, (String)"{PROTOCOL_NUMBER}")) {
                params.put(key, this.protocol.getProtocolNumber());
                continue;
            }
            if (StringUtils.equals((String)key, (String)"{PI_NAME}")) {
                params.put(key, this.protocol.getPrincipalInvestigator().getFullName());
                continue;
            }
            if (StringUtils.equals((String)key, (String)"{LEAD_UNIT}")) {
                params.put(key, this.protocol.getLeadUnitNumber());
                continue;
            }
            if (StringUtils.equals((String)key, (String)"{LEAD_UNIT_NAME}")) {
                params.put(key, this.protocol.getLeadUnitName());
                continue;
            }
            if (StringUtils.equals((String)key, (String)"{PROTOCOL_STATUS_CODE}")) {
                params.put(key, this.protocol.getProtocolStatusCode());
                continue;
            }
            if (StringUtils.equals((String)key, (String)"{PROTOCOL_STATUS_DESCRIPTION}")) {
                params.put(key, this.protocol.getProtocolStatus().getDescription());
                continue;
            }
            if (StringUtils.equals((String)key, (String)"{LAST_SUBMISSION_TYPE_CODE}")) {
                if (this.protocol.getProtocolSubmission() == null) continue;
                params.put(key, this.protocol.getProtocolSubmission().getSubmissionTypeCode());
                continue;
            }
            if (StringUtils.equals((String)key, (String)"{LAST_SUBMISSION_TYPE_QUAL_CODE}")) {
                if (this.protocol.getProtocolSubmission() == null) continue;
                params.put(key, this.protocol.getProtocolSubmission().getSubmissionTypeQualifierCode());
                continue;
            }
            if (StringUtils.equals((String)key, (String)"{PROTOCOL_TITLE}")) {
                params.put(key, this.protocol.getTitle());
                continue;
            }
            if (StringUtils.equals((String)key, (String)"{PROTOCOL_TYPE_CODE}")) {
                params.put(key, this.protocol.getProtocolTypeCode());
                continue;
            }
            if (StringUtils.equals((String)key, (String)"{PROTOCOL_TYPE_DESCRIPTION}")) {
                if (this.protocol.getProtocolType() == null) continue;
                params.put(key, this.protocol.getProtocolType().getDescription());
                continue;
            }
            if (StringUtils.equals((String)key, (String)"{SEQUENCE_NUMBER}")) {
                params.put(key, this.protocol.getSequenceNumber().toString());
                continue;
            }
            if (StringUtils.equals((String)key, (String)"{SUBMISSION_STATUS_CODE}")) {
                if (this.protocol.getProtocolSubmission() == null) continue;
                params.put(key, this.protocol.getProtocolSubmission().getSubmissionStatusCode());
                continue;
            }
            if (StringUtils.equals((String)key, (String)"{SUBMISSION_STATUS_NAME}")) {
                params.put(key, this.protocol.getProtocolSubmissionStatus());
                continue;
            }
            if (StringUtils.equals((String)key, (String)"{USER_FULLNAME}")) {
                params.put(key, GlobalVariables.getUserSession().getPerson().getName());
                continue;
            }
            if (StringUtils.equals((String)key, (String)"{DOCUMENT_NUMBER}")) {
                params.put(key, this.protocol.getProtocolDocument().getDocumentNumber());
                continue;
            }
            if (StringUtils.equals((String)key, (String)"{COMMITTEE_NAME}")) {
                if (this.protocol.getProtocolSubmission() == null) continue;
                params.put(key, this.getSafeMessage(key, this.getCommitteeName(this.protocol.getProtocolSubmission().getCommitteeId())));
                continue;
            }
            if (StringUtils.equals((String)key, (String)"{PROTOCOL_INITIAL_APPROVAL_DATE}")) {
                if (this.protocol.getProtocolSubmission() == null || this.protocol.getApprovalDate() == null) continue;
                params.put(key, this.getSafeMessage(key, new SimpleDateFormat("d'-'MMM'-'yyyy").format(this.protocol.getApprovalDate())));
                continue;
            }
            if (StringUtils.equals((String)key, (String)"{PROTOCOL_LAST_APPROVAL_DATE}")) {
                if (this.protocol.getProtocolSubmission() == null || this.protocol.getLastApprovalDate() == null) continue;
                params.put(key, this.getSafeMessage(key, new SimpleDateFormat("d'-'MMM'-'yyyy").format(this.protocol.getLastApprovalDate())));
                continue;
            }
            if (!StringUtils.equals((String)key, (String)"{PROTOCOL_EXPIRATION_DATE}") || this.protocol.getProtocolSubmission() == null || this.protocol.getExpirationDate() == null) continue;
            params.put(key, this.getSafeMessage(key, new SimpleDateFormat("d'-'MMM'-'yyyy").format(this.protocol.getExpirationDate())));
        }
        return params;
    }

    public ProtocolBase getProtocol() {
        return this.protocol;
    }

    public void setProtocol(ProtocolBase protocol) {
        this.protocol = protocol;
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KRADServiceLocator.getBusinessObjectService();
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    @Override
    public KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KraServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    @Override
    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    private String getCommitteeName(String committeeId) {
        String result = null;
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("committeeId", committeeId);
        List committees = (List)this.getBusinessObjectService().findMatching(this.getCommonCommitteeBOClassHook(), fieldValues);
        if (CollectionUtils.isNotEmpty((Collection)committees)) {
            result = ((CommitteeBase)committees.get(0)).getCommitteeName();
        }
        return result;
    }

    protected abstract Class<? extends CommitteeBase> getCommonCommitteeBOClassHook();
}

