/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.onlinereview;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.authorization.KcTransactionalDocumentAuthorizerBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.ProtocolFormBase;
import org.kuali.kra.protocol.ProtocolOnlineReviewDocumentBase;
import org.kuali.kra.protocol.actions.reviewcomments.ReviewAttachmentsBeanBase;
import org.kuali.kra.protocol.actions.reviewcomments.ReviewCommentsBeanBase;
import org.kuali.kra.protocol.actions.reviewcomments.ReviewCommentsService;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewer;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewBase;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewFormBase;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewService;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.service.RolodexService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kns.service.DataDictionaryService;
import org.kuali.rice.kns.service.DocumentHelperService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.PessimisticLockService;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class OnlineReviewsActionHelperBase
implements Serializable {
    public static final String REVIEWER_COMMENTS_MAP_KEY = "reviewerComments";
    public static final String REVIEWER_ATTACHMENTS_MAP_KEY = "reviewerAttachments";
    public static final String DOCUMENT_MAP_KEY = "document";
    public static final String FORM_MAP_KEY = "kualiForm";
    private static final long serialVersionUID = 1L;
    private ProtocolFormBase form;
    private Long newProtocolReviewCommitteeMembershipId;
    private String newReviewerTypeCode;
    private Date newReviewDateRequested;
    private Date newReviewDateDue;
    private String newReviewDocumentDescription;
    private String newReviewExplanation;
    private String newReviewOrganizationDocumentNumber;
    private Map<String, Map<String, Object>> documentHelperMap;
    private List<ProtocolOnlineReviewDocumentBase> protocolOnlineReviewDocuments;
    private List<ReviewCommentsBeanBase> reviewCommentsBeans;
    private List<ReviewAttachmentsBeanBase> reviewAttachmentsBeans;
    private boolean initComplete = false;
    private transient KcPersonService kcPersonService;
    private static Log LOG = LogFactory.getLog(OnlineReviewsActionHelperBase.class);
    private static final String REVIEW_DOCUMENT_DESCRIPTION_FORMAT = "Review ProtocolBase:%s, PI:%s";
    private boolean hideReviewerName;
    private boolean hideReviewerNameForAttachment;

    public OnlineReviewsActionHelperBase(ProtocolFormBase form) {
        this.form = form;
        this.newReviewDateRequested = new Date(new java.util.Date().getTime());
        this.init(false);
    }

    public void init(boolean force) {
        ProtocolSubmissionBase currentSubmission;
        if ((!this.initComplete || force) && (currentSubmission = this.form.getProtocolDocument().getProtocol().getProtocolSubmission()) != null) {
            ProtocolDocumentBase protocolDocument = this.form.getProtocolDocument();
            ProtocolPersonBase principalInvestigator = protocolDocument.getProtocol().getPrincipalInvestigator();
            this.newReviewDateRequested = new Date(new java.util.Date().getTime());
            this.protocolOnlineReviewDocuments = this.getProtocolOnlineReviewService().getProtocolReviewDocumentsForCurrentSubmission(protocolDocument.getProtocol());
            this.reviewCommentsBeans = new ArrayList<ReviewCommentsBeanBase>();
            this.reviewAttachmentsBeans = new ArrayList<ReviewAttachmentsBeanBase>();
            this.documentHelperMap = new LinkedHashMap<String, Map<String, Object>>();
            if (principalInvestigator != null) {
                String piLastName = principalInvestigator.getLastName();
                this.newReviewDocumentDescription = this.getProtocolOnlineReviewService().getProtocolOnlineReviewDocumentDescription(protocolDocument.getProtocol().getProtocolNumber(), piLastName);
            }
            List<String> reviewerIds = this.getReviewerIds();
            for (ProtocolOnlineReviewDocumentBase pDoc : this.protocolOnlineReviewDocuments) {
                LinkedHashMap<String, Object> pDocMap = new LinkedHashMap<String, Object>();
                this.documentHelperMap.put(pDoc.getDocumentNumber(), pDocMap);
                pDocMap.put(DOCUMENT_MAP_KEY, (Object)pDoc);
                try {
                    ProtocolOnlineReviewFormBase poForm = this.getNewProtocolOnlineReviewFormInstanceHook();
                    poForm.setDocument((Document)pDoc);
                    this.populateAuthorizationFields(poForm, pDoc);
                    pDocMap.put(FORM_MAP_KEY, poForm);
                }
                catch (Exception e) {
                    LOG.error((Object)String.format("Exception generated creating new instance of ProtocolOnlineReviewFormBase with document %s", pDoc.getDocumentNumber()), (Throwable)e);
                    throw new RuntimeException(String.format("Exception generated creating new instance of ProtocolOnlineReviewFormBase with document %s", pDoc.getDocumentNumber()), e);
                }
                ReviewCommentsBeanBase commentsBean = this.getNewReviewCommentsBeanInstanceHook("");
                commentsBean.setReviewComments(pDoc.getProtocolOnlineReview().getCommitteeScheduleMinutes());
                pDocMap.put(REVIEWER_COMMENTS_MAP_KEY, commentsBean);
                this.reviewCommentsBeans.add(commentsBean);
                ReviewAttachmentsBeanBase attachmentsBean = this.getNewReviewAttachmentsBeanHook("onlineReviewsActionHelper");
                attachmentsBean.setReviewAttachments(pDoc.getProtocolOnlineReview().getReviewAttachments());
                pDocMap.put(REVIEWER_ATTACHMENTS_MAP_KEY, attachmentsBean);
                this.reviewAttachmentsBeans.add(attachmentsBean);
            }
            this.initComplete = true;
        }
        for (ReviewCommentsBeanBase commentsBean : this.reviewCommentsBeans) {
            commentsBean.setHideReviewerName(this.getReviewerCommentsService().setHideReviewerName(commentsBean.getReviewComments()));
        }
        for (ReviewAttachmentsBeanBase attachmentsBean : this.reviewAttachmentsBeans) {
            attachmentsBean.setHideReviewerName(this.getReviewerCommentsService().setHideReviewerName(attachmentsBean.getReviewAttachments()));
        }
    }

    protected abstract ProtocolOnlineReviewFormBase getNewProtocolOnlineReviewFormInstanceHook() throws Exception;

    protected abstract ReviewAttachmentsBeanBase getNewReviewAttachmentsBeanHook(String var1);

    protected abstract ReviewCommentsBeanBase getNewReviewCommentsBeanInstanceHook(String var1);

    private List<String> getReviewerIds() {
        ArrayList<String> reviewerIds = new ArrayList<String>();
        for (ProtocolOnlineReviewDocumentBase pDoc : this.protocolOnlineReviewDocuments) {
            reviewerIds.add(pDoc.getProtocolOnlineReview().getProtocolReviewer().getPersonId());
        }
        return reviewerIds;
    }

    public List<ProtocolOnlineReviewBase> getCurrentProtocolOnlineReviews() {
        ArrayList<ProtocolOnlineReviewBase> reviews = new ArrayList<ProtocolOnlineReviewBase>();
        Iterator<Map<String, Object>> it = this.documentHelperMap.values().iterator();
        while (it.hasNext()) {
            reviews.add(((ProtocolOnlineReviewDocumentBase)((Object)it.next().get(DOCUMENT_MAP_KEY))).getProtocolOnlineReview());
        }
        return reviews;
    }

    public List<CommitteeMembershipBase> getAvailableCommitteeMembersForCurrentSubmission() {
        List<CommitteeMembershipBase> members = this.getProtocolOnlineReviewService().getAvailableCommitteeMembersForCurrentSubmission(this.form.getProtocolDocument().getProtocol());
        return members;
    }

    public List<ProtocolOnlineReviewDocumentBase> getProtocolOnlineReviewsForCurrentSubmission() {
        return this.protocolOnlineReviewDocuments;
    }

    public String getNewReviewOrganizationDocumentNumber() {
        return this.newReviewOrganizationDocumentNumber;
    }

    public void setNewReviewOrganizationDocumentNumber(String newReviewOrganizationDocumentNumber) {
        this.newReviewOrganizationDocumentNumber = newReviewOrganizationDocumentNumber;
    }

    public Date getNewReviewDateRequested() {
        return this.newReviewDateRequested;
    }

    public void setNewReviewDateRequested(Date newReviewDateRequested) {
        this.newReviewDateRequested = newReviewDateRequested;
    }

    public Date getNewReviewDateDue() {
        return this.newReviewDateDue;
    }

    public void setNewReviewDateDue(Date newReviewDateDue) {
        this.newReviewDateDue = newReviewDateDue;
    }

    public String getNewReviewerTypeCode() {
        return this.newReviewerTypeCode;
    }

    public void setNewReviewerTypeCode(String newReviewerTypeCode) {
        this.newReviewerTypeCode = newReviewerTypeCode;
    }

    public String getNewReviewDocumentDescription() {
        return this.newReviewDocumentDescription;
    }

    public void setNewReviewDocumentDescription(String newReviewDocumentDescription) {
        this.newReviewDocumentDescription = newReviewDocumentDescription;
    }

    public String getNewReviewExplanation() {
        return this.newReviewExplanation;
    }

    public void setNewReviewExplanation(String newReviewExplanation) {
        this.newReviewExplanation = newReviewExplanation;
    }

    public List<ProtocolOnlineReviewDocumentBase> getProtocolOnlineReviewDocuments() {
        return this.protocolOnlineReviewDocuments;
    }

    public void setProtocolOnlineReviewDocuments(List<ProtocolOnlineReviewDocumentBase> protocolOnlineReviewDocuments) {
        this.protocolOnlineReviewDocuments = protocolOnlineReviewDocuments;
    }

    private ProtocolOnlineReviewService getProtocolOnlineReviewService() {
        return KraServiceLocator.getService(this.getProtocolOnlineReviewServiceClassHook());
    }

    protected abstract Class<? extends ProtocolOnlineReviewService> getProtocolOnlineReviewServiceClassHook();

    public Long getNewProtocolReviewCommitteeMembershipId() {
        return this.newProtocolReviewCommitteeMembershipId;
    }

    public void setNewProtocolReviewCommitteeMembershipId(Long newProtocolReviewCommitteeMembershipId) {
        this.newProtocolReviewCommitteeMembershipId = newProtocolReviewCommitteeMembershipId;
    }

    public List<ReviewCommentsBeanBase> getReviewCommentsBeans() {
        return this.reviewCommentsBeans;
    }

    public void setReviewCommentsBeans(List<ReviewCommentsBeanBase> reviewCommentsBeans) {
        this.reviewCommentsBeans = reviewCommentsBeans;
    }

    public Map<String, Map<String, Object>> getDocumentHelperMap() {
        this.init(false);
        return this.documentHelperMap;
    }

    public void setDocumentHelperMap(Map<String, Map<String, Object>> documentHelperMap) {
        this.documentHelperMap = documentHelperMap;
    }

    public Map<String, Object> getHelperMapByDocumentNumber(String documentNumber) {
        Map<String, Object> helperMap = this.documentHelperMap.get(documentNumber);
        if (helperMap == null) {
            throw new IllegalArgumentException(String.format("Document %s does not exist in the helper map.", documentNumber));
        }
        return helperMap;
    }

    public long getIndexByDocumentNumber(String documentNumber) {
        ProtocolOnlineReviewDocumentBase document = this.getDocumentFromHelperMap(documentNumber);
        return this.protocolOnlineReviewDocuments.indexOf((Object)document);
    }

    public ProtocolOnlineReviewDocumentBase getDocumentFromHelperMap(String documentNumber) {
        ProtocolOnlineReviewDocumentBase protocolDocument = (ProtocolOnlineReviewDocumentBase)((Object)this.getHelperMapByDocumentNumber(documentNumber).get(DOCUMENT_MAP_KEY));
        if (protocolDocument == null) {
            throw new IllegalStateException(String.format("Document %s was not stored in the helper map.", documentNumber));
        }
        if (protocolDocument.getProtocolOnlineReview().getDateRequested() == null) {
            protocolDocument.getProtocolOnlineReview().setDateRequested(new Date(new java.util.Date().getTime()));
        }
        return protocolDocument;
    }

    public ReviewCommentsBeanBase getReviewCommentsBeanFromHelperMap(String documentNumber) {
        ReviewCommentsBeanBase bean = (ReviewCommentsBeanBase)this.getHelperMapByDocumentNumber(documentNumber).get(REVIEWER_COMMENTS_MAP_KEY);
        if (bean == null) {
            throw new IllegalStateException(String.format("ReviewerCommentsBean for document %s was not stored in the helper map.", documentNumber));
        }
        return bean;
    }

    public ReviewAttachmentsBeanBase getReviewAttachmentsBeanFromHelperMap(String documentNumber) {
        ReviewAttachmentsBeanBase bean = (ReviewAttachmentsBeanBase)this.getHelperMapByDocumentNumber(documentNumber).get(REVIEWER_ATTACHMENTS_MAP_KEY);
        if (bean == null) {
            throw new IllegalStateException(String.format("ReviewAttachmentsBeanBase for document %s was not stored in the helper map.", documentNumber));
        }
        return bean;
    }

    public int getDocumentIndexByReviewer(String personId, boolean nonEmployeeFlag) {
        ProtocolOnlineReviewDocumentBase reviewDocument;
        ProtocolReviewer reviewer;
        int idx = 0;
        Iterator<ProtocolOnlineReviewDocumentBase> i$ = this.protocolOnlineReviewDocuments.iterator();
        while (i$.hasNext() && !(reviewer = (reviewDocument = i$.next()).getProtocolOnlineReview().getProtocolReviewer()).isPersonIdProtocolReviewer(personId, nonEmployeeFlag)) {
            ++idx;
        }
        return idx;
    }

    public String getDocumentNumberByReviewer(String personId, boolean nonEmployeeFlag) {
        int idx = this.getDocumentIndexByReviewer(personId, nonEmployeeFlag);
        return this.protocolOnlineReviewDocuments.get(idx).getDocumentNumber();
    }

    public ProtocolOnlineReviewDocumentBase getDocumentByReviewer(String personId, boolean nonEmployeeFlag) {
        return this.getDocumentFromHelperMap(this.getDocumentNumberByReviewer(personId, nonEmployeeFlag));
    }

    public String getDocumentNumberForCurrentUser() {
        return this.getDocumentNumberByReviewer(GlobalVariables.getUserSession().getPrincipalId(), false);
    }

    public ProtocolOnlineReviewDocumentBase getDocumentForCurrentUser() {
        return this.getDocumentByReviewer(GlobalVariables.getUserSession().getPrincipalId(), false);
    }

    public int getDocumentIndexForCurrentUser() {
        return this.getDocumentIndexByReviewer(GlobalVariables.getUserSession().getPrincipalId(), false);
    }

    private KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KraServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    private DocumentHelperService getDocumentHelperService() {
        return KraServiceLocator.getService(DocumentHelperService.class);
    }

    private DataDictionaryService getDataDictionaryService() {
        return KraServiceLocator.getService(DataDictionaryService.class);
    }

    private boolean requiresLock(Document document) {
        return this.getDataDictionaryService().getDataDictionary().getDocumentEntry(document.getClass().getName()).getUsePessimisticLocking();
    }

    protected Map convertSetToMap(Set s) {
        HashMap map = new HashMap();
        for (Object key : s) {
            map.put(key, "true");
        }
        return map;
    }

    private PessimisticLockService getPessimisticLockService() {
        return KraServiceLocator.getService(PessimisticLockService.class);
    }

    private RolodexService getRolodexService() {
        return KraServiceLocator.getService(RolodexService.class);
    }

    protected void populateAuthorizationFields(ProtocolOnlineReviewFormBase form, ProtocolOnlineReviewDocumentBase document) {
        if (form.isFormDocumentInitialized()) {
            Person user = GlobalVariables.getUserSession().getPerson();
            KcTransactionalDocumentAuthorizerBase documentAuthorizer = (KcTransactionalDocumentAuthorizerBase)this.getDocumentHelperService().getDocumentAuthorizer((Document)document);
            Set<String> editModes = new HashSet<String>();
            form.setupLockRegions();
            String activeLockRegion = (String)GlobalVariables.getUserSession().retrieveObject("ACTIVE_LOCK_REGION");
            if (!documentAuthorizer.canOpen((Document)document, user)) {
                editModes.add("unviewable");
            } else {
                document.setViewOnly(form.isViewOnly());
                editModes = documentAuthorizer.getEditModes((Document)document, user, null);
                Set<String> documentActions = documentAuthorizer.getDocumentActions((Document)document, user, null);
                form.setDocumentActions(this.convertSetToMap(documentActions));
            }
            form.setEditingMode(this.convertSetToMap(editModes));
        }
    }

    private ReviewCommentsService getReviewerCommentsService() {
        return KraServiceLocator.getService(this.getReviewCommentsServiceClassHook());
    }

    protected abstract Class<? extends ReviewCommentsService> getReviewCommentsServiceClassHook();

    public boolean isHideReviewerName() {
        return this.hideReviewerName;
    }

    public void setHideReviewerName(boolean hideReviewerName) {
        this.hideReviewerName = hideReviewerName;
    }

    public List<ReviewAttachmentsBeanBase> getReviewAttachmentsBeans() {
        return this.reviewAttachmentsBeans;
    }

    public void setReviewAttachmentsBeans(List<ReviewAttachmentsBeanBase> reviewAttachmentsBeans) {
        this.reviewAttachmentsBeans = reviewAttachmentsBeans;
    }

    public boolean isHideReviewerNameForAttachment() {
        return this.hideReviewerNameForAttachment;
    }

    public void setHideReviewerNameForAttachment(boolean hideReviewerNameForAttachment) {
        this.hideReviewerNameForAttachment = hideReviewerNameForAttachment;
    }
}

