/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.onlinereview;

import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.common.committee.bo.CommitteeMembershipBase;
import org.kuali.kra.common.committee.meeting.CommitteeScheduleMinuteBase;
import org.kuali.kra.common.committee.service.CommitteeServiceBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.kew.KraDocumentRejectionService;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolFinderDao;
import org.kuali.kra.protocol.ProtocolOnlineReviewDocumentBase;
import org.kuali.kra.protocol.actions.assignreviewers.ProtocolAssignReviewersService;
import org.kuali.kra.protocol.actions.reviewcomments.ReviewCommentsService;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewer;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewBase;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewService;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.kra.service.KraWorkflowService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.workflow.service.WorkflowDocumentService;

public abstract class ProtocolOnlineReviewServiceImplBase
implements ProtocolOnlineReviewService {
    private static final Log LOG = LogFactory.getLog(ProtocolOnlineReviewServiceImplBase.class);
    protected BusinessObjectService businessObjectService;
    protected DocumentService documentService;
    protected KraAuthorizationService kraAuthorizationService;
    protected ProtocolAssignReviewersService protocolAssignReviewersService;
    protected IdentityService identityManagementService;
    protected CommitteeServiceBase committeeService;
    protected KraDocumentRejectionService kraDocumentRejectionService;
    protected ProtocolFinderDao protocolFinderDao;
    protected ReviewCommentsService reviewCommentsService;
    protected WorkflowDocumentService workflowDocumentService;
    protected String reviewerApproveNodeName;
    protected PersonService personService;

    @Override
    public ProtocolOnlineReviewDocumentBase createAndRouteProtocolOnlineReviewDocument(ProtocolSubmissionBase protocolSubmission, ProtocolReviewer protocolReviewer, String documentDescription, String documentExplanation, String documentOrganizationDocumentNumber, String documentRouteAnnotation, boolean initialApproval, Date dateRequested, Date dateDue, String principalId) {
        ProtocolOnlineReviewDocumentBase document = null;
        try {
            if (LOG.isDebugEnabled()) {
                String protocolNumber = protocolSubmission.getProtocolNumber();
                Integer submissionNumber = protocolSubmission.getSubmissionNumber();
                LOG.debug((Object)String.format("Assigning online reviewer [%s] to protocol [%s].", new Object[]{protocolReviewer, protocolNumber}));
                LOG.debug((Object)String.format("Current submission for protocol %s is %s.", protocolNumber, submissionNumber));
            }
            document = this.createProtocolOnlineReviewDocument(protocolSubmission, protocolReviewer, documentDescription, documentExplanation, documentOrganizationDocumentNumber, dateRequested, dateDue, principalId);
            this.documentService.routeDocument((Document)document, "Review Requested by PI during protocol submission.", new ArrayList());
            if (initialApproval) {
                this.documentService.approveDocument((Document)document, "", new ArrayList());
            }
        }
        catch (WorkflowException e) {
            String errorString = String.format("WorkflowException creating new ProtocolOnlineReviewDocumentBase for reviewer %s, protocol %s", protocolReviewer.getPersonId(), protocolSubmission.getProtocolNumber());
            LOG.error((Object)errorString, (Throwable)e);
            throw new RuntimeException(errorString, e);
        }
        return document;
    }

    protected ProtocolOnlineReviewDocumentBase createProtocolOnlineReviewDocument(ProtocolSubmissionBase protocolSubmission, ProtocolReviewer protocolReviewer, String documentDescription, String documentExplanation, String documentOrganizationDocumentNumber, Date dateRequested, Date dateDue, String principalId) throws WorkflowException {
        Person person = this.personService.getPerson(principalId);
        WorkflowDocument workflowDocument = this.workflowDocumentService.createWorkflowDocument(this.getProtocolOLRDocumentTypeHook(), person);
        DocumentHeader docHeader = new DocumentHeader();
        docHeader.setWorkflowDocument(workflowDocument);
        docHeader.setDocumentNumber(workflowDocument.getDocumentId().toString());
        ProtocolOnlineReviewDocumentBase protocolReviewDocument = this.getNewProtocolOnlineReviewDocumentInstanceHook();
        protocolReviewDocument.setDocumentNumber(docHeader.getDocumentNumber());
        protocolReviewDocument.setDocumentHeader(docHeader);
        protocolReviewDocument.getProtocolOnlineReview().setProtocol(protocolSubmission.getProtocol());
        protocolReviewDocument.getProtocolOnlineReview().setProtocolId(protocolSubmission.getProtocolId());
        protocolReviewDocument.getProtocolOnlineReview().setProtocolSubmission(protocolSubmission);
        protocolReviewDocument.getProtocolOnlineReview().setSubmissionIdFk(protocolSubmission.getSubmissionId());
        protocolReviewDocument.getProtocolOnlineReview().setProtocolOnlineReviewStatusCode(this.getProtocolOLRSavedStatusCodeHook());
        protocolReviewDocument.getProtocolOnlineReview().setDateRequested(dateRequested == null ? new Date(new java.util.Date().getTime()) : dateRequested);
        protocolReviewDocument.getProtocolOnlineReview().setDateDue(dateDue);
        protocolReviewDocument.getProtocolOnlineReview().setProtocolReviewerId(protocolReviewer.getProtocolReviewerId());
        protocolReviewDocument.getProtocolOnlineReview().setProtocolReviewer(protocolReviewer);
        docHeader.setDocumentDescription(documentDescription);
        docHeader.setOrganizationDocumentNumber(documentOrganizationDocumentNumber);
        docHeader.setExplanation(documentExplanation);
        this.documentService.saveDocument((Document)protocolReviewDocument);
        return protocolReviewDocument;
    }

    protected abstract ProtocolOnlineReviewDocumentBase getNewProtocolOnlineReviewDocumentInstanceHook();

    protected abstract String getProtocolOLRSavedStatusCodeHook();

    protected abstract String getProtocolOLRDocumentTypeHook();

    @Override
    public ProtocolReviewer createProtocolReviewer(String principalId, boolean nonEmployeeFlag, String reviewerTypeCode, ProtocolSubmissionBase protocolSubmission) {
        ProtocolReviewer reviewer = this.createNewProtocolReviewerInstanceHook();
        reviewer.setProtocolIdFk(protocolSubmission.getProtocolId());
        reviewer.setSubmissionIdFk(protocolSubmission.getSubmissionId());
        reviewer.setProtocolNumber(protocolSubmission.getProtocolNumber());
        reviewer.setSequenceNumber(protocolSubmission.getSequenceNumber());
        reviewer.setSubmissionNumber(protocolSubmission.getSubmissionNumber());
        if (!nonEmployeeFlag) {
            reviewer.setPersonId(principalId);
        } else {
            reviewer.setRolodexId(Integer.parseInt(principalId));
        }
        reviewer.setNonEmployeeFlag(nonEmployeeFlag);
        reviewer.setReviewerTypeCode(reviewerTypeCode);
        this.businessObjectService.save((PersistableBusinessObject)reviewer);
        return reviewer;
    }

    protected abstract ProtocolReviewer createNewProtocolReviewerInstanceHook();

    @Override
    public List<ProtocolOnlineReviewDocumentBase> getProtocolReviewDocumentsForCurrentSubmission(ProtocolBase protocol) {
        ArrayList<ProtocolOnlineReviewDocumentBase> onlineReviewDocuments = new ArrayList<ProtocolOnlineReviewDocumentBase>();
        ProtocolSubmissionBase submission = protocol.getProtocolSubmission();
        List<ProtocolOnlineReviewBase> reviews = this.findProtocolOnlineReviews(protocol.getProtocolId(), submission.getSubmissionId());
        for (ProtocolOnlineReviewBase review : reviews) {
            if (!review.isActive()) continue;
            review.refresh();
            try {
                onlineReviewDocuments.add((ProtocolOnlineReviewDocumentBase)this.documentService.getByDocumentHeaderId(review.getProtocolOnlineReviewDocument().getDocumentNumber()));
            }
            catch (WorkflowException e) {
                throw new RuntimeException(String.format("Could not load ProtocolOnlineReviewBase docuemnt %s due to WorkflowException: %s", review.getProtocolOnlineReviewDocument().getDocumentNumber(), e.getMessage()), e);
            }
        }
        return onlineReviewDocuments;
    }

    @Override
    public List<CommitteeMembershipBase> getAvailableCommitteeMembersForCurrentSubmission(ProtocolBase protocol) {
        ArrayList<CommitteeMembershipBase> results = new ArrayList<CommitteeMembershipBase>();
        ProtocolSubmissionBase submission = protocol.getProtocolSubmission();
        submission.refreshReferenceObject("protocolOnlineReviews");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Fetching available committee members for protocol %s, submission %s", protocol.getProtocolNumber(), submission.getSubmissionNumber()));
        }
        List<ProtocolOnlineReviewBase> currentReviews = submission.getProtocolOnlineReviews();
        List<CommitteeMembershipBase> committeeMembers = this.getCommitteeService().getAvailableMembers(submission.getCommitteeId(), submission.getScheduleId());
        for (CommitteeMembershipBase member : committeeMembers) {
            boolean found = false;
            for (ProtocolOnlineReviewBase review : currentReviews) {
                if (!review.getProtocolReviewer().isProtocolReviewerFromCommitteeMembership(member) || !review.isActive()) continue;
                found = true;
                break;
            }
            if (found || this.isProtocolPersonnel(protocol, member)) continue;
            results.add(member);
        }
        return results;
    }

    @Override
    public List<ProtocolOnlineReviewBase> getProtocolReviews(String protocolNumber) {
        ProtocolBase protocol = this.protocolFinderDao.findCurrentProtocolByNumber(protocolNumber);
        List<ProtocolOnlineReviewBase> reviews = null;
        reviews = protocol != null && protocol.getProtocolSubmission() != null ? protocol.getProtocolSubmission().getProtocolOnlineReviews() : new ArrayList<ProtocolOnlineReviewBase>();
        return reviews;
    }

    @Override
    public List<ProtocolOnlineReviewBase> getProtocolReviews(Long submissionId) {
        ArrayList<ProtocolOnlineReviewBase> reviews = new ArrayList<ProtocolOnlineReviewBase>();
        ProtocolSubmissionBase submission = (ProtocolSubmissionBase)this.getBusinessObjectService().findBySinglePrimaryKey(this.getProtocolSubmissionBOClassHook(), (Object)submissionId);
        if (submission != null) {
            for (ProtocolOnlineReviewBase review : submission.getProtocolOnlineReviews()) {
                if (!review.isActive()) continue;
                reviews.add(review);
            }
        }
        return reviews;
    }

    protected abstract Class<? extends ProtocolSubmissionBase> getProtocolSubmissionBOClassHook();

    @Override
    public ProtocolReviewer getProtocolReviewer(String personId, boolean nonEmployeeFlag, ProtocolSubmissionBase protocolSubmission) {
        ProtocolReviewer protocolReviewer = null;
        if (protocolSubmission != null) {
            for (ProtocolOnlineReviewBase protocolOnlineReview : protocolSubmission.getProtocolOnlineReviews()) {
                if (!protocolOnlineReview.getProtocolReviewer().isPersonIdProtocolReviewer(personId, nonEmployeeFlag) || !protocolOnlineReview.isActive()) continue;
                protocolReviewer = protocolOnlineReview.getProtocolReviewer();
                break;
            }
        }
        return protocolReviewer;
    }

    @Override
    public ProtocolOnlineReviewDocumentBase getProtocolOnlineReviewDocument(String personId, boolean nonEmployeeFlag, ProtocolSubmissionBase protocolSubmission) {
        ProtocolOnlineReviewDocumentBase protocolOnlineReviewDocument = null;
        if (protocolSubmission != null) {
            for (ProtocolOnlineReviewBase protocolOnlineReview : protocolSubmission.getProtocolOnlineReviews()) {
                if (!protocolOnlineReview.getProtocolReviewer().isPersonIdProtocolReviewer(personId, nonEmployeeFlag) || !protocolOnlineReview.isActive()) continue;
                try {
                    protocolOnlineReviewDocument = (ProtocolOnlineReviewDocumentBase)this.getDocumentService().getByDocumentHeaderId(protocolOnlineReview.getProtocolOnlineReviewDocument().getDocumentNumber());
                }
                catch (WorkflowException e) {
                    if (!LOG.isDebugEnabled()) continue;
                    String errorMessage = String.format("WorkflowException encountered while looking up document number %s for ProtocolOnlineReviewDocumentBase associated with (submissionId=%s,personId=%s,nonEmployeeFlag=%s", protocolOnlineReview.getProtocolOnlineReviewDocument().getDocumentNumber(), protocolSubmission.getSubmissionId(), personId, nonEmployeeFlag);
                    LOG.error((Object)errorMessage, (Throwable)e);
                    throw new RuntimeException(errorMessage, e);
                }
            }
        }
        return protocolOnlineReviewDocument;
    }

    @Override
    public boolean isProtocolReviewer(String personId, boolean nonEmployeeFlag, ProtocolSubmissionBase protocolSubmission) {
        boolean isReviewer = false;
        if (protocolSubmission != null) {
            for (ProtocolOnlineReviewBase review : protocolSubmission.getProtocolOnlineReviews()) {
                if (!review.getProtocolReviewer().isPersonIdProtocolReviewer(personId, nonEmployeeFlag) || !review.isActive()) continue;
                isReviewer = true;
                break;
            }
        }
        return isReviewer;
    }

    @Override
    public void returnProtocolOnlineReviewDocumentToReviewer(ProtocolOnlineReviewDocumentBase reviewDocument, String reason, String principalId) {
        this.kraDocumentRejectionService.reject((Document)reviewDocument, reason, principalId, null, this.reviewerApproveNodeName);
    }

    protected List<ProtocolOnlineReviewBase> findProtocolOnlineReviews(Long protocolId, Long submissionIdFk) {
        ArrayList<ProtocolOnlineReviewBase> reviews = new ArrayList<ProtocolOnlineReviewBase>();
        if (protocolId != null && submissionIdFk != null) {
            HashMap<String, Long> hashMap = new HashMap<String, Long>();
            hashMap.put("protocolId", protocolId);
            hashMap.put("submissionIdFk", submissionIdFk);
            reviews.addAll(this.getBusinessObjectService().findMatchingOrderBy(this.getProtocolOnlineReviewBOClassHook(), hashMap, "dateRequested", false));
        }
        return reviews;
    }

    protected abstract Class<? extends ProtocolOnlineReviewBase> getProtocolOnlineReviewBOClassHook();

    protected void cancelOnlineReviewDocument(ProtocolOnlineReviewDocumentBase protocolOnlineReviewDocument, ProtocolSubmissionBase submission, String annotation) {
        try {
            String principalId = this.identityManagementService.getPrincipalByPrincipalName("kr").getPrincipalId();
            WorkflowDocument workflowDocument = WorkflowDocumentFactory.loadDocument((String)principalId, (String)protocolOnlineReviewDocument.getDocumentNumber());
            if (workflowDocument.isEnroute() || workflowDocument.isInitiated() || workflowDocument.isSaved()) {
                workflowDocument.superUserCancel(String.format("Review Cancelled from assign reviewers action by %s", GlobalVariables.getUserSession().getPrincipalId()));
            }
        }
        catch (Exception e) {
            String errorMessage = String.format("Exception generated while executing superUserCancel on document %s in removeOnlineReviewDocument. Message: %s", protocolOnlineReviewDocument.getDocumentNumber(), e.getMessage());
            LOG.error((Object)errorMessage);
            throw new RuntimeException(errorMessage, e);
        }
    }

    protected void finalizeOnlineReviewDocument(ProtocolOnlineReviewDocumentBase protocolOnlineReviewDocument, ProtocolSubmissionBase submission, String annotation) {
        try {
            String principalId = this.identityManagementService.getPrincipalByPrincipalName("kr").getPrincipalId();
            WorkflowDocument workflowDocument = WorkflowDocumentFactory.loadDocument((String)principalId, (String)protocolOnlineReviewDocument.getDocumentNumber());
            ProtocolOnlineReviewBase review = protocolOnlineReviewDocument.getProtocolOnlineReview();
            review.addActionPerformed("Finalize:" + workflowDocument.getStatus().getCode() + ":" + review.getProtocolOnlineReviewStatusCode());
            if (workflowDocument.isEnroute() || workflowDocument.isInitiated() || workflowDocument.isSaved()) {
                workflowDocument.superUserBlanketApprove(annotation);
            }
        }
        catch (Exception e) {
            String errorMessage = String.format("Workflow exception generated while executing superUserApprove on document %s in finalizeOnlineReviewDocument. Message:%s", protocolOnlineReviewDocument.getDocumentNumber(), e.getMessage());
            LOG.error((Object)errorMessage);
            throw new RuntimeException(errorMessage, e);
        }
    }

    protected void removeOnlineReviewDocument(ProtocolOnlineReviewDocumentBase protocolOnlineReviewDocument, ProtocolSubmissionBase submission, String annotation) {
    }

    @Override
    public void removeOnlineReviewDocument(String personId, boolean nonEmployeeFlag, ProtocolSubmissionBase submission, String annotation) {
        ProtocolOnlineReviewDocumentBase protocolOnlineReviewDocument = this.getProtocolOnlineReviewDocument(personId, nonEmployeeFlag, submission);
        ProtocolOnlineReviewBase submissionsProtocolOnlineReview = null;
        for (ProtocolOnlineReviewBase rev : submission.getProtocolOnlineReviews()) {
            if (!rev.getProtocolOnlineReviewId().equals(protocolOnlineReviewDocument.getProtocolOnlineReview().getProtocolOnlineReviewId())) continue;
            submissionsProtocolOnlineReview = rev;
            break;
        }
        if (submissionsProtocolOnlineReview == null) {
            throw new IllegalStateException("Could not match OnlineReview document being removed to a protocolOnlineReview in the submission.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Processing request to remove online review for (personId=%s,nonEmployeeFlag=%s) from (protocol=%s,submission=%s)", personId, nonEmployeeFlag, submission.getProtocol().getProtocolNumber(), submission.getSubmissionNumber()));
        }
        if (protocolOnlineReviewDocument != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("Found protocolOnlineReviewDocument %s, removing it.", protocolOnlineReviewDocument.getDocumentNumber()));
            }
            this.cancelOnlineReviewDocument(protocolOnlineReviewDocument, submission, annotation);
            submissionsProtocolOnlineReview.setProtocolOnlineReviewStatusCode(this.getProtocolOLRRemovedCancelledStatusCodeHook());
            List<CommitteeScheduleMinuteBase> reviewComments = protocolOnlineReviewDocument.getProtocolOnlineReview().getCommitteeScheduleMinutes();
            ArrayList<CommitteeScheduleMinuteBase> deletedReviewComments = new ArrayList<CommitteeScheduleMinuteBase>();
            this.getReviewerCommentsService().deleteAllReviewComments(reviewComments, deletedReviewComments);
            this.getReviewerCommentsService().saveReviewComments(reviewComments, deletedReviewComments);
            this.getBusinessObjectService().save((PersistableBusinessObject)submissionsProtocolOnlineReview);
        } else {
            LOG.warn((Object)String.format("ProtocolBase Online Review document could not be found for (personId=%s,nonEmployeeFlag=%s) from (protocol=%s,submission=%s)", personId, nonEmployeeFlag, submission.getProtocol().getProtocolNumber(), submission.getSubmissionNumber()));
        }
    }

    protected abstract String getProtocolOLRRemovedCancelledStatusCodeHook();

    @Override
    public void cancelOnlineReviews(ProtocolSubmissionBase submission, String annotation) {
        for (ProtocolOnlineReviewBase review : submission.getProtocolOnlineReviews()) {
            this.cancelOnlineReviewDocument(review.getProtocolOnlineReviewDocument(), submission, annotation);
        }
    }

    @Override
    public void finalizeOnlineReviews(ProtocolSubmissionBase submission, String annotation) {
        for (ProtocolOnlineReviewBase review : submission.getProtocolOnlineReviews()) {
            this.finalizeOnlineReviewDocument(review.getProtocolOnlineReviewDocument(), submission, annotation);
        }
    }

    @Override
    public void removeOnlineReviews(ProtocolSubmissionBase submission, String annotation) {
        for (ProtocolOnlineReviewBase review : submission.getProtocolOnlineReviews()) {
            this.removeOnlineReviewDocument(review.getProtocolOnlineReviewDocument(), submission, annotation);
        }
    }

    @Override
    public void moveOnlineReviews(ProtocolSubmissionBase submission, ProtocolSubmissionBase newSubmission) {
        newSubmission.setProtocolOnlineReviews(new ArrayList<ProtocolOnlineReviewBase>());
        for (ProtocolOnlineReviewBase review : submission.getProtocolOnlineReviews()) {
            review.setProtocol(newSubmission.getProtocol());
            review.setProtocolId(newSubmission.getProtocol().getProtocolId());
            review.setSubmissionIdFk(newSubmission.getSubmissionId());
            if (CollectionUtils.isNotEmpty(review.getCommitteeScheduleMinutes())) {
                for (CommitteeScheduleMinuteBase comment : review.getCommitteeScheduleMinutes()) {
                    comment.setProtocolIdFk(review.getProtocolId());
                    comment.setScheduleIdFk(newSubmission.getScheduleIdFk());
                }
            }
            newSubmission.getProtocolOnlineReviews().add(review);
        }
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setKraAuthorizationService(KraAuthorizationService kraAuthorizationService) {
        this.kraAuthorizationService = kraAuthorizationService;
    }

    public KraAuthorizationService getKraAuthorizationService() {
        return this.kraAuthorizationService;
    }

    public void setProtocolAssignReviewersService(ProtocolAssignReviewersService protocolAssignReviewersService) {
        this.protocolAssignReviewersService = protocolAssignReviewersService;
    }

    public ProtocolAssignReviewersService getProtocolAssignReviewersService() {
        return this.protocolAssignReviewersService;
    }

    public WorkflowDocumentService getWorkflowDocumentService() {
        return KraServiceLocator.getService(WorkflowDocumentService.class);
    }

    public KraWorkflowService getKraWorkflowService() {
        return KraServiceLocator.getService(KraWorkflowService.class);
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setIdentityManagementService(IdentityService identityManagementService) {
        this.identityManagementService = identityManagementService;
    }

    public CommitteeServiceBase getCommitteeService() {
        return this.committeeService;
    }

    public void setCommitteeService(CommitteeServiceBase committeeService) {
        this.committeeService = committeeService;
    }

    public String getReviewerApproveNodeName() {
        return this.reviewerApproveNodeName;
    }

    public void setReviewerApproveNodeName(String reviewerApproveNodeName) {
        this.reviewerApproveNodeName = reviewerApproveNodeName;
    }

    public KraDocumentRejectionService getKraDocumentRejectionService() {
        return this.kraDocumentRejectionService;
    }

    public void setKraDocumentRejectionService(KraDocumentRejectionService kraDocumentRejectionService) {
        this.kraDocumentRejectionService = kraDocumentRejectionService;
    }

    public void setProtocolFinderDao(ProtocolFinderDao protocolFinderDao) {
        this.protocolFinderDao = protocolFinderDao;
    }

    public ReviewCommentsService getReviewerCommentsService() {
        return this.reviewCommentsService;
    }

    public void setReviewCommentsService(ReviewCommentsService reviewCommentsService) {
        this.reviewCommentsService = reviewCommentsService;
    }

    @Override
    public String getProtocolOnlineReviewDocumentDescription(String protocolNumber, String piName) {
        String init;
        int fieldLimit = 40;
        int pilen = piName != null ? piName.length() : 0;
        int pnlen = protocolNumber != null ? protocolNumber.length() : 0;
        int ttlLength = pilen + pnlen + "%s/Protocol# %s".length() - 4;
        String piNameToUse = piName;
        if (ttlLength > 40 && piName != null) {
            int charsToTrim = ttlLength - 40;
            piNameToUse = piName.substring(0, Math.max(piName.length() - charsToTrim - 1, 0));
        }
        if ((init = String.format("%s/Protocol# %s", piNameToUse, protocolNumber)).length() > 40) {
            return init.substring(0, 39);
        }
        return init;
    }

    private List<String> getPersonnelIds(ProtocolBase protocol) {
        ArrayList<String> PersonnelIds = new ArrayList<String>();
        for (ProtocolPersonBase person : protocol.getProtocolPersons()) {
            if (StringUtils.isNotBlank((String)person.getPersonId())) {
                PersonnelIds.add(person.getPersonId());
                continue;
            }
            PersonnelIds.add(person.getRolodexId().toString());
        }
        return PersonnelIds;
    }

    private boolean isProtocolPersonnel(ProtocolBase protocol, CommitteeMembershipBase member) {
        return this.getPersonnelIds(protocol).contains(member.getPersonId());
    }

    public void setWorkflowDocumentService(WorkflowDocumentService workflowDocumentService) {
        this.workflowDocumentService = workflowDocumentService;
    }
}

