/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.onlinereview.authorization;

import java.util.HashSet;
import java.util.Set;
import org.kuali.kra.authorization.ApplicationTask;
import org.kuali.kra.authorization.KcTransactionalDocumentAuthorizerBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.protocol.ProtocolOnlineReviewDocumentBase;
import org.kuali.kra.protocol.onlinereview.authorization.ProtocolOnlineReviewTask;
import org.kuali.kra.service.KraWorkflowService;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProtocolOnlineReviewDocumentAuthorizer
extends KcTransactionalDocumentAuthorizerBase {
    private transient KraWorkflowService kraWorkflowService;

    public Set<String> getEditModes(Document document, Person user, Set<String> currentEditModes) {
        HashSet<String> editModes = new HashSet<String>();
        ProtocolOnlineReviewDocumentBase protocolOnlineReviewDocument = (ProtocolOnlineReviewDocumentBase)document;
        String userId = user.getPrincipalId();
        if (this.canExecuteProtocolOnlineReviewTask(userId, protocolOnlineReviewDocument, "maintainProtocolOnlineReviews")) {
            editModes.add("fullEntry");
        } else if (this.canExecuteProtocolOnlineReviewTask(userId, protocolOnlineReviewDocument, "modifyProtocolOnlineReview") && this.getKraWorkflowService().isUserApprovalRequested((Document)protocolOnlineReviewDocument, GlobalVariables.getUserSession().getPrincipalId())) {
            editModes.add("fullEntry");
        } else if (this.canExecuteProtocolOnlineReviewTask(userId, protocolOnlineReviewDocument, "viewProtocolOnlineReview")) {
            editModes.add("viewOnly");
        } else {
            editModes.add("unviewable");
        }
        return editModes;
    }

    public boolean canInitiate(String documentTypeName, Person user) {
        return true;
    }

    public boolean canOpen(Document document, Person user) {
        ProtocolOnlineReviewDocumentBase protocolOnlineReviewDocument = (ProtocolOnlineReviewDocumentBase)document;
        if (protocolOnlineReviewDocument.getProtocolOnlineReview() == null) {
            return this.canCreateProtocolOnlineReview(user);
        }
        return this.canExecuteProtocolOnlineReviewTask(user.getPrincipalId(), (ProtocolOnlineReviewDocumentBase)document, "viewProtocolOnlineReview");
    }

    private boolean canCreateProtocolOnlineReview(Person user) {
        ApplicationTask task = new ApplicationTask("createProtocolOnlineReview");
        TaskAuthorizationService taskAuthenticationService = KraServiceLocator.getService(TaskAuthorizationService.class);
        return taskAuthenticationService.isAuthorized(user.getPrincipalId(), task);
    }

    private boolean canExecuteProtocolOnlineReviewTask(String userId, ProtocolOnlineReviewDocumentBase doc, String taskName) {
        ProtocolOnlineReviewTask task = new ProtocolOnlineReviewTask(taskName, doc.getProtocolOnlineReview());
        TaskAuthorizationService taskAuthenticationService = KraServiceLocator.getService(TaskAuthorizationService.class);
        return taskAuthenticationService.isAuthorized(userId, task);
    }

    @Override
    public boolean canEdit(Document document, Person user) {
        return this.canExecuteProtocolOnlineReviewTask(user.getPrincipalId(), (ProtocolOnlineReviewDocumentBase)document, "modifyProtocolOnlineReview") || this.canExecuteProtocolOnlineReviewTask(user.getPrincipalId(), (ProtocolOnlineReviewDocumentBase)document, "maintainProtocolOnlineReviews");
    }

    @Override
    public boolean canSave(Document document, Person user) {
        return this.canEdit(document, user);
    }

    @Override
    public boolean canCopy(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canCancel(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canRoute(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canApprove(Document document, Person user) {
        return super.canApprove(document, user);
    }

    @Override
    public boolean canDisapprove(Document document, Person user) {
        boolean result = super.canDisapprove(document, user);
        return result &= this.canExecuteProtocolOnlineReviewTask(user.getPrincipalId(), (ProtocolOnlineReviewDocumentBase)document, "maintainProtocolOnlineReviews");
    }

    private KraWorkflowService getKraWorkflowService() {
        if (this.kraWorkflowService == null) {
            this.kraWorkflowService = KraServiceLocator.getService(KraWorkflowService.class);
        }
        return this.kraWorkflowService;
    }

    public boolean canSendNoteFyi(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canFyi(Document document, Person user) {
        return false;
    }
}

