/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.onlinereview.event;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.protocol.ProtocolOnlineReviewDocumentBase;
import org.kuali.kra.protocol.onlinereview.rules.RejectOnlineReviewCommentRule;
import org.kuali.kra.rule.event.KraDocumentEventBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.BusinessRule;

public class RejectProtocolOnlineReviewCommentEvent
extends KraDocumentEventBase {
    private static final Log LOG = LogFactory.getLog(RejectProtocolOnlineReviewCommentEvent.class);
    private String reason = null;
    private int maxLength;

    public RejectProtocolOnlineReviewCommentEvent(ProtocolOnlineReviewDocumentBase document, String rejectReason, int reasonMaxLength) {
        super("return protocol online review comment to reviewer", "DocReject", (Document)document);
        this.reason = rejectReason;
        this.maxLength = reasonMaxLength;
    }

    @Override
    protected void logEvent() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("disapprove protocol online review comment event reason=" + this.reason));
        }
    }

    public Class<RejectOnlineReviewCommentRule> getRuleInterfaceClass() {
        return RejectOnlineReviewCommentRule.class;
    }

    public boolean invokeRuleMethod(BusinessRule rule) {
        return this.getRuleInterfaceClass().cast(rule).processRejectOnlineReviewComment(this);
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }
}

