/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.onlinereview.event;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.common.committee.meeting.CommitteeScheduleMinuteBase;
import org.kuali.kra.protocol.ProtocolOnlineReviewDocumentBase;
import org.kuali.kra.protocol.onlinereview.ProtocolReviewAttachmentBase;
import org.kuali.kra.protocol.onlinereview.rules.SaveProtocolOnlineReviewRule;
import org.kuali.kra.rule.event.KraDocumentEventBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.BusinessRule;

public class SaveProtocolOnlineReviewEvent
extends KraDocumentEventBase {
    private static final Log LOG = LogFactory.getLog(SaveProtocolOnlineReviewEvent.class);
    private final List<CommitteeScheduleMinuteBase> minutes;
    private List<ProtocolReviewAttachmentBase> reviewAttachments;
    private final long onlineReviewIndex;

    public SaveProtocolOnlineReviewEvent(ProtocolOnlineReviewDocumentBase document, List<CommitteeScheduleMinuteBase> minutes, long onlineReviewIndex) {
        super("adding new protocol notepad", "notesAttachmentsHelper", (Document)document);
        this.onlineReviewIndex = onlineReviewIndex;
        if (document == null) {
            throw new IllegalArgumentException("the document is null");
        }
        if (minutes == null) {
            throw new IllegalArgumentException("the newCommitteeScheduleMinute is null");
        }
        this.minutes = minutes;
        this.reviewAttachments = document.getProtocolOnlineReview().getReviewAttachments();
    }

    @Override
    protected void logEvent() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("save #" + this.getDocument().getDocumentNumber()));
        }
    }

    public Class<SaveProtocolOnlineReviewRule> getRuleInterfaceClass() {
        return SaveProtocolOnlineReviewRule.class;
    }

    public boolean invokeRuleMethod(BusinessRule rule) {
        return this.getRuleInterfaceClass().cast(rule).processSaveProtocolOnlineReview(this);
    }

    public ProtocolOnlineReviewDocumentBase getProtocolOnlineReviewDocument() {
        return (ProtocolOnlineReviewDocumentBase)this.getDocument();
    }

    public long getOnlineReviewIndex() {
        return this.onlineReviewIndex;
    }

    public List<CommitteeScheduleMinuteBase> getMinutes() {
        return this.minutes;
    }

    public List<ProtocolReviewAttachmentBase> getReviewAttachments() {
        return this.reviewAttachments;
    }
}

