/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.permission;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.ProtocolFormBase;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.kra.service.SystemAuthorizationService;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kim.api.permission.PermissionQueryResults;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.type.KimType;

public abstract class PermissionsHelperBase
extends org.kuali.kra.common.permissions.web.struts.form.PermissionsHelperBase {
    private static final long serialVersionUID = 5896277052902587682L;
    protected static final String AGGREGATOR_NAME = "Aggregator";
    protected static final String VIEWER_NAME = "Viewer";
    protected static final String UNASSIGNED_NAME = "unassigned";
    private static final Log LOG = LogFactory.getLog(PermissionsHelperBase.class);
    protected Collection<String> excludeRoles;
    protected ProtocolFormBase form;
    protected Map<String, String> displayNameMap = null;
    private String roleType;

    public PermissionsHelperBase(ProtocolFormBase form, String roleType) {
        super(roleType);
        this.roleType = roleType;
        this.form = form;
    }

    protected abstract void initExcludedRolesHook();

    protected abstract void buildDisplayNameMap();

    @Override
    public List<KeyValue> getRoleSelection() {
        this.buildDisplayNameMap();
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        for (String role : this.displayNameMap.keySet()) {
            ConcreteKeyValue pair = new ConcreteKeyValue(role, this.displayNameMap.get(role));
            keyValues.add((KeyValue)pair);
        }
        this.addNonDerivedRoles(keyValues);
        return keyValues;
    }

    protected void addNonDerivedRoles(List<KeyValue> keyValues) {
        List<Role> kimRoles = this.getSortedKimRoles(this.roleType);
        for (Role kimRole : kimRoles) {
            KimType type;
            String roleName = kimRole.getName();
            if (this.excludeRoles.contains(roleName) || this.displayNameMap.keySet().contains(roleName) || StringUtils.startsWith((String)(type = this.getSystemAuthorizationService().getKimTypeInfoForRole(kimRole)).getName(), (String)"Derived Role") || StringUtils.startsWith((String)type.getName(), (String)"Default")) continue;
            ConcreteKeyValue pair = new ConcreteKeyValue(roleName, roleName);
            keyValues.add((KeyValue)pair);
        }
    }

    protected SystemAuthorizationService getSystemAuthorizationService() {
        return KraServiceLocator.getService(SystemAuthorizationService.class);
    }

    protected ProtocolBase getProtocol() {
        ProtocolDocumentBase document = this.form.getProtocolDocument();
        if (document == null || document.getProtocol() == null) {
            throw new IllegalArgumentException("invalid (null) ProtocolDocumentBase in ProtocolFormBase");
        }
        return document.getProtocol();
    }

    @Override
    public String getUnassignedRoleName() {
        return "Protocol Unassigned";
    }

    @Override
    protected String getRoleDisplayName(String roleName) {
        this.buildDisplayNameMap();
        String displayName = this.displayNameMap.get(roleName);
        if (displayName == null) {
            displayName = roleName;
        }
        return displayName;
    }

    @Override
    protected void buildRoles(String roleType) {
        this.initExcludedRolesHook();
        ArrayList<org.kuali.kra.common.permissions.web.bean.Role> roles = new ArrayList<org.kuali.kra.common.permissions.web.bean.Role>();
        List<Role> kimRoles = this.getSortedKimRoles(roleType);
        for (Role kimRole : kimRoles) {
            if (this.excludeRoles.contains(kimRole.getName())) continue;
            QueryByCriteria.Builder queryBuilder = QueryByCriteria.Builder.create();
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(PredicateFactory.equal((String)"rolePermissions.roleId", (Object)kimRole.getId()));
            queryBuilder.setPredicates(new Predicate[]{PredicateFactory.and((Predicate[])predicates.toArray(new Predicate[0]))});
            PermissionQueryResults permissionResults = this.getKimPermissionService().findPermissions(queryBuilder.build());
            org.kuali.kra.common.permissions.web.bean.Role role = new org.kuali.kra.common.permissions.web.bean.Role(kimRole.getName(), this.getRoleDisplayName(kimRole.getName()), permissionResults.getResults());
            roles.add(role);
        }
        this.setRoles(roles);
    }

    @Override
    protected List<KcPerson> getPersonsInRole(String roleName) {
        KraAuthorizationService kraAuthorizationService = KraServiceLocator.getService(KraAuthorizationService.class);
        return kraAuthorizationService.getPersonsInRole(this.getProtocol(), roleName);
    }

    public String getRoleType() {
        return this.roleType;
    }
}

