/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.personnel;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.bo.PersonTraining;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonTrainingService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.krad.service.BusinessObjectService;

public abstract class ProtocolPersonTrainingServiceImplBase
implements ProtocolPersonTrainingService {
    private static final Log LOG = LogFactory.getLog(ProtocolPersonTrainingServiceImplBase.class);
    private static final String PERSON_ID_FIELD = "personId";
    private static final String ACTIVE_FLAG_FIELD = "active";
    private static final String FOLLOWUP_DATE_FIELD = "followupDate";
    private static final String IS_ACTIVE_VALUE = "Y";
    private BusinessObjectService businessObjectService;
    private DateTimeService dateTimeService;

    @Override
    public void updatePersonTrained(List<ProtocolPersonBase> protocolPersons) {
        for (ProtocolPersonBase protocolPerson : protocolPersons) {
            this.setTrainedFlag(protocolPerson);
        }
    }

    @Override
    public void setTrainedFlag(ProtocolPersonBase protocolPerson) {
        protocolPerson.setTrained(this.isTrained(protocolPerson.getPersonId()));
    }

    private boolean isTrained(String personId) {
        if (StringUtils.isNotEmpty((String)personId)) {
            HashMap<String, String> matchingKeys = new HashMap<String, String>();
            matchingKeys.put(PERSON_ID_FIELD, personId);
            matchingKeys.put(ACTIVE_FLAG_FIELD, IS_ACTIVE_VALUE);
            Collection personTrainings = this.getBusinessObjectService().findMatchingOrderBy(PersonTraining.class, matchingKeys, FOLLOWUP_DATE_FIELD, false);
            for (PersonTraining personTraining : personTrainings) {
                if (personTraining.getFollowupDate() != null && !this.getDateTimeService().getCurrentDate().before(personTraining.getFollowupDate())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<PersonTraining> getPersonTrainingDetails(String personId) {
        HashMap<String, String> matchingKeys = new HashMap<String, String>();
        matchingKeys.put(PERSON_ID_FIELD, personId);
        matchingKeys.put(ACTIVE_FLAG_FIELD, IS_ACTIVE_VALUE);
        return (List)this.getBusinessObjectService().findMatchingOrderBy(PersonTraining.class, matchingKeys, FOLLOWUP_DATE_FIELD, false);
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }
}

