/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.personnel;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonnelService;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;

public abstract class ProtocolPersonnelAuditRuleBase
extends ResearchDocumentRuleBase
implements DocumentAuditRule {
    private static final Log LOG = LogFactory.getLog(ProtocolPersonnelAuditRuleBase.class);
    private List<AuditError> auditErrors;
    private static final String PERSONNEL_AUDIT_ERRORS = "personnelAuditErrors";

    @Override
    public boolean processRunAuditBusinessRules(Document document) {
        boolean isValid = true;
        ProtocolDocumentBase protocolDocument = (ProtocolDocumentBase)document;
        this.auditErrors = new ArrayList<AuditError>();
        isValid = this.getProtocolPersonnelService().isValidStudentFacultyMatch(protocolDocument.getProtocol().getProtocolPersons());
        if (!isValid) {
            for (Integer errorIndex : this.getProtocolPersonnelService().getAffiliationStudentMap(protocolDocument.getProtocol().getProtocolPersons())) {
                this.addErrorToAuditErrors(errorIndex);
            }
        }
        this.reportAndCreateAuditCluster();
        return isValid;
    }

    protected void addErrorToAuditErrors(int personIndex) {
        String label = "document.protocolList[0].protocolPersons[" + personIndex + "].protocolPersonRoleId";
        String cat = "personnel.Add Personnel:";
        this.auditErrors.add(new AuditError(label, "error.protocol.investigator.invalid", cat));
    }

    protected void reportAndCreateAuditCluster() {
        if (this.auditErrors.size() > 0) {
            KNSGlobalVariables.getAuditErrorMap().put(PERSONNEL_AUDIT_ERRORS, new AuditCluster("Personnel", this.auditErrors, "Validation Errors"));
        }
    }

    protected abstract ProtocolPersonnelService getProtocolPersonnelService();
}

