/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.personnel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.bo.AttachmentFile;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.infrastructure.Constants;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentPersonnelBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonRoleBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonRoleMappingBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonTrainingService;
import org.kuali.kra.protocol.personnel.ProtocolPersonnelService;
import org.kuali.kra.protocol.personnel.ProtocolUnitBase;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.service.PersonEditableService;
import org.kuali.kra.service.UnitService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.SequenceAccessorService;

public abstract class ProtocolPersonnelServiceImplBase
implements ProtocolPersonnelService {
    private static final Log LOG = LogFactory.getLog(ProtocolPersonnelServiceImplBase.class);
    private BusinessObjectService businessObjectService;
    private SequenceAccessorService sequenceAccessorService;
    private ProtocolPersonTrainingService protocolPersonTrainingService;
    private KcPersonService kcPersonService;
    private UnitService unitService;
    protected PersonEditableService personEditableService;
    private static final String REFERENCE_PERSON_ROLE = "protocolPersonRole";
    private static final String REFERENCE_PERSON = "person";
    private static final String REFERENCE_ROLODEX = "rolodex";
    private static final String REFERENCE_UNIT = "unit";
    private static final String PROTOCOL_ATTACHMENT_TYPE = "type";
    private static final boolean LEAD_UNIT_FLAG_ON = true;
    private static final int PI_CHANGED = 0;
    private static final int COI_CHANGED = 1;
    private static final int ROLE_UNCHANGED = -1;
    private static final int RESET_SELECTED_UNIT_FOR_PERSON = 0;
    private static final int AFFILIATION_TYPE_OTHER = 0;
    private static final int AFFILIATION_TYPE_STUDENT_INVESTIGATOR = 1;
    private static final int AFFILIATION_TYPE_FACULTY_SUPERVISOR = 2;

    public void setProtocolPersonTrainingService(ProtocolPersonTrainingService protocolPersonTrainingService) {
        this.protocolPersonTrainingService = protocolPersonTrainingService;
    }

    @Override
    public void addProtocolPerson(ProtocolBase protocol, ProtocolPersonBase protocolPerson) {
        Integer nextPersonId = this.getSequenceAccessorService().getNextAvailableSequenceNumber(this.getSequenceNumberNameHook()).intValue();
        protocolPerson.setProtocolPersonId(nextPersonId);
        protocolPerson.setProtocolNumber(protocol.getProtocolNumber());
        protocolPerson.setSequenceNumber(protocol.getSequenceNumber());
        if (StringUtils.isBlank((String)protocolPerson.getPersonId())) {
            protocolPerson.refreshReferenceObject(REFERENCE_ROLODEX);
            this.personEditableService.populateContactFieldsFromRolodexId(protocolPerson);
        } else {
            this.personEditableService.populateContactFieldsFromPersonId(protocolPerson);
        }
        protocolPerson.refreshReferenceObject(REFERENCE_PERSON_ROLE);
        this.getProtocolPersonTrainingService().setTrainedFlag(protocolPerson);
        this.populateUnitFromPrimaryDepartmentCode(protocol, protocolPerson);
        protocol.getProtocolPersons().add(protocolPerson);
    }

    protected abstract String getSequenceNumberNameHook();

    @Override
    public void deleteProtocolPerson(ProtocolBase protocol) {
        ArrayList<ProtocolPersonBase> deletedPersons = new ArrayList<ProtocolPersonBase>();
        for (ProtocolPersonBase protocolPerson : protocol.getProtocolPersons()) {
            if (!protocolPerson.isDelete()) continue;
            deletedPersons.add(protocolPerson);
        }
        protocol.getProtocolPersons().removeAll(deletedPersons);
    }

    protected void deleteAssociatedPersonnelAttachments(Integer protocolPersonId, Collection<ProtocolAttachmentPersonnelBase> toDelete) {
        Iterator<ProtocolAttachmentPersonnelBase> i = toDelete.iterator();
        while (i.hasNext()) {
            ProtocolAttachmentPersonnelBase attachment = i.next();
            if (!attachment.getPerson().getProtocolPersonId().equals(protocolPersonId)) continue;
            i.remove();
        }
    }

    @Override
    public void addProtocolPersonAttachment(ProtocolBase protocol, ProtocolAttachmentPersonnelBase newAttachment, int selectedPersonIndex) {
        if (newAttachment.getNewFile() != null && StringUtils.isNotBlank((String)newAttachment.getNewFile().getFileName())) {
            AttachmentFile newFile = AttachmentFile.createFromFormFile(newAttachment.getNewFile());
            if (newAttachment.getFile() != null) {
                newFile.setSequenceNumber(newAttachment.getFile().getSequenceNumber());
            }
            newAttachment.setFile(newFile);
            newAttachment.setNewFile(null);
        }
        if (newAttachment.isNew()) {
            int maxDocId = 0;
            for (ProtocolPersonBase person : protocol.getProtocolPersons()) {
                for (ProtocolAttachmentPersonnelBase attachment : person.getAttachmentPersonnels()) {
                    if (!attachment.getTypeCode().equals(newAttachment.getTypeCode()) || maxDocId >= attachment.getDocumentId()) continue;
                    maxDocId = attachment.getDocumentId();
                }
            }
            newAttachment.setDocumentId(maxDocId + 1);
        }
        newAttachment.setProtocolId(protocol.getProtocolId());
        newAttachment.setProtocolNumber(protocol.getProtocolNumber());
        newAttachment.refreshReferenceObject(PROTOCOL_ATTACHMENT_TYPE);
        protocol.getProtocolPerson(selectedPersonIndex).getAttachmentPersonnels().add(newAttachment);
    }

    @Override
    public void addProtocolPersonUnit(List<ProtocolUnitBase> protocolPersonUnits, ProtocolPersonBase protocolPerson, int selectedPersonIndex) {
        ProtocolUnitBase newProtocolPersonUnit = protocolPersonUnits.get(selectedPersonIndex);
        newProtocolPersonUnit.setProtocolNumber(protocolPerson.getProtocolNumber());
        newProtocolPersonUnit.setProtocolPersonId(protocolPerson.getProtocolPersonId());
        newProtocolPersonUnit.setPersonId(protocolPerson.getPersonId());
        newProtocolPersonUnit.refreshReferenceObject(REFERENCE_UNIT);
        protocolPerson.addProtocolUnit(newProtocolPersonUnit);
        if (newProtocolPersonUnit.getLeadUnitFlag()) {
            protocolPerson.setSelectedUnit(protocolPerson.getProtocolUnits().size() - 1);
            this.setLeadUnit(protocolPerson);
        }
        protocolPersonUnits.remove(selectedPersonIndex);
        protocolPersonUnits.add(selectedPersonIndex, this.createNewProtocolUnitInstanceHook());
    }

    protected abstract ProtocolUnitBase createNewProtocolUnitInstanceHook();

    @Override
    public void deleteProtocolPersonUnit(ProtocolBase protocol, int selectedPersonIndex, int lineNumber) {
        ProtocolPersonBase selectedPerson = protocol.getProtocolPerson(selectedPersonIndex);
        ProtocolUnitBase protocolUnit = selectedPerson.getProtocolUnit(lineNumber);
        if (protocolUnit.getLeadUnitFlag()) {
            selectedPerson.setSelectedUnit(0);
        }
        selectedPerson.getProtocolUnits().remove(lineNumber);
    }

    @Override
    public void switchInvestigatorCoInvestigatorRole(List<ProtocolPersonBase> protocolPersons) {
        ProtocolPersonBase investigator = null;
        String personNewRole = null;
        switch (this.getPIOrCoIChanged(protocolPersons)) {
            case 0: {
                investigator = this.getPreviousInvestigator(protocolPersons, this.getPrincipalInvestigatorRole());
                personNewRole = this.getCoInvestigatorRole();
                break;
            }
            case 1: {
                investigator = this.getPreviousInvestigator(protocolPersons, this.getCoInvestigatorRole());
                personNewRole = this.getPrincipalInvestigatorRole();
            }
        }
        if (investigator != null) {
            this.updatePersonRole(investigator, personNewRole);
        }
    }

    protected int getPIOrCoIChanged(List<ProtocolPersonBase> protocolPersons) {
        int roleChanged = -1;
        for (ProtocolPersonBase protocolPerson : protocolPersons) {
            if (this.isRoleChangedToNewRole(protocolPerson, this.getPrincipalInvestigatorRole())) {
                roleChanged = 0;
                break;
            }
            if (!this.isRoleChangedToNewRole(protocolPerson, this.getCoInvestigatorRole())) continue;
            roleChanged = 1;
            break;
        }
        return roleChanged;
    }

    protected void updatePersonRole(ProtocolPersonBase protocolPerson, String targetRole) {
        if (protocolPerson != null) {
            protocolPerson.setProtocolPersonRoleId(targetRole);
            protocolPerson.refreshReferenceObject(REFERENCE_PERSON_ROLE);
        }
    }

    protected boolean isRoleChangedToNewRole(ProtocolPersonBase protocolPerson, String newRole) {
        return !StringUtils.equalsIgnoreCase((String)protocolPerson.getPreviousPersonRoleId(), (String)protocolPerson.getProtocolPersonRoleId()) && StringUtils.equalsIgnoreCase((String)protocolPerson.getProtocolPersonRoleId(), (String)newRole);
    }

    protected ProtocolPersonBase getPreviousInvestigator(List<ProtocolPersonBase> protocolPersons, String role) {
        for (ProtocolPersonBase protocolPerson : protocolPersons) {
            if (!StringUtils.equalsIgnoreCase((String)protocolPerson.getPreviousPersonRoleId(), (String)protocolPerson.getProtocolPersonRoleId()) || !StringUtils.equalsIgnoreCase((String)protocolPerson.getProtocolPersonRoleId(), (String)role)) continue;
            return protocolPerson;
        }
        return null;
    }

    @Override
    public List<ProtocolPersonRoleMappingBase> getPersonRoleMapping(String sourceRoleId) {
        ArrayList<ProtocolPersonRoleMappingBase> personRoleMappings = new ArrayList<ProtocolPersonRoleMappingBase>();
        HashMap<String, String> matchingKeys = new HashMap<String, String>();
        matchingKeys.put("sourceRoleId", sourceRoleId);
        personRoleMappings.addAll(this.getBusinessObjectService().findMatching(this.getProtocolPersonRoleMappingClassHook(), matchingKeys));
        return personRoleMappings;
    }

    public abstract Class<? extends ProtocolPersonRoleMappingBase> getProtocolPersonRoleMappingClassHook();

    @Override
    public ProtocolPersonRoleBase getProtocolPersonRole(String sourceRoleId) {
        return (ProtocolPersonRoleBase)this.getBusinessObjectService().findBySinglePrimaryKey(this.getProtocolPersonRoleClassHook(), (Object)sourceRoleId);
    }

    public abstract Class<? extends ProtocolPersonRoleBase> getProtocolPersonRoleClassHook();

    @Override
    public void syncProtocolPersonRoleChanges(List<ProtocolPersonBase> protocolPersons) {
        for (ProtocolPersonBase protocolPerson : protocolPersons) {
            if (!this.isUnitDetailsRequired(protocolPerson)) {
                protocolPerson.getProtocolUnits().removeAll(protocolPerson.getProtocolUnits());
            } else {
                this.setLeadUnit(protocolPerson);
            }
            this.syncPersonRoleAndAffiliation(protocolPerson);
        }
    }

    protected void setLeadUnit(ProtocolPersonBase protocolPerson) {
        if (protocolPerson.getProtocolUnits().size() > 0) {
            protocolPerson.resetAllProtocolLeadUnits();
            this.setLeadUnitFlag(protocolPerson);
        }
    }

    protected boolean isUnitDetailsRequired(ProtocolPersonBase protocolPerson) {
        boolean unitDetailsRequried = true;
        protocolPerson.refreshReferenceObject(REFERENCE_PERSON_ROLE);
        if (!protocolPerson.getProtocolPersonRole().isUnitDetailsRequired()) {
            unitDetailsRequried = false;
        }
        return unitDetailsRequried;
    }

    protected boolean isAffiliationDetailsRequired(ProtocolPersonBase protocolPerson) {
        boolean affiliationDetailsRequried = true;
        if (!protocolPerson.getProtocolPersonRole().isAffiliationDetailsRequired()) {
            affiliationDetailsRequried = false;
        }
        return affiliationDetailsRequried;
    }

    protected void setLeadUnitFlag(ProtocolPersonBase protocolPerson) {
        protocolPerson.getProtocolUnit(protocolPerson.getSelectedUnit()).setLeadUnitFlag(true);
    }

    @Override
    public void selectProtocolUnit(List<ProtocolPersonBase> protocolPersons) {
        block0: for (ProtocolPersonBase protocolPerson : protocolPersons) {
            int selectedUnit = 0;
            for (ProtocolUnitBase protocolUnit : protocolPerson.getProtocolUnits()) {
                if (protocolUnit.getLeadUnitFlag()) {
                    protocolPerson.setSelectedUnit(selectedUnit);
                    continue block0;
                }
                ++selectedUnit;
            }
        }
    }

    @Override
    public boolean isPIExists(List<ProtocolPersonBase> protocolPersons) {
        boolean investigatorExists = false;
        for (ProtocolPersonBase protocolPerson : protocolPersons) {
            if (!protocolPerson.getProtocolPersonRoleId().equalsIgnoreCase(this.getPrincipalInvestigatorRole())) continue;
            investigatorExists = true;
            break;
        }
        return investigatorExists;
    }

    @Override
    public boolean isDuplicateUnit(ProtocolPersonBase protocolPerson, ProtocolUnitBase newProtocolUnit) {
        boolean duplicateUnit = false;
        for (ProtocolUnitBase protocolUnit : protocolPerson.getProtocolUnits()) {
            if (!protocolUnit.getUnitNumber().equalsIgnoreCase(newProtocolUnit.getUnitNumber())) continue;
            duplicateUnit = true;
            break;
        }
        return duplicateUnit;
    }

    @Override
    public boolean isPISameAsCoI(ProtocolPersonBase pi, ProtocolPersonBase newProtocolPerson) {
        boolean duplicatePerson = false;
        if (pi != null && newProtocolPerson != null && StringUtils.isNotEmpty((String)pi.getPersonKey()) && StringUtils.isNotEmpty((String)newProtocolPerson.getPersonKey()) && newProtocolPerson.getPersonKey().equalsIgnoreCase(pi.getPersonKey()) && this.isCoInvestigator(newProtocolPerson)) {
            duplicatePerson = true;
        }
        return duplicatePerson;
    }

    @Override
    public boolean isDuplicatePerson(List<ProtocolPersonBase> protocolPersons, ProtocolPersonBase newProtocolPerson) {
        boolean duplicatePerson = false;
        for (ProtocolPersonBase protocolPerson : protocolPersons) {
            if (!protocolPerson.getPersonUniqueKey().equalsIgnoreCase(newProtocolPerson.getPersonUniqueKey())) continue;
            duplicatePerson = true;
        }
        return duplicatePerson;
    }

    @Override
    public ProtocolPersonBase getPrincipalInvestigator(List<ProtocolPersonBase> protocolPersons) {
        ProtocolPersonBase principalInvestigator = null;
        for (ProtocolPersonBase protocolPerson : protocolPersons) {
            if (!this.isPrincipalInvestigator(protocolPerson)) continue;
            principalInvestigator = protocolPerson;
            break;
        }
        return principalInvestigator;
    }

    @Override
    public boolean isPrincipalInvestigator(ProtocolPersonBase protocolPerson) {
        boolean isInvestigator = false;
        if (protocolPerson.getProtocolPersonRoleId().equalsIgnoreCase(this.getPrincipalInvestigatorRole())) {
            isInvestigator = true;
        }
        return isInvestigator;
    }

    protected boolean isCoInvestigator(ProtocolPersonBase protocolPerson) {
        boolean isCoI = false;
        if (protocolPerson.getProtocolPersonRoleId().equalsIgnoreCase(this.getCoInvestigatorRole())) {
            isCoI = true;
        }
        return isCoI;
    }

    @Override
    public ProtocolUnitBase getLeadUnit(ProtocolPersonBase principalInvestigator) {
        ProtocolUnitBase leadUnit = null;
        if (principalInvestigator != null) {
            for (ProtocolUnitBase unit : principalInvestigator.getProtocolUnits()) {
                if (!unit.getLeadUnitFlag()) continue;
                leadUnit = unit;
                break;
            }
        }
        return leadUnit;
    }

    @Override
    public void setLeadUnit(ProtocolUnitBase newLeadUnit, ProtocolPersonBase principalInvestigator, ProtocolBase protocol) {
        if (principalInvestigator != null) {
            ProtocolUnitBase currentLeadUnit = this.getLeadUnit(principalInvestigator);
            if (newLeadUnit != null && protocol != null) {
                newLeadUnit.setPersonId(principalInvestigator.getPersonId());
                newLeadUnit.setProtocolNumber(protocol.getProtocolNumber());
                newLeadUnit.refreshReferenceObject(REFERENCE_UNIT);
                if (currentLeadUnit == null) {
                    principalInvestigator.getProtocolUnits().add(newLeadUnit);
                } else if (!this.isDuplicateUnit(principalInvestigator, newLeadUnit)) {
                    principalInvestigator.getProtocolUnits().remove(currentLeadUnit);
                    principalInvestigator.getProtocolUnits().add(newLeadUnit);
                }
            }
        }
    }

    @Override
    public void syncPersonRoleAndUnit(ProtocolPersonBase protocolPerson) {
        if (!this.isUnitDetailsRequired(protocolPerson)) {
            protocolPerson.getProtocolUnits().removeAll(protocolPerson.getProtocolUnits());
        }
    }

    @Override
    public void syncPersonRoleAndAffiliation(ProtocolPersonBase protocolPerson) {
        if (!this.isAffiliationDetailsRequired(protocolPerson)) {
            protocolPerson.setAffiliationTypeCode(null);
        }
    }

    @Override
    public boolean isValidStudentFacultyMatch(List<ProtocolPersonBase> protocolPersons) {
        boolean validInvestigator = true;
        HashMap<Integer, Integer> investigatorAffiliation = new HashMap<Integer, Integer>();
        for (ProtocolPersonBase protocolPerson : protocolPersons) {
            if (!this.isAffiliationStudentInvestigatorOrFacultySupervisor(protocolPerson)) continue;
            this.updateAffiliationCount(protocolPerson, investigatorAffiliation);
        }
        Integer studentAffiliationCount = investigatorAffiliation.get(this.getStudentAffiliationType()) == null ? 0 : (Integer)investigatorAffiliation.get(this.getStudentAffiliationType());
        Integer facultySupervisorAffiliationCount = investigatorAffiliation.get(this.getFacultySupervisorAffiliationType()) == null ? 0 : investigatorAffiliation.get(this.getFacultySupervisorAffiliationType());
        if (studentAffiliationCount > 0 && studentAffiliationCount.compareTo(facultySupervisorAffiliationCount) != 0) {
            validInvestigator = false;
        }
        return validInvestigator;
    }

    protected boolean isAffiliationStudentInvestigatorOrFacultySupervisor(ProtocolPersonBase protocolPerson) {
        return protocolPerson.getAffiliationTypeCode() != null && (protocolPerson.getAffiliationTypeCode().compareTo(this.getStudentAffiliationType()) == 0 || protocolPerson.getAffiliationTypeCode().compareTo(this.getFacultySupervisorAffiliationType()) == 0);
    }

    protected void updateAffiliationCount(ProtocolPersonBase protocolPerson, HashMap<Integer, Integer> investigatorAffiliation) {
        Integer totalCountForAffiliation = 0;
        totalCountForAffiliation = investigatorAffiliation.get(protocolPerson.getAffiliationTypeCode());
        if (totalCountForAffiliation == null) {
            investigatorAffiliation.put(protocolPerson.getAffiliationTypeCode(), 1);
        } else {
            investigatorAffiliation.remove(protocolPerson.getAffiliationTypeCode());
            Integer n = totalCountForAffiliation;
            Integer n2 = totalCountForAffiliation = Integer.valueOf(totalCountForAffiliation + 1);
            investigatorAffiliation.put(protocolPerson.getAffiliationTypeCode(), n);
        }
    }

    @Override
    public List<Integer> getAffiliationStudentMap(List<ProtocolPersonBase> protocolPersons) {
        ArrayList<Integer> results = new ArrayList<Integer>();
        for (int i = 0; i < protocolPersons.size(); ++i) {
            ProtocolPersonBase protocolPerson = protocolPersons.get(i);
            if (!this.isAffiliationStudentInvestigatorOrFacultySupervisor(protocolPerson)) continue;
            results.add(new Integer(i));
        }
        return results;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public SequenceAccessorService getSequenceAccessorService() {
        return this.sequenceAccessorService;
    }

    public void setSequenceAccessorService(SequenceAccessorService sequenceAccessorService) {
        this.sequenceAccessorService = sequenceAccessorService;
    }

    protected String getPrincipalInvestigatorRole() {
        return "PI";
    }

    protected String getCoInvestigatorRole() {
        return "COI";
    }

    protected Integer getStudentAffiliationType() {
        return Constants.AFFILIATION_STUDENT_INVESTIGATOR_TYPE;
    }

    protected Integer getFacultySupervisorAffiliationType() {
        return Constants.AFFILIATION_FACULTY_SUPERVISOR_TYPE;
    }

    public ProtocolPersonTrainingService getProtocolPersonTrainingService() {
        return this.protocolPersonTrainingService;
    }

    public void setPersonEditableService(PersonEditableService personEditableService) {
        this.personEditableService = personEditableService;
    }

    public KcPersonService getKcPersonService() {
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    public UnitService getUnitService() {
        return this.unitService;
    }

    public void setUnitService(UnitService unitService) {
        this.unitService = unitService;
    }

    protected void populateUnitFromPrimaryDepartmentCode(ProtocolBase protocol, ProtocolPersonBase protocolPerson) {
        Unit unit;
        KcPerson person;
        String unitNumber;
        if (protocolPerson.getPersonId() != null && (unitNumber = (person = this.getKcPersonService().getKcPersonByPersonId(protocolPerson.getPersonId())).getOrganizationIdentifier()) != null && (unit = this.getUnitService().getUnit(unitNumber)) != null) {
            ProtocolUnitBase newProtocolPersonUnit = this.createNewProtocolUnitInstanceHook();
            newProtocolPersonUnit.setUnit(unit);
            newProtocolPersonUnit.setUnitName(unit.getUnitName());
            newProtocolPersonUnit.setUnitNumber(unit.getUnitNumber());
            newProtocolPersonUnit.setProtocolNumber(protocolPerson.getProtocolNumber());
            newProtocolPersonUnit.setProtocolPersonId(protocolPerson.getProtocolPersonId());
            newProtocolPersonUnit.setPersonId(protocolPerson.getPersonId());
            newProtocolPersonUnit.setLeadUnitFlag(true);
            protocolPerson.addProtocolUnit(newProtocolPersonUnit);
            if (newProtocolPersonUnit.getLeadUnitFlag()) {
                protocolPerson.setSelectedUnit(protocolPerson.getProtocolUnits().size() - 1);
                this.setLeadUnit(protocolPerson);
            }
        }
    }
}

