/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.personnel;

import org.apache.commons.lang.StringUtils;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.personnel.AddProtocolUnitEvent;
import org.kuali.kra.protocol.personnel.AddProtocolUnitRule;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonnelService;
import org.kuali.kra.protocol.personnel.ProtocolUnitBase;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.kra.service.UnitService;

public abstract class ProtocolUnitRuleBase
extends ResearchDocumentRuleBase
implements AddProtocolUnitRule {
    private static final String ERROR_PROPERTY_NEW_PERSON_UNIT = "personnelHelper.newProtocolPersonUnits";
    private static final String ERROR_PROPERTY_UNIT_NUMBER = ".unitNumber";
    private String ERROR_PROPERTY_PERSON_INDEX = "[personIndex]";
    private String PERSON_INDEX = "personIndex";

    @Override
    public boolean processAddProtocolUnitBusinessRules(AddProtocolUnitEvent addProtocolUnitEvent) {
        boolean isValid = true;
        ProtocolUnitBase protocolUnit = addProtocolUnitEvent.getProtocolUnit();
        int personIndex = addProtocolUnitEvent.getPersonIndex();
        ProtocolPersonBase protocolPerson = ((ProtocolDocumentBase)addProtocolUnitEvent.getDocument()).getProtocol().getProtocolPerson(personIndex);
        if (isValid &= !this.isEmptyProtocolUnit(protocolUnit, personIndex)) {
            isValid &= this.isValidProtocolUnit(protocolUnit, personIndex);
            isValid &= !this.isDuplicateProtocolUnit(protocolPerson, protocolUnit, personIndex);
        }
        return isValid;
    }

    private boolean isEmptyProtocolUnit(ProtocolUnitBase protocolUnit, int personIndex) {
        boolean isEmpty = false;
        if (StringUtils.isBlank((String)protocolUnit.getUnitNumber())) {
            this.reportError(this.formatErrorPropertyName(personIndex, ERROR_PROPERTY_UNIT_NUMBER), "error.protocolUnit.invalid", new String[0]);
            isEmpty = true;
        }
        return isEmpty;
    }

    private boolean isDuplicateProtocolUnit(ProtocolPersonBase protocolPerson, ProtocolUnitBase protocolUnit, int personIndex) {
        boolean duplicateUnit = false;
        duplicateUnit = this.getProtocolPersonnelService().isDuplicateUnit(protocolPerson, protocolUnit);
        if (duplicateUnit) {
            this.reportError(this.formatErrorPropertyName(personIndex, ERROR_PROPERTY_UNIT_NUMBER), "error.protocolUnit.duplicate", new String[0]);
        }
        return duplicateUnit;
    }

    private boolean isValidProtocolUnit(ProtocolUnitBase protocolUnit, int personIndex) {
        boolean validUnit = true;
        if (StringUtils.isBlank((String)this.getUnitService().getUnitName(protocolUnit.getUnitNumber()))) {
            this.reportError(this.formatErrorPropertyName(personIndex, ERROR_PROPERTY_UNIT_NUMBER), "error.protocolUnit.invalid", new String[0]);
            validUnit = false;
        }
        return validUnit;
    }

    private String formatErrorPropertyName(int personIndex, String errorKey) {
        String errorProperty = null;
        errorProperty = ERROR_PROPERTY_NEW_PERSON_UNIT + this.ERROR_PROPERTY_PERSON_INDEX.replaceAll(this.PERSON_INDEX, Integer.toString(personIndex)) + errorKey;
        return errorProperty;
    }

    private UnitService getUnitService() {
        return KraServiceLocator.getService(UnitService.class);
    }

    protected abstract ProtocolPersonnelService getProtocolPersonnelService();
}

