/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.protocol;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.Contactable;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.common.specialreview.service.SpecialReviewService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.ProtocolFormBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.auth.ProtocolTaskBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonnelService;
import org.kuali.kra.protocol.personnel.ProtocolUnitBase;
import org.kuali.kra.protocol.protocol.ProtocolNumberServiceBase;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceBase;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceService;
import org.kuali.kra.protocol.protocol.location.ProtocolLocationBase;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.service.RolodexService;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.kra.service.UnitService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class ProtocolHelperBase
implements Serializable {
    private static final long serialVersionUID = 8036126015259703614L;
    private static final String PROTOCOL_CREATED = "Protocol created";
    private ProtocolFormBase form;
    private String principalInvestigatorId;
    private String principalInvestigatorName;
    private String personId;
    private String rolodexId;
    private String lookupUnitNumber;
    private String lookupUnitName;
    private String leadUnitNumber;
    private String leadUnitName;
    private boolean nonEmployeeFlag;
    private String referenceId1Label;
    private String referenceId2Label;
    private boolean modifyProtocol = false;
    private boolean billableReadOnly = false;
    private ProtocolLocationBase newProtocolLocation;
    private String organizationName;
    private ProtocolFundingSourceBase newFundingSource;
    private boolean editProtocolFundingSourceName = false;
    private List<ProtocolFundingSourceBase> deletedProtocolFundingSources;
    private boolean modifyGeneralInfo = false;
    private boolean modifyFundingSource = false;
    private boolean modifyReferences = false;
    private boolean modifyOrganizations = false;
    private boolean modifyAreasOfResearch = false;
    private boolean canCreateProposalDevelopment = false;
    private boolean protocolProposalDevelopmentLinkingEnabled = false;
    private boolean leadUnitAutoPopulated = false;
    private transient ParameterService parameterService;
    private transient KcPersonService personService;
    private transient RolodexService rolodexService;
    private transient ProtocolFundingSourceService protocolFundingSourceService;
    private transient SpecialReviewService specialReviewService;
    private List<ProtocolFundingSourceBase> newProtocolFundingSources;
    private boolean displayBillable = true;

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KraServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    protected RolodexService getRolodexService() {
        if (this.rolodexService == null) {
            this.rolodexService = KraServiceLocator.getService(RolodexService.class);
        }
        return this.rolodexService;
    }

    protected ProtocolFundingSourceService getProtocolFundingSourceService() {
        if (this.protocolFundingSourceService == null) {
            this.protocolFundingSourceService = KraServiceLocator.getService(this.getProtocolFundingSourceServiceClassHook());
        }
        return this.protocolFundingSourceService;
    }

    protected abstract Class<? extends ProtocolFundingSourceService> getProtocolFundingSourceServiceClassHook();

    protected SpecialReviewService getSpecialReviewService() {
        if (this.specialReviewService == null) {
            this.specialReviewService = KraServiceLocator.getService(SpecialReviewService.class);
        }
        return this.specialReviewService;
    }

    public boolean isEditProtocolFundingSourceName() {
        return this.editProtocolFundingSourceName;
    }

    public void setEditProtocolFundingSourceName(boolean editProtocolFundingSourceName) {
        this.editProtocolFundingSourceName = editProtocolFundingSourceName;
    }

    public List<ProtocolFundingSourceBase> getDeletedProtocolFundingSources() {
        return this.deletedProtocolFundingSources;
    }

    public void setDeletedProtocolFundingSources(List<ProtocolFundingSourceBase> deletedProtocolFundingSources) {
        this.deletedProtocolFundingSources = deletedProtocolFundingSources;
    }

    public ProtocolHelperBase(ProtocolFormBase form) {
        this.form = form;
        this.setNewProtocolLocation(this.getNewProtocolLocationInstanceHook());
        this.setDeletedProtocolFundingSources(new ArrayList<ProtocolFundingSourceBase>());
        this.setNewFundingSource(this.getNewProtocolFundingSourceInstanceHook());
        this.setNewProtocolFundingSources(new ArrayList<ProtocolFundingSourceBase>());
    }

    protected abstract ProtocolFundingSourceBase getNewProtocolFundingSourceInstanceHook();

    protected abstract ProtocolLocationBase getNewProtocolLocationInstanceHook();

    public void prepareView() {
        this.prepareRequiredFields();
        this.syncFundingSources(this.getProtocol());
        this.initializeConfigurationParams();
        this.initializePermissions(this.getProtocol());
    }

    protected ProtocolBase getProtocol() {
        ProtocolDocumentBase document = this.form.getProtocolDocument();
        if (document == null || document.getProtocol() == null) {
            throw new IllegalArgumentException("invalid (null) ProtocolDocumentBase in ProtocolFormBase");
        }
        return document.getProtocol();
    }

    private void initializeConfigurationParams() {
        this.setReferenceId1Label(this.getParameterValue(this.getReferenceID1ParameterNameHook()));
        this.setReferenceId2Label(this.getParameterValue(this.getReferenceID2ParameterNameHook()));
        boolean flag = this.getParameterValue(this.getBillableParameterHook()).equalsIgnoreCase("Y");
        this.setDisplayBillable(flag);
    }

    protected abstract String getBillableParameterHook();

    protected abstract String getReferenceID1ParameterNameHook();

    protected abstract String getReferenceID2ParameterNameHook();

    protected void initializePermissions(ProtocolBase protocol) {
        this.initializeModifyProtocolPermission(protocol);
        if (this.displayBillable) {
            this.initializeBillablePermission(protocol);
        }
        this.initializeModifyGeneralInfoPermission(protocol);
        this.initializeModifyFundingSourcePermission(protocol);
        this.initializeModifyReferencesPermission(protocol);
        this.initializeModifyOrganizationsPermission(protocol);
        this.initializeModifyAreasOfResearchPermission(protocol);
        this.initializeProtocolProposalDevelopmentLinking();
        this.initializeCreateProposalDevelopmentPermission(protocol);
    }

    private void initializeModifyProtocolPermission(ProtocolBase protocol) {
        ProtocolTaskBase task = this.getNewInstanceModifyProtocolTaskHook(protocol);
        this.modifyProtocol = this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected abstract ProtocolTaskBase getNewInstanceModifyProtocolTaskHook(ProtocolBase var1);

    private void initializeBillablePermission(ProtocolBase protocol) {
        ProtocolTaskBase task = this.getNewInstanceModifyProtocolBillableTaskNewHook(protocol);
        this.billableReadOnly = !this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    public abstract ProtocolTaskBase getNewInstanceModifyProtocolBillableTaskNewHook(ProtocolBase var1);

    private void initializeModifyGeneralInfoPermission(ProtocolBase protocol) {
        ProtocolTaskBase task = this.getNewInstanceModifyProtocolGeneralInfoTaskHook(protocol);
        this.modifyGeneralInfo = this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected abstract ProtocolTaskBase getNewInstanceModifyProtocolGeneralInfoTaskHook(ProtocolBase var1);

    private void initializeModifyFundingSourcePermission(ProtocolBase protocol) {
        ProtocolTaskBase task = this.getNewInstanceModifyProtocolFundingSourceTaskHook(protocol);
        this.modifyFundingSource = this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected abstract ProtocolTaskBase getNewInstanceModifyProtocolFundingSourceTaskHook(ProtocolBase var1);

    private void initializeModifyReferencesPermission(ProtocolBase protocol) {
        ProtocolTaskBase task = this.getNewInstanceModifyProtocolReferencesTaskHook(protocol);
        this.modifyReferences = this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected abstract ProtocolTaskBase getNewInstanceModifyProtocolReferencesTaskHook(ProtocolBase var1);

    private void initializeModifyOrganizationsPermission(ProtocolBase protocol) {
        ProtocolTaskBase task = this.getNewInstanceModifyProtocolOrganizationsTaskHook(protocol);
        this.modifyOrganizations = this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected abstract ProtocolTaskBase getNewInstanceModifyProtocolOrganizationsTaskHook(ProtocolBase var1);

    private void initializeModifyAreasOfResearchPermission(ProtocolBase protocol) {
        ProtocolTaskBase task = this.getNewInstanceModifyProtocolResearchAreasTaskHook(protocol);
        this.modifyAreasOfResearch = this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected abstract ProtocolTaskBase getNewInstanceModifyProtocolResearchAreasTaskHook(ProtocolBase var1);

    private void initializeCreateProposalDevelopmentPermission(ProtocolBase protocol) {
        ProtocolTaskBase task = this.getNewInstanceCreateProposalDevelopmentTaskHook(protocol);
        this.canCreateProposalDevelopment = this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task);
    }

    protected abstract ProtocolTaskBase getNewInstanceCreateProposalDevelopmentTaskHook(ProtocolBase var1);

    private void initializeProtocolProposalDevelopmentLinking() {
        this.protocolProposalDevelopmentLinkingEnabled = this.getProtocolProposalDevelopmentLinkingHook();
    }

    protected abstract boolean getProtocolProposalDevelopmentLinkingHook();

    public boolean isProtocolProposalDevelopmentLinkingEnabled() {
        return this.protocolProposalDevelopmentLinkingEnabled;
    }

    private String getParameterValue(String parameterName) {
        return this.getParameterService().getParameterValueAsString(this.getProtocolDocumentClassHook(), parameterName);
    }

    protected abstract Class<? extends ProtocolDocumentBase> getProtocolDocumentClassHook();

    public void setReferenceId1Label(String referenceId1Label) {
        this.referenceId1Label = referenceId1Label;
    }

    public String getReferenceId1Label() {
        return this.referenceId1Label;
    }

    public void setReferenceId2Label(String referenceId2Label) {
        this.referenceId2Label = referenceId2Label;
    }

    public String getReferenceId2Label() {
        return this.referenceId2Label;
    }

    public boolean getModifyProtocol() {
        return this.modifyProtocol;
    }

    public boolean getBillableReadOnly() {
        return this.billableReadOnly;
    }

    protected TaskAuthorizationService getTaskAuthorizationService() {
        return KraServiceLocator.getService(TaskAuthorizationService.class);
    }

    protected String getUserIdentifier() {
        return GlobalVariables.getUserSession().getPrincipalId();
    }

    public void syncFundingSources(ProtocolBase protocol) {
        if (protocol != null) {
            if (this.newFundingSource != null) {
                this.syncFundingSource(this.newFundingSource);
            }
            for (ProtocolFundingSourceBase source : protocol.getProtocolFundingSources()) {
                this.syncFundingSource(source);
            }
        }
    }

    private void syncFundingSource(ProtocolFundingSourceBase source) {
        ProtocolFundingSourceBase syncedSource = this.getProtocolFundingSourceService().updateProtocolFundingSource(source.getFundingSourceTypeCode(), source.getFundingSourceNumber(), source.getFundingSourceName());
        if (syncedSource != null) {
            source.setProtocol(this.getProtocol());
            source.setFundingSourceNumber(syncedSource.getFundingSourceNumber());
            source.setFundingSourceName(syncedSource.getFundingSourceName());
            source.setFundingSourceTitle(syncedSource.getFundingSourceTitle());
        }
    }

    public String getPrincipalInvestigatorId() {
        return this.principalInvestigatorId;
    }

    public void setPrincipalInvestigatorId(String principalInvestigatorId) {
        this.principalInvestigatorId = principalInvestigatorId;
    }

    public String getPrincipalInvestigatorName() {
        return this.principalInvestigatorName;
    }

    public void setPrincipalInvestigatorName(String principalInvestigatorName) {
        this.principalInvestigatorName = principalInvestigatorName;
    }

    public String getPersonId() {
        return this.personId;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    public String getRolodexId() {
        return this.rolodexId;
    }

    public void setRolodexId(String rolodexId) {
        this.rolodexId = rolodexId;
    }

    public String getLeadUnitNumber() {
        return this.leadUnitNumber;
    }

    public void setLeadUnitNumber(String leadUnitNumber) {
        this.leadUnitNumber = leadUnitNumber;
    }

    public String getLeadUnitName() {
        return this.leadUnitName;
    }

    public void setLeadUnitName(String leadUnitName) {
        this.leadUnitName = leadUnitName;
    }

    public boolean isNonEmployeeFlag() {
        return this.nonEmployeeFlag;
    }

    public void setNonEmployeeFlag(boolean nonEmployeeFlag) {
        this.nonEmployeeFlag = nonEmployeeFlag;
    }

    public String getLookupUnitName() {
        return this.lookupUnitName;
    }

    public void setLookupUnitName(String lookupUnitName) {
        this.lookupUnitName = lookupUnitName;
    }

    public String getLookupUnitNumber() {
        return this.lookupUnitNumber;
    }

    public void setLookupUnitNumber(String lookupUnitNumber) {
        this.lookupUnitNumber = lookupUnitNumber;
    }

    private void prepareRequiredFields() {
        ProtocolBase theProtocol = this.getProtocol();
        if (theProtocol.getProtocolId() == null) {
            this.findPrincipalInvestigatorIdFromFields();
            this.findAndSetLeadUnitFromFields();
        } else {
            this.resolveRequiredFieldsFromBO();
        }
    }

    public boolean isLeadUnitAutoPopulated() {
        return this.leadUnitAutoPopulated;
    }

    public void setLeadUnitAutoPopulated(boolean leadUnitAutoPopulated) {
        this.leadUnitAutoPopulated = leadUnitAutoPopulated;
    }

    public void prepareRequiredFieldsForSave() {
        if (this.getProtocol().getProtocolNumber() == null) {
            this.getProtocol().setProtocolNumber(this.getProtocolNumberService().generateProtocolNumber());
        }
        this.findPrincipalInvestigatorIdFromFields();
        this.findAndSetLeadUnitFromFields();
        this.getProtocolPersonnelService().setPrincipalInvestigator(this.createPrincipalInvestigator(), this.getProtocol());
        ProtocolPersonBase principalInvestigator = this.getProtocolPersonnelService().getPrincipalInvestigator(this.getProtocol().getProtocolPersons());
        this.getProtocolPersonnelService().setLeadUnit(this.createLeadUnit(), principalInvestigator, this.getProtocol());
    }

    public void createInitialProtocolAction() {
        if (this.getProtocol().getProtocolDocument().getDocumentHeader().getWorkflowDocument().isInitiated()) {
            this.getProtocol().getProtocolActions().clear();
            ProtocolActionBase protocolAction = this.createProtocolCreatedTypeProtocolActionInstanceHook(this.getProtocol());
            protocolAction.setComments(PROTOCOL_CREATED);
            this.getProtocol().getProtocolActions().add(protocolAction);
        }
    }

    protected abstract ProtocolActionBase createProtocolCreatedTypeProtocolActionInstanceHook(ProtocolBase var1);

    public abstract void syncSpecialReviewsWithFundingSources() throws WorkflowException;

    protected abstract ProtocolNumberServiceBase getProtocolNumberService();

    private KcPersonService getPersonService() {
        if (this.personService == null) {
            this.personService = KraServiceLocator.getService(KcPersonService.class);
        }
        return this.personService;
    }

    private void findPrincipalInvestigatorIdFromFields() {
        if (StringUtils.isNotEmpty((String)this.getRolodexId())) {
            this.setPrincipalInvestigatorId(this.getRolodexId());
            this.setNonEmployeeFlag(true);
        } else if (StringUtils.isNotEmpty((String)this.getPersonId())) {
            this.setPrincipalInvestigatorId(this.getPersonId());
            this.setNonEmployeeFlag(false);
        }
    }

    private Unit getPIUnit(String piId) {
        Contactable pi = null;
        if (StringUtils.isNotBlank((String)piId)) {
            if (!this.nonEmployeeFlag) {
                pi = this.getPersonService().getKcPersonByPersonId(this.getPrincipalInvestigatorId());
            } else if (StringUtils.isNotBlank((String)this.rolodexId)) {
                pi = this.getRolodexService().getRolodex(Integer.parseInt(this.rolodexId));
            }
        }
        return pi == null ? null : pi.getUnit();
    }

    private void verifyLeadUnitAutoPopulation() {
        Unit piUnit;
        if (StringUtils.isNotEmpty((String)this.getProtocol().getPrincipalInvestigatorId()) && StringUtils.isNotEmpty((String)this.getProtocol().getLeadUnitNumber()) && (piUnit = this.getPIUnit(this.getProtocol().getPrincipalInvestigatorId())) != null && !StringUtils.equals((String)piUnit.getUnitNumber(), (String)this.getProtocol().getLeadUnitNumber())) {
            this.setLeadUnitAutoPopulated(false);
        }
    }

    private void findAndSetLeadUnitFromFields() {
        this.getProtocol().setLeadUnitNumber(this.getLeadUnitNumber());
        this.setLeadUnitName(this.getUnitService().getUnitName(this.getLeadUnitNumber()));
        this.verifyLeadUnitAutoPopulation();
        if ((StringUtils.isEmpty((String)this.getLeadUnitName()) && StringUtils.isEmpty((String)this.getLeadUnitNumber()) || this.isLeadUnitAutoPopulated()) && StringUtils.isNotEmpty((String)this.getLookupUnitNumber())) {
            this.setLeadUnitNumber(this.getLookupUnitNumber());
            this.setLeadUnitName(this.getLookupUnitName());
            this.setLeadUnitAutoPopulated(true);
        }
        this.setLookupUnitNumber(null);
        this.setLookupUnitName(null);
    }

    private ProtocolUnitBase createLeadUnit() {
        ProtocolUnitBase ret = null;
        if (StringUtils.isNotEmpty((String)this.getLeadUnitNumber()) && StringUtils.isNotEmpty((String)this.getLeadUnitName())) {
            ret = this.createNewProtocolUnitInstanceHook();
            ret.setLeadUnitFlag(true);
            ret.setUnitNumber(this.getLeadUnitNumber());
            ret.setUnitName(this.getLeadUnitName());
        }
        return ret;
    }

    protected abstract ProtocolUnitBase createNewProtocolUnitInstanceHook();

    private ProtocolPersonBase createPrincipalInvestigator() {
        ProtocolPersonBase pi = null;
        if (!StringUtils.isBlank((String)this.getPrincipalInvestigatorId())) {
            pi = this.createNewProtocolPersonInstanceHook();
            pi.setProtocolPersonRoleId("PI");
            pi.setProtocolNumber(this.getProtocol().getProtocolNumber());
            pi.setSequenceNumber(0);
            pi.refreshReferenceObject("protocolPersonRole");
            if (this.isNonEmployeeFlag()) {
                pi.refreshReferenceObject("rolodex");
                pi.setRolodexId(Integer.valueOf(this.principalInvestigatorId));
            } else {
                pi.setPersonId(this.principalInvestigatorId);
            }
            pi.setPersonName(this.getPrincipalInvestigatorName());
        }
        return pi;
    }

    protected abstract ProtocolPersonBase createNewProtocolPersonInstanceHook();

    private void resolveRequiredFieldsFromBO() {
        ProtocolPersonBase pi = this.getProtocol().getPrincipalInvestigator();
        if (pi != null) {
            this.setPrincipalInvestigatorName(pi.getPersonName());
            if (pi.isNonEmployee()) {
                this.setPrincipalInvestigatorId(pi.getRolodexId().toString());
                this.setNonEmployeeFlag(pi.isNonEmployee());
            } else {
                this.setPrincipalInvestigatorId(pi.getPersonId());
            }
            if (pi.getLeadUnit() != null) {
                this.setLeadUnitNumber(pi.getLeadUnit().getUnitNumber());
                this.setLeadUnitName(pi.getLeadUnit().getUnitName());
            }
        }
    }

    private UnitService getUnitService() {
        return KraServiceLocator.getService(UnitService.class);
    }

    public ProtocolLocationBase getNewProtocolLocation() {
        return this.newProtocolLocation;
    }

    public void setNewProtocolLocation(ProtocolLocationBase newProtocolLocation) {
        this.newProtocolLocation = newProtocolLocation;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    protected abstract ProtocolPersonnelService getProtocolPersonnelService();

    public boolean getDisplayBillable() {
        return this.displayBillable;
    }

    public void setDisplayBillable(boolean displayBillable) {
        this.displayBillable = displayBillable;
    }

    public ProtocolFundingSourceBase getNewFundingSource() {
        return this.newFundingSource;
    }

    public void setNewFundingSource(ProtocolFundingSourceBase newFundingSource) {
        this.newFundingSource = newFundingSource;
    }

    public boolean getModifyFundingSource() {
        return this.modifyFundingSource;
    }

    public boolean getModifyGeneralInfo() {
        return this.modifyGeneralInfo;
    }

    public boolean getModifyReferences() {
        return this.modifyReferences;
    }

    public boolean getModifyOrganizations() {
        return this.modifyOrganizations;
    }

    public boolean getModifyAreasOfResearch() {
        return this.modifyAreasOfResearch;
    }

    public boolean isCanCreateProposalDevelopment() {
        return this.canCreateProposalDevelopment;
    }

    public boolean isFundingNumberLookupable() {
        if (this.newFundingSource != null && StringUtils.isNotBlank((String)this.newFundingSource.getFundingSourceTypeCode())) {
            return this.getProtocolFundingSourceService().isLookupable(this.newFundingSource.getFundingSourceTypeCode());
        }
        return false;
    }

    public boolean isSourceNameEditable() {
        if (this.newFundingSource != null && StringUtils.isNotBlank((String)this.newFundingSource.getFundingSourceTypeCode())) {
            return this.getProtocolFundingSourceService().isEditable(this.newFundingSource.getFundingSourceTypeCode());
        }
        return true;
    }

    protected RoleService getRoleService() {
        return KraServiceLocator.getService(RoleService.class);
    }

    public List<ProtocolFundingSourceBase> getNewProtocolFundingSources() {
        return this.newProtocolFundingSources;
    }

    public void setNewProtocolFundingSources(List<ProtocolFundingSourceBase> newProtocolFundingSources) {
        this.newProtocolFundingSources = newProtocolFundingSources;
    }

    public List<ProtocolFundingSourceBase> findNewFundingSources() {
        ArrayList<ProtocolFundingSourceBase> fundingSources = new ArrayList<ProtocolFundingSourceBase>();
        for (ProtocolFundingSourceBase fundingSource : this.getProtocol().getProtocolFundingSources()) {
            if (fundingSource.getProtocolFundingSourceId() != null) continue;
            fundingSources.add(fundingSource);
        }
        return fundingSources;
    }
}

