/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.protocol.funding;

import org.kuali.kra.protocol.protocol.funding.LookupProtocolFundingSourceEventBase;
import org.kuali.kra.rule.BusinessRuleInterface;
import org.kuali.kra.rules.ErrorReporter;
import org.kuali.kra.rules.ResearchDocumentRuleBase;

public class LookupProtocolFundingSourceRule
extends ResearchDocumentRuleBase
implements BusinessRuleInterface<LookupProtocolFundingSourceEventBase> {
    private final ErrorReporter errorReporter = new ErrorReporter();

    @Override
    public boolean processRules(LookupProtocolFundingSourceEventBase event) {
        boolean valid = true;
        if (event.getFundingSourceTypeCode() == null) {
            this.errorReporter.reportError("protocolHelper.newFundingSource.fundingSourceTypeCode", "error.protocolFundingSource.fundingSourceLookup.notFound", new String[0]);
            valid = false;
        } else {
            valid &= this.isValidLookup(event.getFundingSourceTypeCode());
        }
        return valid;
    }

    private boolean isValidLookup(String fundingSourceTypeCode) {
        boolean isValid = true;
        if (!("1".equals(fundingSourceTypeCode) || "2".equals(fundingSourceTypeCode) || "4".equals(fundingSourceTypeCode) || "5".equals(fundingSourceTypeCode) || "6".equals(fundingSourceTypeCode))) {
            this.errorReporter.reportError("protocolHelper.newFundingSource.fundingSourceTypeCode", "error.protocolFundingSource.fundingSourceLookup.invalid", new String[0]);
            isValid = false;
        }
        return isValid;
    }
}

