/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.protocol.location;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.protocol.location.ProtocolLocationBase;
import org.kuali.kra.protocol.protocol.location.ProtocolLocationService;
import org.kuali.kra.service.OrganizationService;

public abstract class ProtocolLocationServiceImplBase
implements ProtocolLocationService {
    private static final Log LOG = LogFactory.getLog(ProtocolLocationServiceImplBase.class);
    private OrganizationService organizationService;
    private static final String REFERENCE_PROTOCOL_ORGANIZATION_TYPE = "protocolOrganizationType";
    private static final String REFERENCE_ORGANIZATION = "organization";
    private static final String REFERENCE_ROLODEX = "rolodex";
    private static final String PROTOCOL_NUMBER = "0";
    private static final Integer SEQUENCE_NUMBER = 0;

    @Override
    public void addProtocolLocation(ProtocolBase protocol, ProtocolLocationBase protocolLocation) {
        protocolLocation.setProtocolNumber(PROTOCOL_NUMBER);
        protocolLocation.setSequenceNumber(SEQUENCE_NUMBER);
        protocolLocation.refreshReferenceObject(REFERENCE_PROTOCOL_ORGANIZATION_TYPE);
        protocolLocation.refreshReferenceObject(REFERENCE_ORGANIZATION);
        protocolLocation.setRolodexId(protocolLocation.getOrganization().getContactAddressId());
        protocolLocation.refreshReferenceObject(REFERENCE_ROLODEX);
        protocol.getProtocolLocations().add(protocolLocation);
    }

    @Override
    public void addDefaultProtocolLocation(ProtocolBase protocol) {
        if (protocol.getProtocolLocations().size() == 0) {
            ProtocolLocationBase protocolLocation = this.getNewProtocolLocationInstanceHook();
            protocolLocation.setProtocolNumber(PROTOCOL_NUMBER);
            protocolLocation.setSequenceNumber(SEQUENCE_NUMBER);
            Organization organization = this.getOrganization(this.getDefaultProtocolOrganizationIdHook());
            protocolLocation.setOrganization(organization);
            protocolLocation.setOrganizationId(organization.getOrganizationId());
            protocolLocation.setRolodexId(organization.getContactAddressId());
            protocolLocation.setProtocolOrganizationTypeCode(this.getDefaultProtocolOrganizationTypeCodeHook());
            protocolLocation.refreshReferenceObject(REFERENCE_PROTOCOL_ORGANIZATION_TYPE);
            protocolLocation.refreshReferenceObject(REFERENCE_ROLODEX);
            protocol.getProtocolLocations().add(protocolLocation);
        }
    }

    protected abstract String getDefaultProtocolOrganizationIdHook();

    protected abstract String getDefaultProtocolOrganizationTypeCodeHook();

    protected abstract ProtocolLocationBase getNewProtocolLocationInstanceHook();

    @Override
    public void clearProtocolLocationAddress(ProtocolBase protocol, int lineNumber) {
        protocol.getProtocolLocations().get(lineNumber).setRolodexId(new Integer(0));
        protocol.getProtocolLocations().get(lineNumber).setRolodex(new Rolodex());
    }

    protected Organization getOrganization(String organizationId) {
        return this.organizationService.getOrganization(organizationId);
    }

    public void setOrganizationService(OrganizationService organizationService) {
        this.organizationService = organizationService;
    }
}

