/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.protocol.reference;

import java.sql.Date;
import java.text.DateFormat;
import java.text.ParseException;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.protocol.ProtocolAssociateBase;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.protocol.reference.ProtocolReferenceBeanBase;
import org.kuali.kra.protocol.protocol.reference.ProtocolReferenceTypeBase;

public abstract class ProtocolReferenceBase
extends ProtocolAssociateBase {
    private static final long serialVersionUID = 7610203950849323256L;
    private Long protocolReferenceId;
    private Integer protocolReferenceNumber;
    private Integer protocolReferenceTypeCode;
    private String referenceKey;
    private Date applicationDate;
    private Date approvalDate;
    private String comments;
    private ProtocolReferenceTypeBase protocolReferenceType;

    public ProtocolReferenceBase() {
    }

    public ProtocolReferenceBase(ProtocolReferenceBeanBase bean, ProtocolBase protocol, ProtocolReferenceTypeBase protocolReferenceType) throws ParseException {
        this.protocolReferenceType = protocolReferenceType;
        this.protocolReferenceTypeCode = protocolReferenceType.getProtocolReferenceTypeCode();
        this.setProtocol(protocol);
        this.setProtocolId(protocol.getProtocolId());
        this.setProtocolNumber(protocol.getProtocolNumber());
        this.referenceKey = bean.getReferenceKey();
        this.comments = bean.getComments();
        this.setApplicationDate(this.convertStringToDate(bean.getApplicationDate()));
        this.setApprovalDate(this.convertStringToDate(bean.getApprovalDate()));
    }

    private Date convertStringToDate(String stringDate) throws ParseException {
        if (!StringUtils.isBlank((String)stringDate)) {
            Date date = new Date(DateFormat.getDateInstance(3).parse(stringDate).getTime());
            return date;
        }
        return null;
    }

    public void setProtocolReferenceId(Long protocolReferenceId) {
        this.protocolReferenceId = protocolReferenceId;
    }

    public Long getProtocolReferenceId() {
        return this.protocolReferenceId;
    }

    public Integer getProtocolReferenceNumber() {
        return this.protocolReferenceNumber;
    }

    public void setProtocolReferenceNumber(Integer protocolReferenceNumber) {
        this.protocolReferenceNumber = protocolReferenceNumber;
    }

    public Integer getProtocolReferenceTypeCode() {
        return this.protocolReferenceTypeCode;
    }

    public void setProtocolReferenceTypeCode(Integer protocolReferenceTypeCode) {
        this.protocolReferenceTypeCode = protocolReferenceTypeCode;
    }

    public String getReferenceKey() {
        return this.referenceKey;
    }

    public void setReferenceKey(String referenceKey) {
        this.referenceKey = referenceKey;
    }

    public Date getApplicationDate() {
        return this.applicationDate;
    }

    public void setApplicationDate(Date applicationDate) {
        this.applicationDate = applicationDate;
    }

    public Date getApprovalDate() {
        return this.approvalDate;
    }

    public void setApprovalDate(Date approvalDate) {
        this.approvalDate = approvalDate;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public ProtocolReferenceTypeBase getProtocolReferenceType() {
        return this.protocolReferenceType;
    }

    public void setProtocolReferenceType(ProtocolReferenceTypeBase protocolReferenceType) {
        this.protocolReferenceType = protocolReferenceType;
    }

    @Override
    public void postInitHook(ProtocolBase aProtocol) {
        this.setProtocolReferenceNumber(null);
    }

    @Override
    public void resetPersistenceState() {
        this.setProtocolReferenceId(null);
    }
}

