/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.summary;

import java.io.Serializable;
import java.sql.Timestamp;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.protocol.summary.ProtocolSummary;

public class AttachmentSummary
implements Serializable {
    private static final long serialVersionUID = -6058410492582759356L;
    private Long attachmentId;
    private String fileName;
    private boolean fileNameChanged;
    private String fileType;
    private boolean fileTypeChanged;
    private long dataLength;
    private String attachmentType;
    private boolean attachmentTypeChanged;
    private String description;
    private boolean descriptionChanged;
    private String updateUser;
    private boolean userChanged;
    private Timestamp updateTimestamp;
    private boolean dateChanged;

    public Long getAttachmentId() {
        return this.attachmentId;
    }

    public void setAttachmentId(Long attachmentId) {
        this.attachmentId = attachmentId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public long getDataLength() {
        return this.dataLength;
    }

    public void setDataLength(long dataLength) {
        this.dataLength = dataLength;
    }

    public boolean isFileNameChanged() {
        return this.fileNameChanged;
    }

    public void compare(ProtocolSummary other) {
        AttachmentSummary otherAttachment = other.findAttachment(this.fileName, this.fileType, this.dataLength);
        if (otherAttachment == null) {
            this.fileNameChanged = true;
            this.fileTypeChanged = true;
            this.attachmentTypeChanged = true;
            this.descriptionChanged = true;
            this.dateChanged = true;
            this.userChanged = true;
        } else {
            this.fileNameChanged = !StringUtils.equals((String)this.fileName, (String)otherAttachment.getFileName());
            this.fileTypeChanged = !StringUtils.equals((String)this.fileType, (String)otherAttachment.getFileType());
            this.attachmentTypeChanged = !StringUtils.equals((String)this.attachmentType, (String)otherAttachment.getAttachmentType());
            this.descriptionChanged = !StringUtils.equals((String)this.description, (String)otherAttachment.getDescription());
            this.dateChanged = this.updateTimestamp != otherAttachment.getUpdateTimestamp() && (this.updateTimestamp == null || !this.updateTimestamp.equals(otherAttachment.getUpdateTimestamp()));
            this.userChanged = !StringUtils.equals((String)this.updateUser, (String)otherAttachment.getUpdateUser());
        }
    }

    public String getAttachmentType() {
        return this.attachmentType;
    }

    public void setAttachmentType(String attachmentType) {
        this.attachmentType = attachmentType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUpdateUser() {
        return this.updateUser;
    }

    public void setUpdateUser(String updateUser) {
        this.updateUser = updateUser;
    }

    public Timestamp getUpdateTimestamp() {
        return this.updateTimestamp;
    }

    public void setUpdateTimestamp(Timestamp updateTimestamp) {
        this.updateTimestamp = updateTimestamp;
    }

    public boolean isFileTypeChanged() {
        return this.fileTypeChanged;
    }

    public void setFileTypeChanged(boolean fileTypeChanged) {
        this.fileTypeChanged = fileTypeChanged;
    }

    public boolean isAttachmentTypeChanged() {
        return this.attachmentTypeChanged;
    }

    public void setAttachmentTypeChanged(boolean attachmentTypeChanged) {
        this.attachmentTypeChanged = attachmentTypeChanged;
    }

    public boolean isDescriptionChanged() {
        return this.descriptionChanged;
    }

    public void setDescriptionChanged(boolean descriptionChanged) {
        this.descriptionChanged = descriptionChanged;
    }

    public void setFileNameChanged(boolean fileNameChanged) {
        this.fileNameChanged = fileNameChanged;
    }

    public boolean isUserChanged() {
        return this.userChanged;
    }

    public void setUserChanged(boolean userChanged) {
        this.userChanged = userChanged;
    }

    public boolean isDateChanged() {
        return this.dateChanged;
    }

    public void setDateChanged(boolean dateChanged) {
        this.dateChanged = dateChanged;
    }
}

