/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.summary;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.summary.AdditionalInfoSummary;
import org.kuali.kra.protocol.summary.AttachmentSummary;
import org.kuali.kra.protocol.summary.FundingSourceSummary;
import org.kuali.kra.protocol.summary.OrganizationSummary;
import org.kuali.kra.protocol.summary.PersonnelSummary;
import org.kuali.kra.protocol.summary.ResearchAreaSummary;
import org.kuali.kra.protocol.summary.SpecialReviewSummary;

public class ProtocolSummary
implements Serializable {
    private static final long serialVersionUID = 1880834136103817283L;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
    private String lastProtocolActionDescription;
    private String protocolNumber;
    private String initialSubmissionDate;
    private String approvalDate;
    private String lastApprovalDate;
    private String expirationDate;
    private String piName;
    private Integer piProtocolPersonId;
    private String type;
    private String status;
    private String title;
    private List<PersonnelSummary> persons = new ArrayList<PersonnelSummary>();
    private List<ResearchAreaSummary> researchAreas = new ArrayList<ResearchAreaSummary>();
    private List<AttachmentSummary> attachments = new ArrayList<AttachmentSummary>();
    private List<FundingSourceSummary> fundingSources = new ArrayList<FundingSourceSummary>();
    private List<OrganizationSummary> organizations = new ArrayList<OrganizationSummary>();
    private List<SpecialReviewSummary> specialReviews = new ArrayList<SpecialReviewSummary>();
    private AdditionalInfoSummary additionalInfoSummary;
    private boolean protocolNumberChanged = false;
    private boolean initialSubmissionDateChanged = false;
    private boolean approvalDateChanged = false;
    private boolean lastApprovalDateChanged = false;
    private boolean expirationDateChanged = false;
    private boolean piNameChanged = false;
    private boolean typeChanged = false;
    private boolean statusChanged = false;
    private boolean titleChanged = false;

    public void setLastProtocolAction(ProtocolActionBase protocolAction) {
        this.lastProtocolActionDescription = protocolAction == null ? "" : protocolAction.getProtocolActionType().getDescription() + " " + this.dateFormat.format(protocolAction.getActionDate());
    }

    public String getLastProtocolActionDescription() {
        return this.lastProtocolActionDescription;
    }

    public String getProtocolNumber() {
        return this.protocolNumber;
    }

    public void setProtocolNumber(String protocolNumber) {
        this.protocolNumber = protocolNumber;
    }

    public String getInitialSubmissionDate() {
        return this.initialSubmissionDate;
    }

    public void setInitialSubmissionDate(java.sql.Date initialSubmissionDate) {
        this.initialSubmissionDate = this.formatDate(initialSubmissionDate);
    }

    public String getApprovalDate() {
        return this.approvalDate;
    }

    public void setApprovalDate(java.sql.Date approvalDate) {
        this.approvalDate = this.formatDate(approvalDate);
    }

    public String getLastApprovalDate() {
        return this.lastApprovalDate;
    }

    public void setLastApprovalDate(java.sql.Date lastApprovalDate) {
        this.lastApprovalDate = this.formatDate(lastApprovalDate);
    }

    public String getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(java.sql.Date expirationDate) {
        this.expirationDate = this.formatDate(expirationDate);
    }

    public String getPiName() {
        return this.piName;
    }

    public void setPiName(String piName) {
        this.piName = piName;
    }

    public Integer getPiProtocolPersonId() {
        return this.piProtocolPersonId;
    }

    public void setPiProtocolPersonId(Integer protocolPersonId) {
        this.piProtocolPersonId = protocolPersonId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    private String formatDate(Date date) {
        return date == null ? "" : this.dateFormat.format(date);
    }

    public List<PersonnelSummary> getPersons() {
        return this.persons;
    }

    public void add(PersonnelSummary personnelSummary) {
        this.persons.add(personnelSummary);
    }

    public List<ResearchAreaSummary> getResearchAreas() {
        return this.researchAreas;
    }

    public void add(ResearchAreaSummary researchAreaSummary) {
        this.researchAreas.add(researchAreaSummary);
    }

    public List<AttachmentSummary> getAttachments() {
        return this.attachments;
    }

    public void add(AttachmentSummary attachmentSummary) {
        this.attachments.add(attachmentSummary);
    }

    public List<FundingSourceSummary> getFundingSources() {
        return this.fundingSources;
    }

    public void add(FundingSourceSummary fundingSourceSummary) {
        this.fundingSources.add(fundingSourceSummary);
    }

    public List<OrganizationSummary> getOrganizations() {
        return this.organizations;
    }

    public void add(OrganizationSummary organizationSummary) {
        this.organizations.add(organizationSummary);
    }

    public List<SpecialReviewSummary> getSpecialReviews() {
        return this.specialReviews;
    }

    public void add(SpecialReviewSummary specialReviewSummary) {
        this.specialReviews.add(specialReviewSummary);
    }

    public AdditionalInfoSummary getAdditionalInfo() {
        return this.additionalInfoSummary;
    }

    public void setAdditionalInfo(AdditionalInfoSummary additionalInfoSummary) {
        this.additionalInfoSummary = additionalInfoSummary;
    }

    public void compare(ProtocolSummary other) {
        this.protocolNumberChanged = !StringUtils.equals((String)this.protocolNumber, (String)other.protocolNumber);
        this.initialSubmissionDateChanged = !StringUtils.equals((String)this.initialSubmissionDate, (String)other.initialSubmissionDate);
        this.approvalDateChanged = !StringUtils.equals((String)this.approvalDate, (String)other.approvalDate);
        this.lastApprovalDateChanged = !StringUtils.equals((String)this.lastApprovalDate, (String)other.lastApprovalDate);
        this.expirationDateChanged = !StringUtils.equals((String)this.expirationDate, (String)other.expirationDate);
        this.piNameChanged = !StringUtils.equals((String)this.piName, (String)other.piName);
        this.typeChanged = !StringUtils.equals((String)this.type, (String)other.type);
        this.statusChanged = !StringUtils.equals((String)this.status, (String)other.status);
        this.titleChanged = !StringUtils.equals((String)this.title, (String)other.title);
        this.comparePersonnel(other);
        this.compareResearchAreas(other);
        this.compareSpecialReviews(other);
        this.compareFundingSources(other);
        this.compareOrganizations(other);
        this.compareAttachments(other);
        this.additionalInfoSummary.compare(other.getAdditionalInfo());
    }

    private void compareAttachments(ProtocolSummary other) {
        for (AttachmentSummary attachment : this.attachments) {
            attachment.compare(other);
        }
    }

    private void compareOrganizations(ProtocolSummary other) {
        for (OrganizationSummary organization : this.organizations) {
            organization.compare(other);
        }
    }

    private void compareFundingSources(ProtocolSummary other) {
        for (FundingSourceSummary fundingSource : this.fundingSources) {
            fundingSource.compare(other);
        }
    }

    private void compareSpecialReviews(ProtocolSummary other) {
        for (SpecialReviewSummary specialReview : this.specialReviews) {
            specialReview.compare(other);
        }
    }

    private void comparePersonnel(ProtocolSummary other) {
        for (PersonnelSummary person : this.persons) {
            person.compare(other);
        }
    }

    private void compareResearchAreas(ProtocolSummary other) {
        for (ResearchAreaSummary researchArea : this.researchAreas) {
            researchArea.compare(other);
        }
    }

    public boolean isProtocolNumberChanged() {
        return this.protocolNumberChanged;
    }

    public boolean isInitialSubmissionDateChanged() {
        return this.initialSubmissionDateChanged;
    }

    public boolean isApprovalDateChanged() {
        return this.approvalDateChanged;
    }

    public boolean isLastApprovalDateChanged() {
        return this.lastApprovalDateChanged;
    }

    public boolean isExpirationDateChanged() {
        return this.expirationDateChanged;
    }

    public boolean isPiNameChanged() {
        return this.piNameChanged;
    }

    public boolean isTypeChanged() {
        return this.typeChanged;
    }

    public boolean isStatusChanged() {
        return this.statusChanged;
    }

    public boolean isTitleChanged() {
        return this.titleChanged;
    }

    public PersonnelSummary findPerson(String name) {
        for (PersonnelSummary person : this.persons) {
            if (!StringUtils.equals((String)person.getPersonId(), (String)name)) continue;
            return person;
        }
        return null;
    }

    public ResearchAreaSummary findResearchArea(String researchAreaCode) {
        for (ResearchAreaSummary researchArea : this.researchAreas) {
            if (!StringUtils.equals((String)researchArea.getResearchAreaCode(), (String)researchAreaCode)) continue;
            return researchArea;
        }
        return null;
    }

    public SpecialReviewSummary findSpecialReview(String type, String approvalStatus) {
        for (SpecialReviewSummary specialReview : this.specialReviews) {
            if (!StringUtils.equals((String)specialReview.getType(), (String)type) || !StringUtils.equals((String)specialReview.getApprovalStatus(), (String)approvalStatus)) continue;
            return specialReview;
        }
        return null;
    }

    public FundingSourceSummary findFundingSource(String fundingSourceType, String fundingSource) {
        for (FundingSourceSummary source : this.fundingSources) {
            if (!StringUtils.equals((String)source.getFundingSourceType(), (String)fundingSourceType) || !StringUtils.equals((String)source.getFundingSource(), (String)fundingSource)) continue;
            return source;
        }
        return null;
    }

    public OrganizationSummary findOrganization(String organizationId) {
        for (OrganizationSummary organization : this.organizations) {
            if (!StringUtils.equals((String)organization.getOrganizationId(), (String)organizationId)) continue;
            return organization;
        }
        return null;
    }

    public AttachmentSummary findAttachment(String fileName, String fileType, long dataLength) {
        for (AttachmentSummary attachment : this.attachments) {
            if (!StringUtils.equals((String)attachment.getFileName(), (String)fileName) || !StringUtils.equals((String)attachment.getFileType(), (String)fileType) || attachment.getDataLength() != dataLength) continue;
            return attachment;
        }
        return null;
    }
}

