/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.questionnaire;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kra.document.ResearchDocumentBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.questionnaire.QuestionnaireUsage;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.questionnaire.answer.ModuleQuestionnaireBean;
import org.kuali.kra.questionnaire.answer.QuestionnaireAnswerService;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;

public abstract class BaseQuestionnaireAuditRule<T extends ResearchDocumentBase>
extends ResearchDocumentRuleBase
implements DocumentAuditRule {
    private static final String MANDATORY_QUESTIONNAIRE_AUDIT_ERRORS = "mandatoryQuestionnaireAuditErrors";
    private List<AuditError> auditErrors;

    protected abstract List<Integer> getIncompleteMandatoryQuestionnaire(T var1);

    @Override
    public boolean processRunAuditBusinessRules(Document document) {
        ResearchDocumentBase inDocument = (ResearchDocumentBase)document;
        this.auditErrors = new ArrayList<AuditError>();
        List<Integer> headerIds = this.getIncompleteMandatoryQuestionnaire(inDocument);
        if (!headerIds.isEmpty()) {
            this.addErrorToAuditErrors(headerIds);
        }
        this.reportAndCreateAuditCluster(this.getAuditErrorsLabel());
        return headerIds.isEmpty();
    }

    protected List<Integer> getIncompleteMandatoryQuestionnaire(String ModuleCode, ModuleQuestionnaireBean moduleQuestionnaireBean) {
        ArrayList<Integer> headers = new ArrayList<Integer>();
        int i = 0;
        for (AnswerHeader answerHeader : this.getQuestionnaireAnswerService().getQuestionnaireAnswer(moduleQuestionnaireBean)) {
            if (this.getQuestionnaireUsage(ModuleCode, moduleQuestionnaireBean.getModuleSubItemCode(), answerHeader.getQuestionnaire().getQuestionnaireUsages()).isMandatory() && !answerHeader.getCompleted()) {
                headers.add(i);
            }
            ++i;
        }
        return headers;
    }

    protected abstract String getAuditErrorLink();

    protected abstract String getAuditErrorsLabel();

    protected QuestionnaireUsage getQuestionnaireUsage(String moduleItemCode, String moduleSubItemCode, List<QuestionnaireUsage> questionnaireUsages) {
        QuestionnaireUsage usage = null;
        int version = 0;
        for (QuestionnaireUsage questionnaireUsage : questionnaireUsages) {
            if (!moduleItemCode.equals(questionnaireUsage.getModuleItemCode()) || !moduleSubItemCode.equals(questionnaireUsage.getModuleSubItemCode()) || questionnaireUsage.getQuestionnaireSequenceNumber() <= version) continue;
            version = questionnaireUsage.getQuestionnaireSequenceNumber();
            usage = questionnaireUsage;
        }
        return usage;
    }

    protected void addErrorToAuditErrors(List<Integer> headerIds) {
        for (Integer id : headerIds) {
            this.auditErrors.add(new AuditError("questionnaireHelper.answerHeaders[" + id + "].answers[0].answer", "error.mandatory.questionnaire", this.getAuditErrorLink()));
        }
    }

    protected void reportAndCreateAuditCluster(String label) {
        if (this.auditErrors.size() > 0) {
            KNSGlobalVariables.getAuditErrorMap().put(MANDATORY_QUESTIONNAIRE_AUDIT_ERRORS, new AuditCluster(label, this.auditErrors, "Validation Errors"));
        }
    }

    protected QuestionnaireAnswerService getQuestionnaireAnswerService() {
        return KraServiceLocator.getService(QuestionnaireAnswerService.class);
    }
}

