/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.questionnaire;

import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.questionnaire.QuestionLookupForm;
import org.kuali.kra.questionnaire.question.Question;
import org.kuali.rice.kns.lookup.LookupResultsService;
import org.kuali.rice.kns.web.struts.action.KualiAction;
import org.kuali.rice.krad.util.GlobalVariables;

public class QuestionLookupAction
extends KualiAction {
    private static final String PFP = "#f#";
    private static final String PQP = "#q#";
    private static final String SINGLE_LOOKUP = "singleLookup";
    private static final String MULTI_LOOKUP = "multiLookup";
    private static final String REPLACE_LOOKUP = "replaceLookup";

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.refresh(mapping, form, request, response);
        QuestionLookupForm questionLookupForm = (QuestionLookupForm)form;
        String questions = "";
        if (questionLookupForm.getLookupResultsBOClassName() != null && questionLookupForm.getLookupResultsSequenceNumber() != null) {
            String lookupResultsSequenceNumber = questionLookupForm.getLookupResultsSequenceNumber();
            Class<?> lookupResultsBOClass = Class.forName(questionLookupForm.getLookupResultsBOClassName());
            Collection rawValues = KraServiceLocator.getService(LookupResultsService.class).retrieveSelectedResultBOs(lookupResultsSequenceNumber, lookupResultsBOClass, GlobalVariables.getUserSession().getPerson().getPrincipalId());
            int idx = 0;
            String idxString = StringUtils.substringBetween((String)questionLookupForm.getLookedUpCollectionName(), (String)"[", (String)"]");
            if (StringUtils.isNotBlank((String)idxString)) {
                idx = Integer.parseInt(idxString);
            }
            questionLookupForm.setSelectedQuestions("");
            for (Question question : rawValues) {
                String desc = question.getQuestion();
                if (desc.indexOf("\"") > 0) {
                    desc = desc.replace("\"", "&#034;");
                }
                questions = StringUtils.isBlank((String)questions) ? question.getQuestionRefId() + PFP + desc + PFP + question.getQuestionTypeId() + PFP + question.getSequenceNumber() : questions + PQP + question.getQuestionRefId() + PFP + desc + PFP + question.getQuestionTypeId() + PFP + question.getSequenceNumber();
                questions = questions + PFP + this.getQuestionResponse(question);
            }
            questionLookupForm.setLookupResultsSequenceNumber(null);
        }
        questionLookupForm.setSelectedQuestions(questions);
        forward = questionLookupForm.getNodeIndex() >= 0 ? mapping.findForward(SINGLE_LOOKUP) : (questionLookupForm.getNodeIndex() == -2 ? mapping.findForward(REPLACE_LOOKUP) : mapping.findForward(MULTI_LOOKUP));
        return forward;
    }

    private String getQuestionResponse(Question question) {
        String retString = "";
        if (question.getQuestionTypeId().equals(new Integer(6))) {
            String className = question.getLookupClass();
            className = className.substring(className.lastIndexOf(".") + 1);
            retString = className + PFP + question.getMaxAnswers() + PFP + question.getLookupReturn();
        } else {
            retString = question.getDisplayedAnswers() + PFP + question.getMaxAnswers() + PFP + question.getAnswerMaxLength();
        }
        return retString;
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.execute(mapping, form, request, response);
        String lookupType = request.getParameter("lookupType");
        if (StringUtils.isNotBlank((String)lookupType)) {
            if (lookupType.equals("single")) {
                forward = mapping.findForward(SINGLE_LOOKUP);
            } else if (lookupType.equals("multivalue")) {
                forward = mapping.findForward(MULTI_LOOKUP);
            } else if (lookupType.equals("replace")) {
                forward = mapping.findForward(REPLACE_LOOKUP);
            }
        }
        return forward;
    }
}

