/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.questionnaire;

import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.questionnaire.Questionnaire;
import org.kuali.kra.questionnaire.QuestionnaireQuestion;
import org.kuali.kra.questionnaire.QuestionnaireService;
import org.kuali.kra.questionnaire.QuestionnaireUsage;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class QuestionnaireMaintenanceDocumentRule
extends MaintenanceDocumentRuleBase {
    public static final String ALREADY_EDITED_ERROR = "error.questionnaire.alreadyEdited";

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.validateQuestionnaire(document);
    }

    protected boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        return this.validateQuestionnaire(document);
    }

    private boolean validateQuestionnaire(MaintenanceDocument maintenanceDocument) {
        boolean valid = true;
        Questionnaire newQuestionnaire = (Questionnaire)maintenanceDocument.getNewMaintainableObject().getDataObject();
        MessageMap errorMap = GlobalVariables.getMessageMap();
        if (StringUtils.isBlank((String)newQuestionnaire.getName())) {
            errorMap.putError("document.newMaintainableObject.businessObject.name", "error.required", new String[]{"Questionnaire Name"});
            valid = false;
        }
        if (StringUtils.isBlank((String)newQuestionnaire.getDescription())) {
            errorMap.putError("document.newMaintainableObject.businessObject.description", "error.required", new String[]{"Questionnaire Description"});
            valid = false;
        }
        if (this.getQuestionnaireService().isQuestionnaireNameExist(newQuestionnaire.getQuestionnaireId(), newQuestionnaire.getName())) {
            errorMap.putError("document.newMaintainableObject.businessObject.name", "error.questionnaire.name.exist", new String[0]);
            valid = false;
        }
        if (StringUtils.isNotBlank((String)newQuestionnaire.getFileName()) && !StringUtils.endsWithIgnoreCase((String)newQuestionnaire.getFileName(), (String)".xsl")) {
            errorMap.putError("document.newMaintainableObject.businessObject.fileName", "error.questionnaire.filename.invalid", new String[0]);
            valid = false;
        }
        for (QuestionnaireQuestion questionnaireQuestion : newQuestionnaire.getQuestionnaireQuestions()) {
            if (questionnaireQuestion.getQuestion() == null || !"I".equals(questionnaireQuestion.getQuestion().getStatus())) continue;
            errorMap.putError("document.newMaintainableObject.businessObject.question" + newQuestionnaire.getQuestionnaireQuestions().indexOf(questionnaireQuestion), "error.questionnaire.question_inactive", new String[]{questionnaireQuestion.getQuestion().getQuestion()});
            valid = false;
        }
        if (newQuestionnaire.getObjectId() != null && this.checkForLatestQuuestionnaireSequenceNumber(newQuestionnaire.getQuestionnaireId(), newQuestionnaire.getSequenceNumber())) {
            errorMap.putError("document.newMaintainableObject.businessObject.name", ALREADY_EDITED_ERROR, new String[]{""});
            valid = false;
        }
        for (QuestionnaireUsage usage : newQuestionnaire.getQuestionnaireUsages()) {
            if (usage.getCoeusSubModule() == null || !usage.getCoeusSubModule().isRequireUniqueQuestionnareUsage() || this.getQuestionnaireService().isUniqueUsage(newQuestionnaire, usage)) continue;
            errorMap.putError("document.newMaintainableObject.businessObject.questionnaireUsages[" + newQuestionnaire.getQuestionnaireUsages().indexOf(usage) + "].moduleSubItemCode", "error.questionnaire.duplicate.usage", new String[0]);
        }
        return valid;
    }

    protected boolean checkForLatestQuuestionnaireSequenceNumber(String questionnnaireId, Integer sequenceNumber) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("QUESTIONNAIRE_ID", questionnnaireId);
        boolean sortAscending = true;
        Collection questionnaires = this.getBusinessObjectService().findMatchingOrderBy(Questionnaire.class, fieldValues, "SEQUENCE_NUMBER", sortAscending);
        boolean foundCurrentSequence = false;
        boolean foundLargerSequence = false;
        for (Questionnaire questionnarire : questionnaires) {
            if (questionnarire.getSequenceNumber().equals(sequenceNumber)) {
                foundCurrentSequence = true;
            }
            if (questionnarire.getSequenceNumber() <= sequenceNumber) continue;
            foundLargerSequence = true;
        }
        return foundCurrentSequence && !foundLargerSequence;
    }

    private QuestionnaireService getQuestionnaireService() {
        return KraServiceLocator.getService(QuestionnaireService.class);
    }

    private BusinessObjectService getBusinessObjectService() {
        return KraServiceLocator.getService(BusinessObjectService.class);
    }
}

