/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.questionnaire;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.infrastructure.AwardPermissionConstants;
import org.kuali.kra.questionnaire.Questionnaire;
import org.kuali.kra.questionnaire.QuestionnaireQuestion;
import org.kuali.kra.questionnaire.QuestionnaireService;
import org.kuali.kra.questionnaire.QuestionnaireUsage;
import org.kuali.kra.service.UnitAuthorizationService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class QuestionnaireServiceImpl
implements QuestionnaireService {
    private static final String PARAM_NAME = "associateModuleQuestionnairePermission";
    private BusinessObjectService businessObjectService;
    private UnitAuthorizationService unitAuthorizationService;
    private ParameterService parameterService;
    private Map<String, String> permissionModuleMap = new HashMap<String, String>();

    public QuestionnaireServiceImpl() {
        this.permissionModuleMap.put(AwardPermissionConstants.MODIFY_AWARD.getAwardPermission() + ":" + "KC-AB", "1");
        this.permissionModuleMap.put("Edit Institutional Proposal:KC-IP", "2");
        this.permissionModuleMap.put("Maintain Questionnaire Usage:KC-PD", "3");
        this.permissionModuleMap.put("Modify Protocol:KC-PROTOCOL", "7");
        this.permissionModuleMap.put("Maintain Questionnaire Usage:KC-PROTOCOL", "7");
        this.permissionModuleMap.put("Maintain Questionnaire Usage:KC-COIDISCLOSURE", "8");
        this.permissionModuleMap.put("Maintain Questionnaire Usage:KC-IACUC", "9");
    }

    @Override
    public boolean isQuestionnaireNameExist(String questionnaireId, String name) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("name", name);
        boolean isExist = false;
        List questionnaires = (List)this.businessObjectService.findMatching(Questionnaire.class, fieldValues);
        for (Questionnaire questionnaire : questionnaires) {
            if (questionnaireId != null && questionnaire.getQuestionnaireId().equals(questionnaireId)) continue;
            isExist = true;
            break;
        }
        return isExist;
    }

    @Override
    public void copyQuestionnaire(Questionnaire src, Questionnaire dest) {
        this.copyQuestionnaireLists(src, dest);
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected void copyQuestionnaireLists(Questionnaire src, Questionnaire dest) {
        dest.setQuestionnaireQuestions(src.getQuestionnaireQuestions());
        dest.setQuestionnaireUsages(src.getQuestionnaireUsages());
        dest.setQuestionnaireId(null);
        for (QuestionnaireQuestion question : dest.getQuestionnaireQuestions()) {
            question.setQuestionnaireRefIdFk(null);
            question.setQuestionnaireQuestionsId(null);
            question.setVersionNumber(new Long(1L));
        }
        for (QuestionnaireUsage usage : dest.getQuestionnaireUsages()) {
            usage.setQuestionnaireRefIdFk(null);
            usage.setQuestionnaireUsageId(null);
            usage.setVersionNumber(new Long(1L));
        }
    }

    @Override
    public List<String> getAssociateModules() {
        HashSet<String> modules = new HashSet<String>();
        Collection parameters = this.parameterService.getParameterValuesAsString("KC-QUESTIONNAIRE", "P", PARAM_NAME);
        for (String permission : parameters) {
            String[] params = permission.split(":");
            boolean unitAuthCheck = this.unitAuthorizationService.hasPermission(GlobalVariables.getUserSession().getPerson().getPrincipalId(), params[1], params[0]);
            if (!unitAuthCheck || modules.contains(this.permissionModuleMap.get(permission))) continue;
            modules.add(this.permissionModuleMap.get(permission));
        }
        return new ArrayList<String>(modules);
    }

    public void setUnitAuthorizationService(UnitAuthorizationService unitAuthorizationService) {
        this.unitAuthorizationService = unitAuthorizationService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Override
    public boolean isUniqueUsage(Questionnaire questionnaire, QuestionnaireUsage usage) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("moduleItemCode", usage.getCoeusModule().getModuleCode());
        fieldValues.put("moduleSubItemCode", usage.getCoeusSubModule().getSubModuleCode());
        List usages = (List)this.businessObjectService.findMatching(QuestionnaireUsage.class, fieldValues);
        for (QuestionnaireUsage curUsage : usages) {
            if (StringUtils.equals((String)questionnaire.getQuestionnaireId(), (String)curUsage.getQuestionnaire().getQuestionnaireId()) || !curUsage.getQuestionnaire().isActive() || !this.isCurrentQuestionnaire(curUsage.getQuestionnaire())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isCurrentQuestionnaire(Questionnaire questionnaire) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("questionnaireId", questionnaire.getQuestionnaireId());
        List questionnaires = (List)this.businessObjectService.findMatchingOrderBy(Questionnaire.class, fieldValues, "sequenceNumber", false);
        return questionnaire.getQuestionnaireRefId().equals(((Questionnaire)questionnaires.get(0)).getQuestionnaireRefId());
    }
}

