/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.questionnaire.answer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.questionnaire.answer.Answer;

public class AnswerComparator
implements Comparator<Answer> {
    private static final Log LOG = LogFactory.getLog(AnswerComparator.class);

    @Override
    public int compare(Answer ans1, Answer argAnswer) {
        int retVal = 0;
        if (ObjectUtils.equals((Object)ans1.getQuestionNumber(), (Object)argAnswer.getQuestionNumber())) {
            retVal = ans1.getAnswerNumber().compareTo(argAnswer.getAnswerNumber());
        } else if (ObjectUtils.equals((Object)ans1.getQuestionnaireQuestion().getParentQuestionNumber(), (Object)argAnswer.getQuestionnaireQuestion().getParentQuestionNumber())) {
            retVal = ans1.getQuestionnaireQuestion().getQuestionSeqNumber().compareTo(argAnswer.getQuestionnaireQuestion().getQuestionSeqNumber());
        } else if (ObjectUtils.equals((Object)ans1.getQuestionnaireQuestion().getParentQuestionNumber(), (Object)argAnswer.getQuestionNumber())) {
            retVal = 1;
        } else if (ObjectUtils.equals((Object)ans1.getQuestionNumber(), (Object)argAnswer.getQuestionnaireQuestion().getParentQuestionNumber())) {
            retVal = -1;
        } else if (ans1.getQuestionnaireQuestion().getParentQuestionNumber() == 0 && argAnswer.getQuestionnaireQuestion().getParentQuestionNumber() != 0) {
            retVal = ans1.getQuestionnaireQuestion().getQuestionSeqNumber().compareTo(this.getRootAnswer(argAnswer).getQuestionnaireQuestion().getQuestionSeqNumber());
            if (retVal == 0) {
                retVal = -1;
            }
        } else if (ans1.getQuestionnaireQuestion().getParentQuestionNumber() != 0 && argAnswer.getQuestionnaireQuestion().getParentQuestionNumber() == 0) {
            retVal = this.getRootAnswer(ans1).getQuestionnaireQuestion().getQuestionSeqNumber().compareTo(argAnswer.getQuestionnaireQuestion().getQuestionSeqNumber());
            if (retVal == 0) {
                retVal = 1;
            }
        } else if (ans1.getQuestionnaireQuestion().getParentQuestionNumber() != 0 && argAnswer.getQuestionnaireQuestion().getParentQuestionNumber() != 0) {
            retVal = ObjectUtils.equals((Object)this.getRootAnswer(ans1).getQuestionNumber(), (Object)this.getRootAnswer(argAnswer).getQuestionNumber()) ? this.compareAtSameDepth(ans1, argAnswer) : this.getRootAnswer(ans1).getQuestionnaireQuestion().getQuestionSeqNumber().compareTo(this.getRootAnswer(argAnswer).getQuestionnaireQuestion().getQuestionSeqNumber());
        } else {
            LOG.info((Object)("no comparison matched " + ans1.getQuestionnaireQuestionsIdFk() + "-" + argAnswer.getQuestionnaireQuestionsIdFk()));
            retVal = 0;
        }
        return retVal;
    }

    private Answer getRootAnswer(Answer argAnswer) {
        Answer thisAnswer = argAnswer;
        while (thisAnswer.getQuestionnaireQuestion().getParentQuestionNumber() > 0) {
            thisAnswer = thisAnswer.getParentAnswer().get(0);
        }
        return thisAnswer;
    }

    private int compareAtSameDepth(Answer thisAnswer, Answer argAnswer) {
        int retVal = 0;
        List<Answer> ancestors1 = this.getAncestors(thisAnswer);
        List<Answer> ancestors2 = this.getAncestors(argAnswer);
        if (ancestors1.size() <= ancestors2.size()) {
            retVal = -1;
            for (int i = 0; i < ancestors1.size(); ++i) {
                if (ObjectUtils.equals((Object)ancestors1.get(i).getQuestionNumber(), (Object)ancestors2.get(i).getQuestionNumber())) continue;
                retVal = ancestors1.get(i).getQuestionnaireQuestion().getQuestionSeqNumber().compareTo(ancestors2.get(i).getQuestionnaireQuestion().getQuestionSeqNumber());
                break;
            }
        } else {
            for (int i = 0; i < ancestors2.size(); ++i) {
                retVal = 1;
                if (ObjectUtils.equals((Object)ancestors2.get(i).getQuestionNumber(), (Object)ancestors1.get(i).getQuestionNumber())) continue;
                retVal = ancestors1.get(i).getQuestionnaireQuestion().getQuestionSeqNumber().compareTo(ancestors2.get(i).getQuestionnaireQuestion().getQuestionSeqNumber());
                break;
            }
        }
        return retVal;
    }

    private List<Answer> getAncestors(Answer argAnswer) {
        ArrayList<Answer> answers = new ArrayList<Answer>();
        answers.add(argAnswer);
        Answer thisAnswer = argAnswer;
        while (thisAnswer.getQuestionnaireQuestion().getParentQuestionNumber() > 0) {
            thisAnswer = thisAnswer.getParentAnswer().get(0);
            answers.add(thisAnswer);
        }
        Collections.reverse(answers);
        return answers;
    }
}

