/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.questionnaire.print;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.printing.Printable;
import org.kuali.kra.printing.PrintingException;
import org.kuali.kra.printing.service.PrintingService;
import org.kuali.kra.proposaldevelopment.bo.AttachmentDataSource;
import org.kuali.kra.protocol.actions.print.QuestionnairePrintOption;
import org.kuali.kra.questionnaire.Questionnaire;
import org.kuali.kra.questionnaire.print.QuestionnairePrint;
import org.kuali.kra.questionnaire.print.QuestionnairePrintingService;
import org.kuali.rice.krad.service.BusinessObjectService;

public class QuestionnairePrintingServiceImpl
implements QuestionnairePrintingService {
    private static final String PROTOCOL_NUMBER = "protocolNumber";
    private static final String SUBMISSION_NUMBER = "submissionNumber";
    private PrintingService printingService;
    private QuestionnairePrint questionnairePrint;
    private BusinessObjectService businessObjectService;

    @Override
    public AttachmentDataSource printQuestionnaire(KraPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) throws PrintingException {
        AttachmentDataSource source = null;
        QuestionnairePrint printable = this.getQuestionnairePrint();
        if (printable != null) {
            printable.setPrintableBusinessObject(printableBusinessObject);
            printable.setReportParameters(reportParameters);
            source = this.getPrintingService().print(printable);
            source.setFileName("Questionnaire-" + reportParameters.get("documentNumber") + ".pdf");
            source.setContentType("application/pdf");
        }
        return source;
    }

    @Override
    public AttachmentDataSource printQuestionnaireAnswer(KraPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) throws PrintingException {
        AttachmentDataSource source = null;
        QuestionnairePrint printable = this.getQuestionnairePrint();
        if (printable != null) {
            printable.setPrintableBusinessObject(printableBusinessObject);
            printable.setReportParameters(reportParameters);
            source = this.getPrintingService().print(printable);
            source.setFileName("QuestionnaireAnswer" + reportParameters.get("questionnaireId") + ".pdf");
            source.setContentType("application/pdf");
        }
        return source;
    }

    private Questionnaire getQuestionnaire(Long questionnaireRefId) {
        HashMap<String, Long> pkMap = new HashMap<String, Long>();
        pkMap.put("questionnaireRefId", questionnaireRefId);
        return (Questionnaire)this.businessObjectService.findByPrimaryKey(Questionnaire.class, pkMap);
    }

    @Override
    public List<Printable> getQuestionnairePrintable(KraPersistableBusinessObjectBase printableBusinessObject, List<QuestionnairePrintOption> questionnairesToPrints) {
        ArrayList<Printable> printables = new ArrayList<Printable>();
        for (QuestionnairePrintOption printOption : questionnairesToPrints) {
            if (!printOption.isSelected()) continue;
            QuestionnairePrint printable = new QuestionnairePrint();
            printable.setXmlStream(this.getQuestionnairePrint().getXmlStream());
            HashMap<String, Object> reportParameters = new HashMap<String, Object>();
            Questionnaire questionnaire = this.getQuestionnaire(printOption.getQuestionnaireRefId());
            reportParameters.put("questionnaireId", questionnaire.getQuestionnaireIdAsInteger());
            reportParameters.put("template", questionnaire.getTemplate());
            reportParameters.put("moduleSubItemCode", printOption.getSubItemCode());
            if ("2".equals(printOption.getSubItemCode())) {
                reportParameters.put(PROTOCOL_NUMBER, printOption.getItemKey());
                reportParameters.put(SUBMISSION_NUMBER, printOption.getSubItemKey());
            }
            if (printable == null) continue;
            printable.setPrintableBusinessObject(this.getProtocolPrintable(printOption));
            printable.setReportParameters(reportParameters);
            printables.add(printable);
        }
        return printables;
    }

    private Protocol getProtocolPrintable(QuestionnairePrintOption printOption) {
        if ("2".equals(printOption.getSubItemCode())) {
            HashMap<String, String> keyValues = new HashMap<String, String>();
            keyValues.put(PROTOCOL_NUMBER, printOption.getItemKey());
            keyValues.put(SUBMISSION_NUMBER, printOption.getSubItemKey());
            return (Protocol)((ProtocolSubmission)((List)this.businessObjectService.findMatchingOrderBy(ProtocolSubmission.class, keyValues, "submissionId", false)).get(0)).getProtocol();
        }
        HashMap<String, String> keyValues = new HashMap<String, String>();
        keyValues.put(PROTOCOL_NUMBER, printOption.getItemKey());
        keyValues.put("sequenceNumber", printOption.getSubItemKey());
        return (Protocol)((List)this.businessObjectService.findMatching(Protocol.class, keyValues)).get(0);
    }

    public PrintingService getPrintingService() {
        return this.printingService;
    }

    public void setPrintingService(PrintingService printingService) {
        this.printingService = printingService;
    }

    public QuestionnairePrint getQuestionnairePrint() {
        return this.questionnairePrint;
    }

    public void setQuestionnairePrint(QuestionnairePrint questionnairePrint) {
        this.questionnairePrint = questionnairePrint;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

