/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.questionnaire.question;

import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.questionnaire.question.Question;
import org.kuali.kra.questionnaire.question.QuestionService;
import org.kuali.kra.service.CustomAttributeService;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.Maintainable;
import org.kuali.rice.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.exception.ValidationException;
import org.kuali.rice.krad.util.GlobalVariables;

public class QuestionMaintenanceDocumentRule
extends MaintenanceDocumentRuleBase {
    private static final Log LOG = LogFactory.getLog(QuestionMaintenanceDocumentRule.class);

    protected boolean dataDictionaryValidate(MaintenanceDocument document) {
        LOG.debug((Object)"MaintenanceDocument validation beginning");
        GlobalVariables.getMessageMap().addToErrorPath("document.newMaintainableObject.businessObject");
        Maintainable newMaintainable = document.getNewMaintainableObject();
        if (newMaintainable == null) {
            GlobalVariables.getMessageMap().removeFromErrorPath("document.newMaintainableObject");
            throw new ValidationException("Maintainable object from Maintenance Document '" + document.getDocumentTitle() + "' is null, unable to proceed.");
        }
        PersistableBusinessObject businessObject = newMaintainable.getBusinessObject();
        if (businessObject == null) {
            GlobalVariables.getMessageMap().removeFromErrorPath("document.newMaintainableObject.");
            throw new ValidationException("Maintainable's component business object is null.");
        }
        this.maintDocDictionaryService.validateMaintenanceRequiredFields(document);
        this.maintDocDictionaryService.validateMaintainableCollectionsForDuplicateEntries(document);
        this.dictionaryValidationService.validateBusinessObject((BusinessObject)businessObject, false);
        this.dictionaryValidationService.validateDefaultExistenceChecks((BusinessObject)businessObject);
        GlobalVariables.getMessageMap().removeFromErrorPath("document.newMaintainableObject.businessObject");
        LOG.debug((Object)"MaintenanceDocument validation ending");
        return true;
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument maintenanceDocument) {
        boolean isValid = true;
        isValid &= this.validateQuestionUsage(maintenanceDocument);
        return isValid &= this.validateQuestionResponseType(maintenanceDocument);
    }

    private boolean validateQuestionUsage(MaintenanceDocument maintenanceDocument) {
        Question question = (Question)maintenanceDocument.getNewMaintainableObject().getDataObject();
        if (!"A".equals(question.getStatus()) && this.getQuestionService().isQuestionUsed(question.getQuestionId())) {
            GlobalVariables.getMessageMap().putError("document.newMaintainableObject.businessObject.status", "error.question.status.in.use", new String[0]);
            return false;
        }
        return true;
    }

    private boolean validateQuestionResponseType(MaintenanceDocument maintenanceDocument) {
        boolean isValid = true;
        Question question = (Question)maintenanceDocument.getNewMaintainableObject().getDataObject();
        if (question.getQuestionTypeId() == null) {
            isValid &= false;
            GlobalVariables.getMessageMap().putError("document.newMaintainableObject.businessObject.questionTypeId", "error.question.response.type.not.specified", new String[0]);
        } else {
            switch (question.getQuestionTypeId()) {
                case 1: {
                    isValid &= this.validateResponseTypeYesNo(question);
                    break;
                }
                case 2: {
                    isValid &= this.validateResponseTypeYesNoNa(question);
                    break;
                }
                case 3: {
                    isValid &= this.validateResponseTypeNumber(question);
                    break;
                }
                case 4: {
                    isValid &= this.validateResponseTypeDate(question);
                    break;
                }
                case 5: {
                    isValid &= this.validateResponseTypeText(question);
                    break;
                }
                case 6: {
                    isValid &= this.validateResponseTypeLookup(question);
                    break;
                }
                default: {
                    isValid &= false;
                    GlobalVariables.getMessageMap().putError("document.newMaintainableObject.businessObject.questionTypeId", "error.question.response.type.invalid", new String[0]);
                }
            }
        }
        return isValid;
    }

    private boolean validateResponseTypeYesNo(Question question) {
        return true;
    }

    private boolean validateResponseTypeYesNoNa(Question question) {
        return true;
    }

    private boolean validateResponseTypeNumber(Question question) {
        boolean isValid = true;
        isValid &= this.validateDisplayedAnswers(question);
        isValid &= this.validateAnswerMaxLengthWithCeiling(question);
        return isValid &= this.validateMaxAnswers(question);
    }

    private boolean validateResponseTypeDate(Question question) {
        boolean isValid = true;
        isValid &= this.validateDisplayedAnswers(question);
        return isValid &= this.validateMaxAnswers(question);
    }

    private boolean validateResponseTypeText(Question question) {
        boolean isValid = true;
        isValid &= this.validateDisplayedAnswers(question);
        isValid &= this.validateAnswerMaxLengthWithCeiling(question);
        return isValid &= this.validateMaxAnswers(question);
    }

    private boolean validateResponseTypeLookup(Question question) {
        boolean isValid = true;
        isValid &= this.validateLookupClass(question);
        isValid &= this.validateLookupReturn(question);
        return isValid &= this.validateMaxAnswers(question);
    }

    private boolean validateDisplayedAnswers(Question question) {
        if (question.getDisplayedAnswers() != null && question.getDisplayedAnswers() > 0) {
            return true;
        }
        if (question.getQuestionTypeId() == 5) {
            GlobalVariables.getMessageMap().putError("document.newMaintainableObject.businessObject.displayedAnswers", "error.question.displayed.answers.invalid.areas", new String[0]);
        } else {
            GlobalVariables.getMessageMap().putError("document.newMaintainableObject.businessObject.displayedAnswers", "error.question.displayed.answers.invalid.boxes", new String[0]);
        }
        return false;
    }

    private boolean validateAnswerMaxLength(Question question) {
        if (question.getAnswerMaxLength() != null && question.getAnswerMaxLength() > 0) {
            return true;
        }
        GlobalVariables.getMessageMap().putError("document.newMaintainableObject.businessObject.answerMaxLength", "error.question.answer.max.length.invalid", new String[0]);
        return false;
    }

    public boolean validateAnswerMaxLengthWithCeiling(Question question) {
        if (this.validateAnswerMaxLength(question)) {
            if (question.getAnswerMaxLength() != null && question.getAnswerMaxLength() <= 2000) {
                return true;
            }
            GlobalVariables.getMessageMap().putError("document.newMaintainableObject.businessObject.answerMaxLength", "error.question.answer.max.length.value.too.large", new String[0]);
            return false;
        }
        return false;
    }

    private boolean validateMaxAnswers(Question question) {
        boolean isValid = true;
        if (question.getMaxAnswers() == null || question.getMaxAnswers() <= 0) {
            isValid = false;
        }
        if (question.getQuestionTypeId() != 6 && question.getMaxAnswers() != null && question.getDisplayedAnswers() != null && question.getMaxAnswers() > question.getDisplayedAnswers()) {
            isValid = false;
        }
        if (!isValid) {
            switch (question.getQuestionTypeId()) {
                case 6: {
                    GlobalVariables.getMessageMap().putError("document.newMaintainableObject.businessObject.maxAnswers", "error.question.max.answers.invalid.returns", new String[0]);
                    break;
                }
                case 5: {
                    GlobalVariables.getMessageMap().putError("document.newMaintainableObject.businessObject.maxAnswers", "error.question.max.answers.invalid.answers.areas", new String[0]);
                    break;
                }
                default: {
                    GlobalVariables.getMessageMap().putError("document.newMaintainableObject.businessObject.maxAnswers", "error.question.max.answers.invalid.answers.boxes", new String[0]);
                }
            }
        }
        return isValid;
    }

    private boolean validateLookupClass(Question question) {
        String prevLookupClass = (String)GlobalVariables.getUserSession().retrieveObject("lookupClassName");
        if (ObjectUtils.equals((Object)question.getLookupClass(), (Object)prevLookupClass)) {
            GlobalVariables.getUserSession().removeObject("lookupReturnFields");
        }
        if (question.getLookupClass() != null) {
            return true;
        }
        GlobalVariables.getMessageMap().putError("document.newMaintainableObject.businessObject.lookupClass", "error.question.lookup.class.not.specified", new String[0]);
        return false;
    }

    private boolean validateLookupReturn(Question question) {
        if (question.getLookupReturn() != null) {
            return this.validateLookupReturnBasedOnLookupClass(question);
        }
        GlobalVariables.getMessageMap().putError("document.newMaintainableObject.businessObject.lookupReturn", "error.question.lookup.return.not.specified", new String[0]);
        return false;
    }

    private boolean validateLookupReturnBasedOnLookupClass(Question question) {
        if (question.getLookupClass() != null) {
            try {
                List lookupReturnClasses = this.getCustomAttributeService().getLookupReturns(question.getLookupClass());
                for (String lookupReturnClass : lookupReturnClasses) {
                    if (!StringUtils.equals((String)lookupReturnClass, (String)question.getLookupReturn())) continue;
                    return true;
                }
                GlobalVariables.getMessageMap().putError("document.newMaintainableObject.businessObject.lookupReturn", "error.question.lookup.return.invalid", new String[0]);
                return false;
            }
            catch (Exception e) {
                LOG.info((Object)e.getMessage());
                throw new RuntimeException("QuestionMaintenanceDocumentRule encountered exception", e);
            }
        }
        return true;
    }

    private CustomAttributeService getCustomAttributeService() {
        return KraServiceLocator.getService(CustomAttributeService.class);
    }

    private QuestionService getQuestionService() {
        return KraServiceLocator.getService(QuestionService.class);
    }
}

