/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.reporting;

import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IParameterDefnBase;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IScalarParameterDefn;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.reporting.BirtInstance;
import org.kuali.kra.reporting.bo.BirtParameterBean;
import org.kuali.rice.core.framework.persistence.jdbc.datasource.XAPoolDataSource;

public class BirtHelper {
    private static IReportEngine engine;
    private static XAPoolDataSource xAPoolDataSource;
    private static OdaDataSourceHandle dataSourceHandle;
    private static final String DATA_SOURCE = "org.eclipse.birt.report.data.oda.jdbc";

    public BirtHelper() throws Exception {
        BirtInstance birtInstance = BirtInstance.getInstance();
        engine = birtInstance.getIReportEngine();
        xAPoolDataSource = BirtHelper.getXAPoolDataSource();
    }

    public ArrayList<BirtParameterBean> getParameters(InputStream reportStream) throws Exception {
        IReportRunnable design = null;
        ArrayList<BirtParameterBean> listParameters = new ArrayList<BirtParameterBean>();
        design = engine.openReportDesign(reportStream);
        IGetParameterDefinitionTask task = engine.createGetParameterDefinitionTask(design);
        Collection params = task.getParameterDefns(true);
        for (IParameterDefnBase param : params) {
            IScalarParameterDefn scalar = (IScalarParameterDefn)param;
            listParameters.add(this.loadParameterDetails(task, scalar, design));
        }
        return listParameters;
    }

    private BirtParameterBean loadParameterDetails(IGetParameterDefinitionTask task, IScalarParameterDefn scalar, IReportRunnable report) {
        BirtParameterBean birtParameterBean = new BirtParameterBean();
        birtParameterBean.setName(scalar.getName());
        birtParameterBean.setHelp(scalar.getHelpText());
        birtParameterBean.setFormat(scalar.getDisplayFormat());
        birtParameterBean.setDefaultValue(scalar.getDefaultValue());
        birtParameterBean.setHidden(scalar.isHidden());
        birtParameterBean.setRequired(scalar.isRequired());
        birtParameterBean.setPromptText(scalar.getPromptText());
        switch (scalar.getControlType()) {
            case 0: {
                birtParameterBean.setControlType(1);
                break;
            }
            default: {
                birtParameterBean.setControlType(1);
            }
        }
        switch (scalar.getDataType()) {
            case 1: {
                birtParameterBean.setDataType(4);
                break;
            }
            case 4: {
                birtParameterBean.setDataType(5);
                break;
            }
            default: {
                birtParameterBean.setDataType(4);
            }
        }
        return birtParameterBean;
    }

    public static IReportEngine getEngine() {
        return engine;
    }

    public static void setEngine(IReportEngine engine) {
        BirtHelper.engine = engine;
    }

    public static XAPoolDataSource getXAPoolDataSource() {
        if (xAPoolDataSource == null) {
            xAPoolDataSource = (XAPoolDataSource)KraServiceLocator.getService("dataSourceXAPool");
        }
        return xAPoolDataSource;
    }

    public static OdaDataSourceHandle getDataSourceHandle() throws SemanticException, SQLException {
        if (dataSourceHandle == null) {
            return BirtHelper.getNewDataSourceHandle();
        }
        return dataSourceHandle;
    }

    private static OdaDataSourceHandle getNewDataSourceHandle() throws SemanticException, SQLException {
        ElementFactory designFactory = new ElementFactory((Module)new ReportDesign());
        dataSourceHandle = designFactory.newOdaDataSource("Data Source", DATA_SOURCE);
        String odaDriverClassName = xAPoolDataSource.getDriverClassName();
        String odaURL = xAPoolDataSource.getUrl();
        String odaUser = xAPoolDataSource.getUsername();
        String odaPassword = xAPoolDataSource.getPassword();
        dataSourceHandle.setProperty("odaDriverClass", (Object)odaDriverClassName);
        dataSourceHandle.setProperty("odaURL", (Object)odaURL);
        dataSourceHandle.setProperty("odaUser", (Object)odaUser);
        dataSourceHandle.setProperty("odaPassword", (Object)odaPassword);
        return dataSourceHandle;
    }

    public static void setDataSourceHandle(OdaDataSourceHandle dataSourceHandle) {
        BirtHelper.dataSourceHandle = dataSourceHandle;
    }
}

