/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.reporting.authorization;

import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.UnitAuthorizationService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kns.document.authorization.MaintenanceDocumentAuthorizerBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;

public class CustReportRightDocumentAuthorizer
extends MaintenanceDocumentAuthorizerBase {
    private static final long serialVersionUID = 1L;
    public static final String PERMISSION_NAME = "MAINTAIN CUSTOM REPORTS";
    public static final String NAME_SPACE = "KC-UNT";
    private UnitAuthorizationService unitAuthorizationService;

    public boolean canCreate(Class boClass, Person user) {
        boolean retVal = super.canCreate(boClass, user);
        String userId = GlobalVariables.getUserSession().getPrincipalId();
        retVal = this.getUnitAuthorizationService().hasPermission(userId, NAME_SPACE, PERMISSION_NAME);
        return retVal;
    }

    public boolean canEdit(Document document, Person user) {
        boolean retVal = super.canEdit(document, user);
        String userId = GlobalVariables.getUserSession().getPrincipalId();
        retVal = this.getUnitAuthorizationService().hasPermission(userId, NAME_SPACE, PERMISSION_NAME);
        return retVal;
    }

    public boolean canMaintain(Object dataObject, Person user) {
        boolean retVal = super.canMaintain(dataObject, user);
        String userId = GlobalVariables.getUserSession().getPrincipalId();
        retVal = this.getUnitAuthorizationService().hasPermission(userId, NAME_SPACE, PERMISSION_NAME);
        return retVal;
    }

    public UnitAuthorizationService getUnitAuthorizationService() {
        if (this.unitAuthorizationService == null) {
            this.unitAuthorizationService = KraServiceLocator.getService(UnitAuthorizationService.class);
        }
        return this.unitAuthorizationService;
    }

    public void setUnitAuthorizationService(UnitAuthorizationService unitAuthorizationService) {
        this.unitAuthorizationService = unitAuthorizationService;
    }
}

