/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.reporting.service.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.reporting.BirtHelper;
import org.kuali.kra.reporting.bo.BirtParameterBean;
import org.kuali.kra.reporting.bo.CustReportDetails;
import org.kuali.kra.reporting.service.BirtReportService;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.kra.service.UnitAuthorizationService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class BirtReportServiceImpl
implements BirtReportService {
    private BusinessObjectService businessObjectService;
    private BirtHelper birtHelper;
    private KraAuthorizationService kraAuthorizationService;
    private UnitAuthorizationService unitAuthorizationService;
    public static final String PERMISSION_NAME = "RUN GLOBAL REPORTS";
    public static final String DATA_SOURCE = "org.eclipse.birt.report.data.oda.jdbc";

    @Override
    public ArrayList<BirtParameterBean> getInputParametersFromTemplateFile(String reportId) throws Exception {
        this.birtHelper = new BirtHelper();
        ArrayList<BirtParameterBean> parameterList = new ArrayList();
        InputStream reportDesignInputStream = this.getReportDesignFileStream(reportId);
        parameterList = this.birtHelper.getParameters(reportDesignInputStream);
        return parameterList;
    }

    @Override
    public InputStream getReportDesignFileStream(String reportId) {
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("reportId", reportId);
        CustReportDetails custReportDetails = (CustReportDetails)this.businessObjectService.findByPrimaryKey(CustReportDetails.class, primaryKeys);
        ByteArrayInputStream reportDesignInputStream = new ByteArrayInputStream(custReportDetails.getAttachmentContent());
        return reportDesignInputStream;
    }

    @Override
    public List<CustReportDetails> getReports() {
        String principalId = GlobalVariables.getUserSession().getPrincipalId();
        String departmentCode = GlobalVariables.getUserSession().getPerson().getPrimaryDepartmentCode();
        List custReportDetailsList = (List)KraServiceLocator.getService(BusinessObjectService.class).findAll(CustReportDetails.class);
        ArrayList<CustReportDetails> custReportDetails = new ArrayList<CustReportDetails>();
        for (CustReportDetails custReportDetail : custReportDetailsList) {
            boolean hasPermission;
            if (custReportDetail.getPermissionName() == null || !custReportDetail.getPermissionName().equalsIgnoreCase(PERMISSION_NAME) || !(hasPermission = this.getUnitAuthorizationService().hasPermission(principalId, departmentCode, "KC-UNT", custReportDetail.getPermissionName()))) continue;
            custReportDetails.add(custReportDetail);
        }
        return custReportDetails;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public KraAuthorizationService getKraAuthorizationService() {
        return KraServiceLocator.getService(KraAuthorizationService.class);
    }

    public void setKraAuthorizationService(KraAuthorizationService kraAuthorizationService) {
        this.kraAuthorizationService = kraAuthorizationService;
    }

    public UnitAuthorizationService getUnitAuthorizationService() {
        return KraServiceLocator.getService(UnitAuthorizationService.class);
    }

    public void setUnitAuthorizationService(UnitAuthorizationService unitAuthorizationService) {
        this.unitAuthorizationService = unitAuthorizationService;
    }
}

