/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.rules.SoftError;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.util.GlobalVariables;

public class ErrorReporter {
    private static final Log LOG = LogFactory.getLog(ErrorReporter.class);

    public void reportError(String propertyName, String errorKey, String ... errorParams) {
        GlobalVariables.getMessageMap().putError(propertyName, errorKey, errorParams);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("rule failure at " + ErrorReporter.getMethodPath(1, 2)));
        }
    }

    public void reportAuditError(AuditError error, String errorKey, String clusterLabel, String clusterCategory) {
        Map errorMap;
        AuditCluster cluster;
        if (error == null || StringUtils.isBlank((String)errorKey) || StringUtils.isBlank((String)clusterLabel) || StringUtils.isBlank((String)clusterCategory)) {
            throw new IllegalArgumentException("null argument error: " + error + " errorkey: " + errorKey + " clusterLabel: " + clusterLabel + " clusterCategory: " + clusterCategory);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("rule failure at " + ErrorReporter.getMethodPath(1, 2)));
        }
        if ((cluster = (AuditCluster)(errorMap = KNSGlobalVariables.getAuditErrorMap()).get(errorKey)) == null) {
            cluster = new AuditCluster(clusterLabel, new ArrayList(), clusterCategory);
            errorMap.put(errorKey, cluster);
        }
        List errors = cluster.getAuditErrorList();
        errors.add(error);
    }

    public void reportSoftError(String propertyName, String errorKey, String ... errorParams) {
        this.addSoftError(propertyName, errorKey, errorParams);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("rule failure at " + ErrorReporter.getMethodPath(1, 2)));
        }
    }

    public Map<String, Collection<SoftError>> getSoftErrors() {
        UserSession session = GlobalVariables.getUserSession();
        Object o = session.retrieveObject("SOFT_ERRORS_KEY");
        Map<String, Collection<SoftError>> softErrors = (Map<String, Collection<SoftError>>)o;
        if (softErrors == null) {
            softErrors = this.initializeSoftErrorMap();
        }
        return softErrors;
    }

    private void addSoftError(String propertyName, String errorKey, String[] errorParams) {
        Map<String, Collection<SoftError>> softMessageMap = this.getSoftErrors();
        Collection<SoftError> errorsForProperty = softMessageMap.get(propertyName);
        if (errorsForProperty == null) {
            errorsForProperty = new HashSet<SoftError>();
        }
        errorsForProperty.add(new SoftError(errorKey, errorParams));
        softMessageMap.put(propertyName, errorsForProperty);
    }

    private Map<String, Collection<SoftError>> initializeSoftErrorMap() {
        Map<String, Collection<SoftError>> softMessageMap = Collections.synchronizedMap(new HashMap<String, Collection<SoftError>>(){
            private static final long serialVersionUID = 709850431504932842L;

            @Override
            public Collection<SoftError> get(Object key) {
                return (Collection)super.remove(key);
            }
        });
        GlobalVariables.getUserSession().addObject("SOFT_ERRORS_KEY", softMessageMap);
        return softMessageMap;
    }

    public void reportWarning(String propertyName, String errorKey, String ... errorParams) {
        GlobalVariables.getMessageMap().putWarning(propertyName, errorKey, errorParams);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("rule warning at ", ErrorReporter.getMethodPath(1, 2)));
        }
    }

    public boolean propertyHasErrorReported(String propertyName) {
        boolean result = false;
        if (GlobalVariables.getMessageMap().getErrorMessagesForProperty(propertyName) != null) {
            result = GlobalVariables.getMessageMap().getErrorMessagesForProperty(propertyName).size() > 0;
        }
        return result;
    }

    public void removeErrors(String propertyName) {
        if (GlobalVariables.getMessageMap().getErrorMessagesForProperty(propertyName) != null) {
            GlobalVariables.getMessageMap().getErrorMessagesForProperty(propertyName).clear();
        }
    }

    public static String getMethodPath(int fromLevel, int toLevel) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        ++toLevel;
        if (++fromLevel <= 0) {
            throw new IllegalArgumentException("invalid fromLevel (" + fromLevel + " < 0)");
        }
        if (fromLevel > toLevel) {
            throw new IllegalArgumentException("invalid levels (fromLevel " + fromLevel + " > toLevel " + toLevel + ")");
        }
        if (toLevel >= stackTraceElements.length) {
            throw new IllegalArgumentException("invalid toLevel (" + toLevel + " >= " + stackTraceElements.length + ")");
        }
        StringBuffer result = new StringBuffer();
        int elementIndex = 0;
        for (StackTraceElement element : stackTraceElements) {
            if (elementIndex >= fromLevel && elementIndex >= toLevel) {
                if (result.length() > 0) {
                    result.append(" from ");
                }
                result.append(element.getClassName()).append(".");
                result.append(element.getMethodName()).append("(");
                result.append(element.getFileName()).append(":");
                result.append(element.getLineNumber()).append(")");
            }
            ++elementIndex;
        }
        return result.toString();
    }
}

