/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.rules;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.KcPersonExtendedAttributes;
import org.kuali.kra.bo.KcPersonExtendedAttributesMaintainableImpl;
import org.kuali.kra.rule.event.SaveCustomDataEvent;
import org.kuali.kra.rules.KraMaintenanceDocumentRuleBase;
import org.kuali.kra.rules.PersonCustomDataAuditRule;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.ApproveDocumentEvent;
import org.kuali.rice.krad.util.GlobalVariables;

public class KcPersonExtendedAttributesMaintenanceDocumentRule
extends KraMaintenanceDocumentRuleBase {
    private static final String PRINCIPAL_ID = "principalId";
    private static final String CUSTOM_DATA_ERROR_PREFIX = "document.newMaintainableObject.businessObject.personCustomDataList";
    private static final int FIELD_ERA_COMMONS_USERNAME_MIN_LENGTH = 6;

    public boolean processSaveDocument(Document document) {
        boolean rulePassed = true;
        rulePassed &= super.processSaveDocument(document);
        MaintenanceDocument maintenanceDocument = (MaintenanceDocument)document;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("new maintainable is: " + maintenanceDocument.getNewMaintainableObject().getClass()));
        }
        KcPersonExtendedAttributesMaintainableImpl maintainableImpl = (KcPersonExtendedAttributesMaintainableImpl)maintenanceDocument.getNewMaintainableObject();
        KcPersonExtendedAttributes kcPersonExtendedAttributes = (KcPersonExtendedAttributes)((Object)maintenanceDocument.getNewMaintainableObject().getDataObject());
        rulePassed &= this.checkExistence(kcPersonExtendedAttributes);
        rulePassed &= this.processRules(new SaveCustomDataEvent(CUSTOM_DATA_ERROR_PREFIX, document, kcPersonExtendedAttributes.getPersonCustomDataList(), maintainableImpl.getCustomDataHelper().getCustomAttributeDocuments()));
        return rulePassed &= this.checkEraCommonsUserName(kcPersonExtendedAttributes);
    }

    public boolean processRouteDocument(Document document) {
        boolean rulePassed = true;
        rulePassed &= super.processRouteDocument(document);
        MaintenanceDocument maintenanceDocument = (MaintenanceDocument)document;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("new maintainable is: " + maintenanceDocument.getNewMaintainableObject().getClass()));
        }
        KcPersonExtendedAttributes kcPersonExtendedAttributes = (KcPersonExtendedAttributes)((Object)maintenanceDocument.getNewMaintainableObject().getDataObject());
        return rulePassed &= new PersonCustomDataAuditRule().processRunAuditBusinessRules((Document)maintenanceDocument);
    }

    public boolean processApproveDocument(ApproveDocumentEvent approveEvent) {
        boolean rulePassed = true;
        rulePassed &= super.processApproveDocument(approveEvent);
        Document document = approveEvent.getDocument();
        MaintenanceDocument maintenanceDocument = (MaintenanceDocument)document;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("new maintainable is: " + maintenanceDocument.getNewMaintainableObject().getClass()));
        }
        KcPersonExtendedAttributes kcPersonExtendedAttributes = (KcPersonExtendedAttributes)((Object)maintenanceDocument.getNewMaintainableObject().getDataObject());
        return rulePassed &= new PersonCustomDataAuditRule().processRunAuditBusinessRules((Document)maintenanceDocument);
    }

    private boolean checkExistence(KcPersonExtendedAttributes kcPersonExtendedAttributes) {
        boolean valid = true;
        HashMap<String, String> pkMap = new HashMap<String, String>();
        pkMap.put(PRINCIPAL_ID, kcPersonExtendedAttributes.getPersonId());
        valid = this.checkExistenceFromTable(Person.class, pkMap, PRINCIPAL_ID, "KcPersonExtendedAttributes Id");
        return valid;
    }

    private boolean checkEraCommonsUserName(KcPersonExtendedAttributes kcPersonExtendedAttributes) {
        boolean valid = true;
        if (StringUtils.isNotBlank((String)kcPersonExtendedAttributes.getEraCommonUserName()) && kcPersonExtendedAttributes.getEraCommonUserName().length() < 6) {
            GlobalVariables.getMessageMap().putError("document.newMaintainableObject.eRACommonsUserName", "error.minLength", new String[]{"eRA Commons User Name", "6"});
            valid = false;
        }
        return valid;
    }

    @Override
    protected boolean checkExistenceFromTable(Class clazz, Map fieldValues, String errorField, String errorParam) {
        boolean success = true;
        String idString = (String)fieldValues.get(PRINCIPAL_ID);
        boolean bl = success = this.getPersonService().getPerson(idString) != null;
        if (!success) {
            GlobalVariables.getMessageMap().putError("document.newMaintainableObject." + errorField, "error.existence", new String[]{errorParam});
        }
        return success;
    }
}

