/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.rules;

import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.bo.OrganizationYnq;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.rules.ErrorReporter;
import org.kuali.kra.service.RolodexService;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.rules.MaintenanceDocumentRuleBase;

public class OrganizationMaintenanceDocumentRule
extends MaintenanceDocumentRuleBase {
    public boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.isDocumentValidForSave(document);
    }

    public boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        return this.isDocumentValidForSave(document);
    }

    public boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        return this.isDocumentValidForSave(document);
    }

    public boolean isDocumentValidForSave(MaintenanceDocument document) {
        boolean result = super.isDocumentValidForSave(document);
        result &= this.checkYNQ(document);
        return result &= this.checkRolodexEntries(document);
    }

    private boolean checkYNQ(MaintenanceDocument maintenanceDocument) {
        ErrorReporter errorReporter = new ErrorReporter();
        boolean valid = true;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("new maintainable is: " + maintenanceDocument.getNewMaintainableObject().getClass()));
        }
        Organization newOrganization = (Organization)((Object)maintenanceDocument.getNewMaintainableObject().getDataObject());
        int i = 0;
        for (OrganizationYnq organizationYnq : newOrganization.getOrganizationYnqs()) {
            organizationYnq.refreshReferenceObject("ynq");
            if (StringUtils.isBlank((String)organizationYnq.getAnswer())) {
                errorReporter.reportError(String.format("document.newMaintainableObject.organizationYnqs[%s].answer", i), "error.organization.questionYnq.answerRequired", organizationYnq.getYnq().getQuestionId());
                valid = false;
            }
            if (StringUtils.isNotBlank((String)organizationYnq.getAnswer()) && organizationYnq.getAnswer().equalsIgnoreCase(organizationYnq.getYnq().getExplanationRequiredFor()) && StringUtils.isBlank((String)organizationYnq.getExplanation())) {
                errorReporter.reportError(String.format("document.newMaintainableObject.organizationYnqs[%s].explanation", i), "error.organization.questionYnq.explanationRequired", organizationYnq.getYnq().getQuestionId());
                valid = false;
            }
            if (StringUtils.isNotBlank((String)organizationYnq.getAnswer()) && organizationYnq.getAnswer().equalsIgnoreCase(organizationYnq.getYnq().getDateRequiredFor()) && organizationYnq.getReviewDate() == null) {
                errorReporter.reportError(String.format("document.newMaintainableObject.organizationYnqs[%s].reviewDate", i), "error.organization.questionYnq.reviewDateRequired", organizationYnq.getYnq().getQuestionId());
                valid = false;
            }
            ++i;
        }
        return valid;
    }

    private boolean checkRolodexEntries(MaintenanceDocument maintenanceDocument) {
        boolean valid = true;
        ErrorReporter errorReporter = new ErrorReporter();
        Organization newOrganization = (Organization)((Object)maintenanceDocument.getNewMaintainableObject().getDataObject());
        RolodexService rolodexService = KraServiceLocator.getService(RolodexService.class);
        if (newOrganization.getOnrResidentRep() != null && rolodexService.getRolodex(newOrganization.getOnrResidentRep()) == null) {
            errorReporter.reportError(String.format("document.newMaintainableObject.onrResidentRep", new Object[0]), "error.organization.rolodexEntry.invalid", new String[0]);
            valid = false;
        }
        if (newOrganization.getContactAddressId() != null && rolodexService.getRolodex(newOrganization.getContactAddressId()) == null) {
            errorReporter.reportError(String.format("document.newMaintainableObject.contactAddressId", new Object[0]), "error.organization.rolodexEntry.invalid", new String[0]);
            valid = false;
        }
        if (newOrganization.getCognizantAuditor() != null && rolodexService.getRolodex(newOrganization.getCognizantAuditor()) == null) {
            errorReporter.reportError(String.format("document.newMaintainableObject.cognizantAuditor", new Object[0]), "error.organization.rolodexEntry.invalid", new String[0]);
            valid = false;
        }
        return valid;
    }
}

