/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.rules;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.CustomAttributeDocument;
import org.kuali.kra.bo.KcPersonExtendedAttributes;
import org.kuali.kra.bo.PersonCustomData;
import org.kuali.kra.rules.PersonCustomDataRuleBase;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;

public class PersonCustomDataAuditRule
extends PersonCustomDataRuleBase
implements DocumentAuditRule {
    private static final String CUSTOM_DATA_ERROR_PREFIX = "document.newMaintainableObject.businessObject.personCustomDataList";

    @Override
    public boolean processRunAuditBusinessRules(Document document) {
        boolean rulePassed = true;
        MaintenanceDocument maintenanceDocument = (MaintenanceDocument)document;
        KcPersonExtendedAttributes kcPersonExtendedAttributes = (KcPersonExtendedAttributes)((Object)maintenanceDocument.getNewMaintainableObject().getDataObject());
        Map<String, CustomAttributeDocument> customAttributeDocuments = this.getCustomAttributeDocuments();
        int i = 0;
        for (PersonCustomData personCustomData : kcPersonExtendedAttributes.getPersonCustomDataList()) {
            CustomAttributeDocument customAttributeDocument = customAttributeDocuments.get(String.valueOf(personCustomData.getCustomAttributeId()));
            String errorKey = "document.newMaintainableObject.businessObject.personCustomDataList[" + i++ + "]" + ".value";
            rulePassed &= this.validateRequired(personCustomData, customAttributeDocument, errorKey);
        }
        return rulePassed;
    }

    private boolean validateRequired(PersonCustomData personCustomData, CustomAttributeDocument customAttributeDocument, String errorKey) {
        boolean rulePassed = true;
        if (customAttributeDocument.isRequired() && StringUtils.isBlank((String)personCustomData.getValue())) {
            this.reportError(errorKey, "error.required", personCustomData.getCustomAttribute().getLabel());
            rulePassed = false;
        }
        return rulePassed;
    }
}

