/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.formmapping;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.s2s.formmapping.FormMappingInfo;
import org.kuali.kra.s2s.generator.S2SGeneratorNotFoundException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FormMappingLoader {
    private static Map<String, FormMappingInfo> bindings;
    private static Map<Integer, List<String>> sortedNameSpaces;
    private static final String BINDING_FILE_NAME = "/S2SFormBinding.xml";
    private static final String BINDING_FILE_NAME_V2 = "/org/kuali/kra/s2s/s2sform/S2SFormBinding-V2.xml";
    private static final String NAMESPACE = "namespace";
    private static final String MAIN_CLASS = "mainClass";
    private static final String STYLE_SHEET = "stylesheet";
    private static final String PKG_NAME = "pkgName";
    private static final String FORM_NAME = "formName";
    private static final String TAG_FORM = "Form";
    private static final String SORT_INDEX = "sortIndex";
    private static final int DEFAULT_SORT_INDEX = 1000;
    private static final Log LOG;

    public FormMappingInfo getFormInfo(String nameSpace) throws S2SGeneratorNotFoundException {
        this.getBindings();
        FormMappingInfo formMappingInfo = bindings.get(nameSpace);
        if (formMappingInfo != null) {
            return formMappingInfo;
        }
        throw new S2SGeneratorNotFoundException("Form not found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, FormMappingInfo> getBindings() {
        if (bindings != null) return bindings;
        Class<FormMappingLoader> clazz = FormMappingLoader.class;
        synchronized (FormMappingLoader.class) {
            bindings = new Hashtable<String, FormMappingInfo>();
            sortedNameSpaces = new TreeMap<Integer, List<String>>();
            this.loadBindings(BINDING_FILE_NAME);
            if (new FormMappingLoader().getClass().getResourceAsStream(BINDING_FILE_NAME_V2) == null) return bindings;
            this.loadBindings(BINDING_FILE_NAME_V2);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return bindings;
        }
    }

    private void loadBindings(String BindingFile) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document document = null;
        Integer defaultSortIndex = 1000;
        if (!sortedNameSpaces.containsKey(defaultSortIndex)) {
            sortedNameSpaces.put(defaultSortIndex, new ArrayList());
        }
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(new FormMappingLoader().getClass().getResourceAsStream(BindingFile));
        }
        catch (ParserConfigurationException e) {
            LOG.error((Object)"Exception Occured", (Throwable)e);
            return;
        }
        catch (SAXException e) {
            LOG.error((Object)"Exception Occured", (Throwable)e);
            return;
        }
        catch (IOException e) {
            LOG.error((Object)"Exception Occured", (Throwable)e);
            return;
        }
        NodeList formList = document.getElementsByTagName(TAG_FORM);
        for (int index = 0; index < formList.getLength(); ++index) {
            List<String> nameSpaceList;
            Element formNode = (Element)formList.item(index);
            FormMappingInfo formInfo = new FormMappingInfo();
            formInfo.setNameSpace(formNode.getAttribute(NAMESPACE).trim());
            formInfo.setFormName(formNode.getElementsByTagName(FORM_NAME).item(0).getTextContent().trim());
            formInfo.setMainClass(formNode.getElementsByTagName(MAIN_CLASS).item(0).getTextContent().trim());
            formInfo.setStyleSheet(formNode.getElementsByTagName(STYLE_SHEET).item(0).getTextContent().trim());
            formInfo.setPkgName(formNode.getElementsByTagName(PKG_NAME).item(0).getTextContent().trim());
            NodeList sortIndexNodesList = formNode.getElementsByTagName(SORT_INDEX);
            if (sortIndexNodesList.getLength() > 0) {
                formInfo.setSortIndex(Integer.valueOf(sortIndexNodesList.item(0).getTextContent().trim()));
                Integer sortedIndex = formInfo.getSortIndex();
                nameSpaceList = sortedNameSpaces.get(sortedIndex) != null ? sortedNameSpaces.get(sortedIndex) : new ArrayList<String>();
                nameSpaceList.add(formInfo.getNameSpace());
                sortedNameSpaces.put(sortedIndex, nameSpaceList);
            } else {
                formInfo.setSortIndex(1000);
                nameSpaceList = sortedNameSpaces.get(defaultSortIndex);
                nameSpaceList.add(formInfo.getNameSpace());
                sortedNameSpaces.put(defaultSortIndex, nameSpaceList);
            }
            bindings.put(formInfo.getNameSpace(), formInfo);
        }
    }

    public Map<Integer, List<String>> getSortedNameSpaces() {
        return sortedNameSpaces;
    }

    static {
        LOG = LogFactory.getLog(FormMappingLoader.class);
    }
}

