/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.core.BudgetCategoryMap;
import org.kuali.kra.budget.core.BudgetCategoryMapping;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItemCalculatedAmount;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.personnel.BudgetPersonnelCalculatedAmount;
import org.kuali.kra.budget.personnel.BudgetPersonnelDetails;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.s2s.generator.S2SBaseFormGenerator;
import org.kuali.kra.s2s.service.S2SBudgetCalculatorService;
import org.kuali.kra.s2s.service.S2SUtilService;

public abstract class ED524BudgetBaseGenerator
extends S2SBaseFormGenerator {
    protected S2SUtilService s2sUtilService;
    protected S2SBudgetCalculatorService s2sBudgetCalculatorService;
    protected static final String INDIRECT_COST_RATE_AGREEMENT_NONE = "NONE";
    protected static final String APPROVING_FEDERAL_AGENCY_OTHER = "Other";
    protected static final String APPROVING_FEDERAL_AGENCY_ED = "ED";
    protected static final String RATE_CLASS_TYPE_EMPLOYEE_BENEFITS = "E";
    protected static final String RATE_CLASS_TYPE_VACATION = "V";
    protected static final String RATE_CLASS_TYPE_OTHER = "O";
    protected static final String TARGET_CATEGORY_CODE_SUBCONTRACT = "04";
    protected static final String TARGET_CATEGORY_CODE_PURCHASED_EQUIPMENT = "42";
    protected static final String TARGET_CATEGORY_CODE_MATERIOALS_AND_SUPPLIES = "43";
    protected static final String TARGET_CATEGORY_CODE_TRAVEL = "73";
    protected static final String TARGET_CATEGORY_CODE_FOREIGN_TRAVEL = "74";
    protected static final String TARGET_CATEGORY_CODE_PARTICIPANT_STIPENDS = "75";
    protected static final String TARGET_CATEGORY_TYPE_CODE_PERSONNEL = "P";
    protected static final int RATE_TYPE_ADMINISTRATIVE_SALARIES = 2;
    protected static final int RATE_TYPE_SUPPORT_STAFF_SALARIES = 3;
    protected BudgetDecimal totalCost = BudgetDecimal.ZERO;
    protected BudgetDecimal totalDirectCost = BudgetDecimal.ZERO;
    protected BudgetDecimal totalIndirectCost = BudgetDecimal.ZERO;
    protected BudgetDecimal totalCostSharing = BudgetDecimal.ZERO;
    protected BudgetDecimal indirectCS = BudgetDecimal.ZERO;
    protected BudgetDecimal supplyCost = BudgetDecimal.ZERO;
    protected BudgetDecimal supplyCostCS = BudgetDecimal.ZERO;
    protected BudgetDecimal otherCost = BudgetDecimal.ZERO;
    protected BudgetDecimal otherCostCS = BudgetDecimal.ZERO;
    protected BudgetDecimal categoryCostFringe = BudgetDecimal.ZERO;
    protected BudgetDecimal categoryCostCSFringe = BudgetDecimal.ZERO;
    protected BudgetDecimal equipmentCost = BudgetDecimal.ZERO;
    protected BudgetDecimal equipmentCostCS = BudgetDecimal.ZERO;
    protected BudgetDecimal contractualCost = BudgetDecimal.ZERO;
    protected BudgetDecimal contractualCostCS = BudgetDecimal.ZERO;
    protected BudgetDecimal travelCost = BudgetDecimal.ZERO;
    protected BudgetDecimal travelCostCS = BudgetDecimal.ZERO;
    protected BudgetDecimal trainingCost = BudgetDecimal.ZERO;
    protected BudgetDecimal trainingCostCS = BudgetDecimal.ZERO;
    protected BudgetDecimal personnelCost = BudgetDecimal.ZERO;
    protected BudgetDecimal personnelCostCS = BudgetDecimal.ZERO;
    protected static final String DHHS_AGREEMENT = "DHHS_AGREEMENT";
    protected static final String DHHS_DEFAULT_VALUE = "0";
    protected static final String AGENCY_VALUE = "DHHS";
    protected static final String RESTIRCTED_QUESTION = " ";
    protected static final String DEFAULT_LEGAL_NAME = "NONE";
    List<BudgetCategoryMap> budgetCategoryMapListWithoutFilter;

    public ED524BudgetBaseGenerator() {
        this.s2sUtilService = KraServiceLocator.getService(S2SUtilService.class);
        this.s2sBudgetCalculatorService = KraServiceLocator.getService(S2SBudgetCalculatorService.class);
        this.budgetCategoryMapListWithoutFilter = this.s2sBudgetCalculatorService.getBudgetCategoryMapList(new ArrayList<String>(), new ArrayList<String>());
    }

    protected void getTotalCosts(BudgetPeriod budgetPeriod) {
        this.totalCost = budgetPeriod.getTotalCost();
        this.totalDirectCost = budgetPeriod.getTotalDirectCost();
        this.totalIndirectCost = budgetPeriod.getTotalIndirectCost();
        this.totalCostSharing = budgetPeriod.getCostSharingAmount();
        this.getTrainingCosts(budgetPeriod);
        this.totalDirectCost = (BudgetDecimal)this.totalDirectCost.subtract(this.trainingCost);
    }

    protected void getIndirectCosts(BudgetPeriod budgetPeriod) {
        this.indirectCS = BudgetDecimal.ZERO;
        for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
            for (BudgetLineItemCalculatedAmount budgetLineItemCalAmount : budgetLineItem.getBudgetLineItemCalculatedAmounts()) {
                budgetLineItemCalAmount.refreshNonUpdateableReferences();
                if (budgetLineItemCalAmount.getRateClass() == null || !RATE_CLASS_TYPE_OTHER.equals(budgetLineItemCalAmount.getRateClass().getRateClassType())) continue;
                this.indirectCS = (BudgetDecimal)this.indirectCS.add(budgetLineItemCalAmount.getCalculatedCostSharing());
            }
        }
    }

    protected void getSuppliesCosts(BudgetPeriod budgetPeriod) {
        this.supplyCost = BudgetDecimal.ZERO;
        this.supplyCostCS = BudgetDecimal.ZERO;
        for (BudgetCategoryMap categoryMap : this.budgetCategoryMapListWithoutFilter) {
            if (!TARGET_CATEGORY_CODE_MATERIOALS_AND_SUPPLIES.equals(categoryMap.getTargetCategoryCode())) continue;
            for (BudgetCategoryMapping categoryMappping : categoryMap.getBudgetCategoryMappings()) {
                for (BudgetLineItem lineItem : budgetPeriod.getBudgetLineItems()) {
                    if (!lineItem.getBudgetCategoryCode().equals(categoryMappping.getBudgetCategoryCode())) continue;
                    this.supplyCost = (BudgetDecimal)this.supplyCost.add(lineItem.getLineItemCost());
                    this.supplyCostCS = (BudgetDecimal)this.supplyCostCS.add(lineItem.getCostSharingAmount());
                }
            }
        }
    }

    protected void getOtherCosts(BudgetPeriod budgetPeriod) {
        this.categoryCostFringe = BudgetDecimal.ZERO;
        this.categoryCostCSFringe = BudgetDecimal.ZERO;
        this.otherCost = BudgetDecimal.ZERO;
        this.otherCostCS = BudgetDecimal.ZERO;
        for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
            for (BudgetPersonnelDetails budgetPersonnelDetails : budgetLineItem.getBudgetPersonnelDetailsList()) {
                for (BudgetPersonnelCalculatedAmount budgetPersonnelCalculatedAmount : budgetPersonnelDetails.getBudgetPersonnelCalculatedAmounts()) {
                    budgetPersonnelCalculatedAmount.refreshReferenceObject("rateClass");
                    if ((!budgetPersonnelCalculatedAmount.getRateClass().getRateClassType().equals(RATE_CLASS_TYPE_EMPLOYEE_BENEFITS) || Integer.parseInt(budgetPersonnelCalculatedAmount.getRateTypeCode()) == 3) && (!budgetPersonnelCalculatedAmount.getRateClass().getRateClassType().equals(RATE_CLASS_TYPE_VACATION) || Integer.parseInt(budgetPersonnelCalculatedAmount.getRateTypeCode()) == 2)) continue;
                    this.categoryCostFringe = (BudgetDecimal)this.categoryCostFringe.add(budgetPersonnelCalculatedAmount.getCalculatedCost());
                    this.categoryCostCSFringe = (BudgetDecimal)this.categoryCostCSFringe.add(budgetPersonnelCalculatedAmount.getCalculatedCostSharing());
                }
            }
        }
        ArrayList<String> filterTargetCategoryCodes = new ArrayList<String>();
        filterTargetCategoryCodes.add(TARGET_CATEGORY_CODE_SUBCONTRACT);
        filterTargetCategoryCodes.add(TARGET_CATEGORY_CODE_PURCHASED_EQUIPMENT);
        filterTargetCategoryCodes.add(TARGET_CATEGORY_CODE_MATERIOALS_AND_SUPPLIES);
        filterTargetCategoryCodes.add(TARGET_CATEGORY_CODE_TRAVEL);
        filterTargetCategoryCodes.add(TARGET_CATEGORY_CODE_FOREIGN_TRAVEL);
        filterTargetCategoryCodes.add(TARGET_CATEGORY_CODE_PARTICIPANT_STIPENDS);
        List<BudgetCategoryMap> budgetCategoryMapList = this.s2sBudgetCalculatorService.getBudgetCategoryMapList(filterTargetCategoryCodes, new ArrayList<String>());
        for (BudgetCategoryMap budgetCategoryMap : budgetCategoryMapList) {
            if (!budgetCategoryMap.getCategoryType().equals(RATE_CLASS_TYPE_OTHER)) continue;
            for (BudgetCategoryMapping categoryMapping : budgetCategoryMap.getBudgetCategoryMappings()) {
                for (BudgetLineItem lineItem : budgetPeriod.getBudgetLineItems()) {
                    if (!lineItem.getBudgetCategoryCode().equals(categoryMapping.getBudgetCategoryCode())) continue;
                    this.otherCost = (BudgetDecimal)this.otherCost.add(lineItem.getLineItemCost());
                    this.otherCostCS = (BudgetDecimal)this.otherCostCS.add(lineItem.getCostSharingAmount());
                }
            }
        }
        for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
            for (BudgetLineItemCalculatedAmount budgetLineItemCalAmount : budgetLineItem.getBudgetLineItemCalculatedAmounts()) {
                budgetLineItemCalAmount.refreshReferenceObject("rateClass");
                if (budgetLineItemCalAmount.getRateClass().getRateClassType().equals(RATE_CLASS_TYPE_OTHER)) continue;
                this.otherCost = (BudgetDecimal)this.otherCost.add(budgetLineItemCalAmount.getCalculatedCost());
                this.otherCostCS = (BudgetDecimal)this.otherCostCS.add(budgetLineItemCalAmount.getCalculatedCostSharing());
            }
        }
        this.otherCost = (BudgetDecimal)this.otherCost.subtract(this.categoryCostFringe);
        this.otherCostCS = (BudgetDecimal)this.otherCostCS.subtract(this.categoryCostCSFringe);
    }

    protected void getEquipmentCosts(BudgetPeriod budgetPeriod) {
        this.equipmentCost = BudgetDecimal.ZERO;
        this.equipmentCostCS = BudgetDecimal.ZERO;
        for (BudgetCategoryMap categoryMap : this.budgetCategoryMapListWithoutFilter) {
            if (!categoryMap.getTargetCategoryCode().equals(TARGET_CATEGORY_CODE_PURCHASED_EQUIPMENT)) continue;
            for (BudgetCategoryMapping categoryMappping : categoryMap.getBudgetCategoryMappings()) {
                for (BudgetLineItem lineItem : budgetPeriod.getBudgetLineItems()) {
                    if (!lineItem.getBudgetCategoryCode().equals(categoryMappping.getBudgetCategoryCode())) continue;
                    this.equipmentCost = (BudgetDecimal)this.equipmentCost.add(lineItem.getLineItemCost());
                    this.equipmentCostCS = (BudgetDecimal)this.equipmentCostCS.add(lineItem.getCostSharingAmount());
                }
            }
        }
    }

    protected void getContractualCosts(BudgetPeriod budgetPeriod) {
        this.contractualCost = BudgetDecimal.ZERO;
        this.contractualCostCS = BudgetDecimal.ZERO;
        for (BudgetCategoryMap categoryMap : this.budgetCategoryMapListWithoutFilter) {
            if (!categoryMap.getTargetCategoryCode().equals(TARGET_CATEGORY_CODE_SUBCONTRACT)) continue;
            for (BudgetCategoryMapping categoryMappping : categoryMap.getBudgetCategoryMappings()) {
                for (BudgetLineItem lineItem : budgetPeriod.getBudgetLineItems()) {
                    if (!lineItem.getBudgetCategoryCode().equals(categoryMappping.getBudgetCategoryCode())) continue;
                    this.contractualCost = (BudgetDecimal)this.contractualCost.add(lineItem.getLineItemCost());
                    this.contractualCostCS = (BudgetDecimal)this.contractualCostCS.add(lineItem.getCostSharingAmount());
                }
            }
        }
    }

    protected void getTravelCosts(BudgetPeriod budgetPeriod) {
        this.travelCost = BudgetDecimal.ZERO;
        this.travelCostCS = BudgetDecimal.ZERO;
        for (BudgetCategoryMap categoryMap : this.budgetCategoryMapListWithoutFilter) {
            if (!categoryMap.getTargetCategoryCode().equals(TARGET_CATEGORY_CODE_TRAVEL) && !categoryMap.getTargetCategoryCode().equals(TARGET_CATEGORY_CODE_FOREIGN_TRAVEL)) continue;
            for (BudgetCategoryMapping categoryMappping : categoryMap.getBudgetCategoryMappings()) {
                for (BudgetLineItem lineItem : budgetPeriod.getBudgetLineItems()) {
                    if (!lineItem.getBudgetCategoryCode().equals(categoryMappping.getBudgetCategoryCode())) continue;
                    this.travelCost = (BudgetDecimal)this.travelCost.add(lineItem.getLineItemCost());
                    this.travelCostCS = (BudgetDecimal)this.travelCostCS.add(lineItem.getCostSharingAmount());
                }
            }
        }
    }

    protected void getTrainingCosts(BudgetPeriod budgetPeriod) {
        this.trainingCost = BudgetDecimal.ZERO;
        this.trainingCostCS = BudgetDecimal.ZERO;
        for (BudgetCategoryMap categoryMap : this.budgetCategoryMapListWithoutFilter) {
            if (!categoryMap.getTargetCategoryCode().equals(TARGET_CATEGORY_CODE_PARTICIPANT_STIPENDS)) continue;
            for (BudgetCategoryMapping categoryMappping : categoryMap.getBudgetCategoryMappings()) {
                for (BudgetLineItem lineItem : budgetPeriod.getBudgetLineItems()) {
                    if (!lineItem.getBudgetCategoryCode().equals(categoryMappping.getBudgetCategoryCode())) continue;
                    this.trainingCost = (BudgetDecimal)this.trainingCost.add(lineItem.getLineItemCost());
                    this.trainingCostCS = (BudgetDecimal)this.trainingCostCS.add(lineItem.getCostSharingAmount());
                }
            }
        }
    }

    public void getPersonnelCosts(BudgetPeriod budgetPeriod) {
        this.personnelCost = BudgetDecimal.ZERO;
        this.personnelCostCS = BudgetDecimal.ZERO;
        for (BudgetCategoryMap categoryMap : this.budgetCategoryMapListWithoutFilter) {
            if (!categoryMap.getCategoryType().equals(TARGET_CATEGORY_TYPE_CODE_PERSONNEL)) continue;
            for (BudgetCategoryMapping categoryMappping : categoryMap.getBudgetCategoryMappings()) {
                for (BudgetLineItem lineItem : budgetPeriod.getBudgetLineItems()) {
                    if (!lineItem.getBudgetCategoryCode().equals(categoryMappping.getBudgetCategoryCode())) continue;
                    this.personnelCost = (BudgetDecimal)this.personnelCost.add(lineItem.getLineItemCost());
                    this.personnelCostCS = (BudgetDecimal)this.personnelCostCS.add(lineItem.getCostSharingAmount());
                }
            }
        }
    }

    protected String getAgencyName() {
        String agencyName = "";
        String dhhs = this.s2sUtilService.getParameterValue(DHHS_AGREEMENT);
        if (dhhs != null && dhhs.length() > 0) {
            agencyName = AGENCY_VALUE;
        }
        return agencyName;
    }
}

