/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.forms.edSF424SupplementV10.EDSF424SupplementDocument;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.globalLibraryV10.YesNoDataType;
import gov.grants.apply.system.globalLibraryV10.YesNoNotApplicableDataType;
import java.util.ArrayList;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.common.specialreview.bo.SpecialReviewExemption;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.bo.ProposalYnq;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.specialreview.ProposalSpecialReview;
import org.kuali.kra.s2s.generator.impl.EDSF424SupplementBaseGenerator;

public class EDSF424SupplementV1_0Generator
extends EDSF424SupplementBaseGenerator {
    private EDSF424SupplementDocument getEDSF424Supplement() {
        EDSF424SupplementDocument edsf424SupplementDocument = EDSF424SupplementDocument.Factory.newInstance();
        EDSF424SupplementDocument.EDSF424Supplement edsf424Supplement = EDSF424SupplementDocument.EDSF424Supplement.Factory.newInstance();
        edsf424Supplement.setFormVersion("1.0");
        ProposalPerson pi = this.s2sUtilService.getPrincipalInvestigator(this.pdDoc);
        edsf424Supplement.setProjectDirector(this.globLibV10Generator.getContactPersonDataType(pi));
        String answer = null;
        for (ProposalYnq proposalYnq : this.pdDoc.getDevelopmentProposal().getProposalYnqs()) {
            if (proposalYnq.getQuestionId() == null || !proposalYnq.getQuestionId().equals("133")) continue;
            if (proposalYnq.getAnswer() != null) {
                answer = proposalYnq.getAnswer();
            }
            if ("Y".equals(answer)) {
                edsf424Supplement.setIsNoviceApplicant(YesNoNotApplicableDataType.YES);
                continue;
            }
            if ("N".equals(answer)) {
                edsf424Supplement.setIsNoviceApplicant(YesNoNotApplicableDataType.NO);
                continue;
            }
            if (!"X".equals(answer)) continue;
            edsf424Supplement.setIsNoviceApplicant(YesNoNotApplicableDataType.NOT_APPLICABLE);
        }
        edsf424Supplement.setIsHumanResearch(YesNoDataType.NO);
        Organization organization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization();
        for (ProposalSpecialReview specialReview : this.pdDoc.getDevelopmentProposal().getPropSpecialReviews()) {
            if (specialReview.getSpecialReviewTypeCode() != null && specialReview.getSpecialReviewTypeCode().equals("1")) {
                edsf424Supplement.setIsHumanResearch(YesNoDataType.YES);
                if (specialReview.getApprovalTypeCode() != null && specialReview.getApprovalTypeCode().equals("4")) {
                    edsf424Supplement.setIsHumanResearchExempt(YesNoDataType.YES);
                    EDSF424SupplementDocument.EDSF424Supplement.ExemptionsNumber exemptionsNumber = EDSF424SupplementDocument.EDSF424Supplement.ExemptionsNumber.Factory.newInstance();
                    exemptionsNumber.setIsHumanResearchExempt(YesNoDataType.YES);
                    if (specialReview.getSpecialReviewExemptions() != null && specialReview.getSpecialReviewExemptions().size() > 0) {
                        ArrayList<String> exemptionTypeCodes = new ArrayList<String>();
                        for (SpecialReviewExemption exemption : specialReview.getSpecialReviewExemptions()) {
                            exemptionTypeCodes.add(exemption.getExemptionTypeCode());
                        }
                        exemptionsNumber.setStringValue(this.s2sUtilService.convertStringListToString(exemptionTypeCodes));
                    }
                    edsf424Supplement.setExemptionsNumber(exemptionsNumber);
                    break;
                }
                edsf424Supplement.setIsHumanResearchExempt(YesNoDataType.NO);
                if (organization == null) break;
                EDSF424SupplementDocument.EDSF424Supplement.AssuranceNumber assuranceNumber = EDSF424SupplementDocument.EDSF424Supplement.AssuranceNumber.Factory.newInstance();
                assuranceNumber.setIsHumanResearchExempt(YesNoDataType.NO);
                if (organization.getHumanSubAssurance() != null) {
                    assuranceNumber.setStringValue(organization.getHumanSubAssurance());
                }
                edsf424Supplement.setAssuranceNumber(assuranceNumber);
                break;
            }
            edsf424Supplement.setIsHumanResearch(YesNoDataType.NO);
        }
        AttachedFileDataType attachedFileDataType = null;
        for (Narrative narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeTypeCode() == null || Integer.parseInt(narrative.getNarrativeTypeCode()) != 54 || (attachedFileDataType = this.getAttachedFileType(narrative)) == null) continue;
            edsf424Supplement.setAttachment(attachedFileDataType);
            break;
        }
        edsf424SupplementDocument.setEDSF424Supplement(edsf424Supplement);
        return edsf424SupplementDocument;
    }

    @Override
    public XmlObject getFormObject(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getEDSF424Supplement();
    }

    public XmlObject getFormObject(XmlObject xmlObject) {
        EDSF424SupplementDocument edsf4SupplementDocument = EDSF424SupplementDocument.Factory.newInstance();
        EDSF424SupplementDocument.EDSF424Supplement edsf424Supplement = (EDSF424SupplementDocument.EDSF424Supplement)xmlObject;
        edsf4SupplementDocument.setEDSF424Supplement(edsf424Supplement);
        return edsf4SupplementDocument;
    }
}

