/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.forms.edSF424SupplementV11.EDSF424SupplementDocument;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import gov.grants.apply.system.globalLibraryV20.YesNoNotApplicableDataType;
import java.util.ArrayList;
import java.util.List;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.common.specialreview.bo.SpecialReviewExemption;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.specialreview.ProposalSpecialReview;
import org.kuali.kra.questionnaire.answer.Answer;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.s2s.generator.impl.EDSF424SupplementBaseGenerator;
import org.kuali.kra.s2s.service.S2SUtilService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;

public class EDSF424SupplementV1_1Generator
extends EDSF424SupplementBaseGenerator {
    public EDSF424SupplementV1_1Generator() {
        this.s2sUtilService = KraServiceLocator.getService(S2SUtilService.class);
    }

    private EDSF424SupplementDocument getEDSF424Supplement() {
        EDSF424SupplementDocument edsf424SupplementDocument = EDSF424SupplementDocument.Factory.newInstance();
        EDSF424SupplementDocument.EDSF424Supplement edsf424Supplement = EDSF424SupplementDocument.EDSF424Supplement.Factory.newInstance();
        edsf424Supplement.setFormVersion("1.1");
        ProposalPerson pi = this.s2sUtilService.getPrincipalInvestigator(this.pdDoc);
        edsf424Supplement.setProjectDirector(this.globLibV20Generator.getContactPersonDataType(pi));
        String answer = null;
        List<AnswerHeader> answerHeaders = this.getQuestionnaireAnswers(this.pdDoc.getDevelopmentProposal(), true);
        if (answerHeaders != null && !answerHeaders.isEmpty()) {
            for (AnswerHeader answerHeader : answerHeaders) {
                List<Answer> answerDetails = answerHeader.getAnswers();
                for (Answer answers : answerDetails) {
                    if (answers.getQuestion().getQuestionId() == null || !answers.getQuestion().getQuestionId().equals("133")) continue;
                    if (answers.getAnswer() != null) {
                        answer = answers.getAnswer();
                    }
                    if ("Y".equals(answer)) {
                        edsf424Supplement.setIsNoviceApplicant(YesNoNotApplicableDataType.Y_YES);
                        continue;
                    }
                    if ("N".equals(answer)) {
                        edsf424Supplement.setIsNoviceApplicant(YesNoNotApplicableDataType.N_NO);
                        continue;
                    }
                    if (!"X".equals(answer)) continue;
                    edsf424Supplement.setIsNoviceApplicant(YesNoNotApplicableDataType.NA_NOT_APPLICABLE);
                }
            }
        }
        edsf424Supplement.setIsHumanResearch(YesNoDataType.N_NO);
        Organization organization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization();
        for (ProposalSpecialReview specialReview : this.pdDoc.getDevelopmentProposal().getPropSpecialReviews()) {
            if (specialReview.getSpecialReviewTypeCode() != null && specialReview.getSpecialReviewTypeCode().equals("1")) {
                edsf424Supplement.setIsHumanResearch(YesNoDataType.Y_YES);
                if (specialReview.getApprovalTypeCode() != null && specialReview.getApprovalTypeCode().equals("4")) {
                    edsf424Supplement.setIsHumanResearchExempt(YesNoDataType.Y_YES);
                    EDSF424SupplementDocument.EDSF424Supplement.ExemptionsNumber exemptionsNumber = EDSF424SupplementDocument.EDSF424Supplement.ExemptionsNumber.Factory.newInstance();
                    exemptionsNumber.setIsHumanResearchExempt(YesNoDataType.Y_YES);
                    if (specialReview.getSpecialReviewExemptions() != null && specialReview.getSpecialReviewExemptions().size() > 0) {
                        ArrayList<String> exemptionTypeCodes = new ArrayList<String>();
                        for (SpecialReviewExemption exemption : specialReview.getSpecialReviewExemptions()) {
                            exemptionTypeCodes.add(exemption.getExemptionTypeCode());
                        }
                        exemptionsNumber.setStringValue(this.s2sUtilService.convertStringListToString(exemptionTypeCodes));
                    }
                    edsf424Supplement.setExemptionsNumber(exemptionsNumber);
                } else {
                    edsf424Supplement.setIsHumanResearchExempt(YesNoDataType.N_NO);
                    if (organization != null) {
                        EDSF424SupplementDocument.EDSF424Supplement.AssuranceNumber assuranceNumber = EDSF424SupplementDocument.EDSF424Supplement.AssuranceNumber.Factory.newInstance();
                        assuranceNumber.setIsHumanResearchExempt(YesNoDataType.N_NO);
                        if (organization.getHumanSubAssurance() != null) {
                            assuranceNumber.setStringValue(organization.getHumanSubAssurance());
                        }
                        edsf424Supplement.setAssuranceNumber(assuranceNumber);
                    }
                }
                Boolean paramValue = KraServiceLocator.getService(ParameterService.class).getParameterValueAsBoolean("KC-PROTOCOL", "Document", "irb.protocol.development.proposal.linking.enabled");
                if (!paramValue.booleanValue()) break;
                EDSF424SupplementDocument.EDSF424Supplement.ExemptionsNumber exemptionsNumber = EDSF424SupplementDocument.EDSF424Supplement.ExemptionsNumber.Factory.newInstance();
                if (specialReview.getSpecialReviewExemptions() != null && specialReview.getSpecialReviewExemptions().size() > 0) {
                    edsf424Supplement.setIsHumanResearchExempt(YesNoDataType.Y_YES);
                    exemptionsNumber.setIsHumanResearchExempt(YesNoDataType.Y_YES);
                    ArrayList<String> exemptionTypeCodes = new ArrayList<String>();
                    for (SpecialReviewExemption exemption : specialReview.getSpecialReviewExemptions()) {
                        exemptionTypeCodes.add(exemption.getExemptionTypeCode());
                    }
                    exemptionsNumber.setStringValue(this.s2sUtilService.convertStringListToString(exemptionTypeCodes));
                    edsf424Supplement.setExemptionsNumber(exemptionsNumber);
                    break;
                }
                edsf424Supplement.setIsHumanResearch(YesNoDataType.N_NO);
                if (organization == null) break;
                EDSF424SupplementDocument.EDSF424Supplement.AssuranceNumber assuranceNumber = EDSF424SupplementDocument.EDSF424Supplement.AssuranceNumber.Factory.newInstance();
                assuranceNumber.setIsHumanResearchExempt(YesNoDataType.N_NO);
                if (organization.getHumanSubAssurance() != null) {
                    assuranceNumber.setStringValue(organization.getHumanSubAssurance());
                }
                edsf424Supplement.setAssuranceNumber(assuranceNumber);
                break;
            }
            edsf424Supplement.setIsHumanResearch(YesNoDataType.N_NO);
        }
        AttachedFileDataType attachedFileDataType = null;
        for (Narrative narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeTypeCode() == null || Integer.parseInt(narrative.getNarrativeTypeCode()) != 54 || (attachedFileDataType = this.getAttachedFileType(narrative)) == null) continue;
            edsf424Supplement.setAttachment(attachedFileDataType);
            break;
        }
        edsf424SupplementDocument.setEDSF424Supplement(edsf424Supplement);
        return edsf424SupplementDocument;
    }

    @Override
    public XmlObject getFormObject(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getEDSF424Supplement();
    }

    public XmlObject getFormObject(XmlObject xmlObject) {
        EDSF424SupplementDocument edsf4SupplementDocument = EDSF424SupplementDocument.Factory.newInstance();
        EDSF424SupplementDocument.EDSF424Supplement edsf424Supplement = (EDSF424SupplementDocument.EDSF424Supplement)xmlObject;
        edsf4SupplementDocument.setEDSF424Supplement(edsf424Supplement);
        return edsf4SupplementDocument;
    }
}

