/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.system.globalLibraryV20.AddressDataType;
import gov.grants.apply.system.globalLibraryV20.ContactPersonDataType;
import gov.grants.apply.system.globalLibraryV20.HumanNameDataType;
import gov.grants.apply.system.universalCodesV20.CountryCodeDataType;
import gov.grants.apply.system.universalCodesV20.StateCodeDataType;
import org.apache.commons.lang.WordUtils;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.s2s.generator.bo.DepartmentalPerson;
import org.kuali.kra.s2s.generator.bo.KeyPersonInfo;
import org.kuali.kra.s2s.service.S2SUtilService;
import org.kuali.rice.location.api.country.Country;
import org.kuali.rice.location.api.state.State;

public class GlobalLibraryV2_0Generator {
    private S2SUtilService s2sUtilService = KraServiceLocator.getService(S2SUtilService.class);

    public CountryCodeDataType.Enum getCountryCodeDataType(String countryCode) {
        CountryCodeDataType.Enum countryCodeDataType = null;
        Country country = this.s2sUtilService.getCountryFromCode(countryCode);
        if (country != null) {
            StringBuilder countryDetail = new StringBuilder();
            countryDetail.append(country.getAlternateCode());
            countryDetail.append(": ");
            countryDetail.append(country.getName().toUpperCase());
            countryCodeDataType = CountryCodeDataType.Enum.forString((String)countryDetail.toString());
        }
        return countryCodeDataType;
    }

    public StateCodeDataType.Enum getStateCodeDataType(String countryAlternateCode, String stateName) {
        StateCodeDataType.Enum stateCodeDataType = null;
        State state = this.s2sUtilService.getStateFromName(countryAlternateCode, stateName);
        if (state != null) {
            StringBuilder stateDetail = new StringBuilder();
            stateDetail.append(state.getCode());
            stateDetail.append(": ");
            stateDetail.append(WordUtils.capitalizeFully((String)state.getName()));
            stateCodeDataType = StateCodeDataType.Enum.forString((String)stateDetail.toString());
        }
        return stateCodeDataType;
    }

    public AddressDataType getAddressDataType(Rolodex rolodex) {
        AddressDataType addressDataType = AddressDataType.Factory.newInstance();
        if (rolodex != null) {
            String postalCode;
            String street1 = rolodex.getAddressLine1();
            addressDataType.setStreet1(street1);
            String street2 = rolodex.getAddressLine2();
            if (street2 != null && !street2.equals("")) {
                addressDataType.setStreet2(street2);
            }
            String city = rolodex.getCity();
            addressDataType.setCity(city);
            String county = rolodex.getCounty();
            if (county != null && !county.equals("")) {
                addressDataType.setCounty(county);
            }
            if ((postalCode = rolodex.getPostalCode()) != null && !postalCode.equals("")) {
                addressDataType.setZipPostalCode(postalCode);
            }
            String country = rolodex.getCountryCode();
            CountryCodeDataType.Enum countryCodeDataType = this.getCountryCodeDataType(country);
            addressDataType.setCountry(countryCodeDataType);
            String state = rolodex.getState();
            if (state != null && !state.equals("") && countryCodeDataType != null) {
                if (countryCodeDataType.equals(CountryCodeDataType.USA_UNITED_STATES)) {
                    addressDataType.setState(this.getStateCodeDataType(country, state));
                } else {
                    addressDataType.setProvince(state);
                }
            }
        }
        return addressDataType;
    }

    public AddressDataType getAddressDataType(DepartmentalPerson depPerson) {
        AddressDataType addressDataType = AddressDataType.Factory.newInstance();
        if (depPerson != null) {
            String postalCode;
            String street1 = depPerson.getAddress1();
            addressDataType.setStreet1(street1);
            String street2 = depPerson.getAddress2();
            if (street2 != null && !street2.equals("")) {
                addressDataType.setStreet2(street2);
            }
            String city = depPerson.getCity();
            addressDataType.setCity(city);
            String county = depPerson.getCounty();
            if (county != null && !county.equals("")) {
                addressDataType.setCounty(county);
            }
            if ((postalCode = depPerson.getPostalCode()) != null && !postalCode.equals("")) {
                addressDataType.setZipPostalCode(postalCode);
            }
            String country = depPerson.getCountryCode();
            CountryCodeDataType.Enum countryCodeDataType = this.getCountryCodeDataType(country);
            addressDataType.setCountry(countryCodeDataType);
            String state = depPerson.getState();
            if (state != null && !state.equals("") && countryCodeDataType != null) {
                if (countryCodeDataType.equals(CountryCodeDataType.USA_UNITED_STATES)) {
                    addressDataType.setState(this.getStateCodeDataType(country, state));
                } else {
                    addressDataType.setProvince(state);
                }
            }
        }
        return addressDataType;
    }

    public AddressDataType getAddressDataType(KcPerson person) {
        AddressDataType addressType = AddressDataType.Factory.newInstance();
        if (person != null) {
            String postalCode;
            String street1 = person.getAddressLine1();
            addressType.setStreet1(street1);
            String street2 = person.getAddressLine2();
            if (street2 != null && !street2.equals("")) {
                addressType.setStreet2(street2);
            }
            String city = person.getCity();
            addressType.setCity(city);
            String county = person.getCounty();
            if (county != null && !county.equals("")) {
                addressType.setCounty(county);
            }
            String country = person.getCountryCode();
            String state = person.getState();
            if (state != null && !state.equals("")) {
                addressType.setState(this.getStateCodeDataType(country, state));
            }
            if ((postalCode = person.getPostalCode()) != null && !postalCode.equals("")) {
                addressType.setZipPostalCode(postalCode);
            }
            addressType.setCountry(this.getCountryCodeDataType(country));
        }
        return addressType;
    }

    public AddressDataType getAddressDataType(ProposalPerson person) {
        AddressDataType addressType = AddressDataType.Factory.newInstance();
        if (person != null) {
            String county;
            String street1 = person.getAddressLine1();
            addressType.setStreet1(street1);
            String street2 = person.getAddressLine2();
            if (street2 != null && !street2.equals("")) {
                addressType.setStreet2(street2);
            }
            String city = person.getCity();
            addressType.setCity(city);
            String postalCode = person.getPostalCode();
            if (postalCode != null && !postalCode.equals("")) {
                addressType.setZipPostalCode(postalCode);
            }
            if (person.getCounty() != null) {
                addressType.setCounty(person.getCounty());
            }
            if ((county = person.getCounty()) != null && !county.equals("")) {
                addressType.setCounty(county);
            }
            String country = person.getCountryCode();
            CountryCodeDataType.Enum countryCodeDataType = this.getCountryCodeDataType(country);
            addressType.setCountry(countryCodeDataType);
            String state = person.getState();
            if (state != null && !state.equals("") && countryCodeDataType != null) {
                if (countryCodeDataType.equals(CountryCodeDataType.USA_UNITED_STATES)) {
                    addressType.setState(this.getStateCodeDataType(country, state));
                } else {
                    addressType.setProvince(person.getState());
                }
            }
        }
        return addressType;
    }

    public HumanNameDataType getHumanNameDataType(ProposalPerson person) {
        HumanNameDataType humanName = HumanNameDataType.Factory.newInstance();
        if (person != null) {
            humanName.setFirstName(person.getFirstName());
            humanName.setLastName(person.getLastName());
            String middleName = person.getMiddleName();
            if (middleName != null && !middleName.equals("")) {
                humanName.setMiddleName(middleName);
            }
        }
        return humanName;
    }

    public HumanNameDataType getHumanNameDataType(DepartmentalPerson person) {
        HumanNameDataType humanName = HumanNameDataType.Factory.newInstance();
        if (person != null) {
            humanName.setFirstName(person.getFirstName());
            humanName.setLastName(person.getLastName());
            String middleName = person.getMiddleName();
            if (middleName != null && !middleName.equals("")) {
                humanName.setMiddleName(middleName);
            }
        }
        return humanName;
    }

    public HumanNameDataType getHumanNameDataType(String explanation) {
        HumanNameDataType humanNameDataType = HumanNameDataType.Factory.newInstance();
        String firstName = null;
        String lastName = null;
        String formerName = explanation;
        if (formerName != null) {
            int commaPos = formerName.indexOf(",");
            if (commaPos > 0) {
                lastName = formerName.substring(0, commaPos);
                firstName = formerName.substring(commaPos + 1);
            } else {
                lastName = formerName;
            }
        }
        humanNameDataType.setLastName(lastName);
        humanNameDataType.setFirstName(firstName);
        return humanNameDataType;
    }

    public HumanNameDataType getHumanNameDataType(Rolodex rolodex) {
        HumanNameDataType humanName = HumanNameDataType.Factory.newInstance();
        if (rolodex != null) {
            humanName.setFirstName(rolodex.getFirstName());
            humanName.setLastName(rolodex.getLastName());
            String middleName = rolodex.getMiddleName();
            if (middleName != null && !middleName.equals("")) {
                humanName.setMiddleName(middleName);
            }
        }
        return humanName;
    }

    public HumanNameDataType getHumanNameDataType(KcPerson person) {
        HumanNameDataType humanName = HumanNameDataType.Factory.newInstance();
        if (person != null) {
            humanName.setFirstName(person.getFirstName());
            humanName.setLastName(person.getLastName());
            String middleName = person.getMiddleName();
            if (middleName != null && !middleName.equals("")) {
                humanName.setMiddleName(middleName);
            }
        }
        return humanName;
    }

    public HumanNameDataType getHumanNameDataType(KeyPersonInfo keyPerson) {
        HumanNameDataType humanName = HumanNameDataType.Factory.newInstance();
        if (keyPerson != null) {
            humanName.setFirstName(keyPerson.getFirstName());
            humanName.setLastName(keyPerson.getLastName());
            String middleName = keyPerson.getMiddleName();
            if (middleName != null && !middleName.equals("")) {
                humanName.setMiddleName(middleName);
            }
        }
        return humanName;
    }

    public ContactPersonDataType getContactPersonDataType(ProposalPerson person) {
        ContactPersonDataType contactPerson = ContactPersonDataType.Factory.newInstance();
        if (person != null) {
            String fax;
            String title;
            String email;
            contactPerson.setName(this.getHumanNameDataType(person));
            String phone = person.getOfficePhone();
            if (phone != null && !phone.equals("")) {
                contactPerson.setPhone(phone);
            }
            if ((email = person.getEmailAddress()) != null && !email.equals("")) {
                contactPerson.setEmail(email);
            }
            if ((title = person.getPrimaryTitle()) != null && !title.equals("")) {
                contactPerson.setTitle(title);
            }
            if ((fax = person.getFaxNumber()) != null && !fax.equals("")) {
                contactPerson.setFax(fax);
            }
            contactPerson.setAddress(this.getAddressDataType(person));
        }
        return contactPerson;
    }

    public ContactPersonDataType getContactPersonDataType(Rolodex rolodex) {
        ContactPersonDataType contactPerson = ContactPersonDataType.Factory.newInstance();
        if (rolodex != null) {
            String title;
            String email;
            String fax;
            contactPerson.setName(this.getHumanNameDataType(rolodex));
            String phone = rolodex.getPhoneNumber();
            if (phone != null && !phone.equals("")) {
                contactPerson.setPhone(phone);
            }
            if ((fax = rolodex.getFaxNumber()) != null && !fax.equals("")) {
                contactPerson.setFax(fax);
            }
            if ((email = rolodex.getEmailAddress()) != null && !email.equals("")) {
                contactPerson.setEmail(rolodex.getEmailAddress());
            }
            if ((title = rolodex.getTitle()) != null && !title.equals("")) {
                contactPerson.setTitle(title);
            }
            contactPerson.setAddress(this.getAddressDataType(rolodex));
        }
        return contactPerson;
    }

    public ContactPersonDataType getContactPersonDataType(ProposalDevelopmentDocument proposalDocument) {
        ContactPersonDataType contactPerson = ContactPersonDataType.Factory.newInstance();
        DepartmentalPerson person = this.s2sUtilService.getContactPerson(proposalDocument);
        if (person != null) {
            String title;
            String email;
            String fax;
            contactPerson.setName(this.getHumanNameDataType(person));
            String phone = person.getOfficePhone();
            if (phone != null && !phone.equals("")) {
                contactPerson.setPhone(phone);
            }
            if ((fax = person.getFaxNumber()) != null && !fax.equals("")) {
                contactPerson.setFax(fax);
            }
            if ((email = person.getEmailAddress()) != null && !email.equals("")) {
                contactPerson.setEmail(person.getEmailAddress());
            }
            if ((title = person.getPrimaryTitle()) != null && !title.equals("")) {
                contactPerson.setTitle(title);
            }
            contactPerson.setAddress(this.getAddressDataType(person));
        }
        return contactPerson;
    }
}

