/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.forms.nsfCoverPage13V13.NSFCoverPage13Document;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.attachmentsV10.AttachmentGroupMin1Max100DataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.bo.OrganizationYnq;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.bo.ProposalSite;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.questionnaire.ProposalPersonModuleQuestionnaireBean;
import org.kuali.kra.questionnaire.answer.Answer;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.questionnaire.answer.QuestionnaireAnswerService;
import org.kuali.kra.s2s.generator.S2SQuestionnairing;
import org.kuali.kra.s2s.generator.impl.NSFCoverPageBaseGenerator;

public class NSFCoverPageV1_3Generator
extends NSFCoverPageBaseGenerator
implements S2SQuestionnairing {
    private NSFCoverPage13Document getNSFCoverPage13() {
        NSFCoverPage13Document nsfCoverPage13Document = NSFCoverPage13Document.Factory.newInstance();
        NSFCoverPage13Document.NSFCoverPage13 nsfCoverPage13 = NSFCoverPage13Document.NSFCoverPage13.Factory.newInstance();
        nsfCoverPage13.setFormVersion("1.3");
        this.setFundingOpportunityNumber(nsfCoverPage13);
        if (this.pdDoc.getDevelopmentProposal().getS2sOpportunity() != null && this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getClosingDate() != null) {
            nsfCoverPage13.setDueDate(this.dateTimeService.getCalendar((Date)this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getClosingDate()));
        }
        nsfCoverPage13.setNSFUnitConsideration(this.getNSFUnitConsideration());
        this.setOtherInfo(nsfCoverPage13);
        AttachmentGroupMin1Max100DataType attachmentGroup = AttachmentGroupMin1Max100DataType.Factory.newInstance();
        attachmentGroup.setAttachedFileArray(this.getAttachedFileDataTypes());
        if (attachmentGroup.getAttachedFileArray().length > 0) {
            nsfCoverPage13.setSingleCopyDocuments(attachmentGroup);
        }
        nsfCoverPage13Document.setNSFCoverPage13(nsfCoverPage13);
        return nsfCoverPage13Document;
    }

    private void setFundingOpportunityNumber(NSFCoverPage13Document.NSFCoverPage13 nsfCoverPage13) {
        if (this.pdDoc.getDevelopmentProposal().getProgramAnnouncementNumber() != null) {
            if (this.pdDoc.getDevelopmentProposal().getProgramAnnouncementNumber().length() > 40) {
                nsfCoverPage13.setFundingOpportunityNumber(this.pdDoc.getDevelopmentProposal().getProgramAnnouncementNumber().substring(0, 40));
            } else {
                nsfCoverPage13.setFundingOpportunityNumber(this.pdDoc.getDevelopmentProposal().getProgramAnnouncementNumber());
            }
        }
    }

    private void setOtherInfo(NSFCoverPage13Document.NSFCoverPage13 nsfCoverPage13) {
        NSFCoverPage13Document.NSFCoverPage13.OtherInfo otherInfo = NSFCoverPage13Document.NSFCoverPage13.OtherInfo.Factory.newInstance();
        NSFCoverPage13Document.NSFCoverPage13.PIInfo pInfo = NSFCoverPage13Document.NSFCoverPage13.PIInfo.Factory.newInstance();
        for (Answer questionnaireAnswer : this.s2sUtilService.getQuestionnaireAnswers(this.pdDoc.getDevelopmentProposal(), this.getNamespace(), this.getFormName())) {
            String answer = questionnaireAnswer.getAnswer();
            int questionId = questionnaireAnswer.getQuestionNumber();
            if (answer == null) continue;
            switch (questionId) {
                case 1: {
                    pInfo.setIsCurrentPI(answer.equals("Y") ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    break;
                }
                case 2: {
                    otherInfo.setIsBeginInvestigator(answer.equals("Y") ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    break;
                }
                case 4: {
                    otherInfo.setIsEarlyConceptGrant(answer.equals("Y") ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    break;
                }
                case 3: {
                    otherInfo.setIsRapidResponseGrant(answer.equals("Y") ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    break;
                }
                case 5: {
                    otherInfo.setIsAccomplishmentRenewal(answer.equals("Y") ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    break;
                }
                case 6: {
                    otherInfo.setIsHighResolutionGraphics(answer.equals("Y") ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    break;
                }
            }
        }
        nsfCoverPage13.setPIInfo(pInfo);
        otherInfo.setIsDisclosureLobbyingActivities(this.getLobbyingAnswer());
        nsfCoverPage13.setOtherInfo(otherInfo);
    }

    private YesNoDataType.Enum getLobbyingAnswer() {
        YesNoDataType.Enum answer = YesNoDataType.N_NO;
        for (ProposalPerson proposalPerson : this.pdDoc.getDevelopmentProposal().getProposalPersons()) {
            if ((proposalPerson.getProposalPersonRoleId() == null || !proposalPerson.getProposalPersonRoleId().equals("PI")) && !proposalPerson.getProposalPersonRoleId().equals("COI")) continue;
            ProposalPersonModuleQuestionnaireBean moduleQuestionnaireBean = new ProposalPersonModuleQuestionnaireBean(this.pdDoc.getDevelopmentProposal(), proposalPerson);
            List<AnswerHeader> headers = this.getQuestionnaireAnswerService().getQuestionnaireAnswer(moduleQuestionnaireBean);
            AnswerHeader answerHeader = headers.get(0);
            List<Answer> certificationAnswers = answerHeader.getAnswers();
            for (Answer certificatonAnswer : certificationAnswers) {
                if (certificatonAnswer == null || !"10088".equals(certificatonAnswer.getQuestion().getQuestionId()) || !"Y".equals(certificatonAnswer.getAnswer())) continue;
                return YesNoDataType.Y_YES;
            }
        }
        Organization organization = this.getOrganizationFromDevelopmentProposal(this.pdDoc.getDevelopmentProposal());
        List<OrganizationYnq> organizationYnqs = null;
        if (organization != null && organization.getOrganizationId() != null) {
            organizationYnqs = this.getOrganizationYNQ(organization.getOrganizationId());
        }
        for (OrganizationYnq organizationYnq : organizationYnqs) {
            if (!organizationYnq.getQuestionId().equals("H0") || !this.getAnswerFromOrganizationYnq(organizationYnq)) continue;
            return YesNoDataType.Y_YES;
        }
        return answer;
    }

    private QuestionnaireAnswerService getQuestionnaireAnswerService() {
        return KraServiceLocator.getService(QuestionnaireAnswerService.class);
    }

    protected boolean getAnswerFromOrganizationYnq(OrganizationYnq organizationYnq) {
        return organizationYnq.getAnswer().equals("Y");
    }

    private List<OrganizationYnq> getOrganizationYNQ(String questionId) {
        Object organizationYnq = null;
        HashMap<String, String> organizationYnqMap = new HashMap<String, String>();
        organizationYnqMap.put("organizationId", questionId);
        List organizationYnqs = (List)this.businessObjectService.findMatching(OrganizationYnq.class, organizationYnqMap);
        return organizationYnqs;
    }

    private Organization getOrganizationFromDevelopmentProposal(DevelopmentProposal developmentProposal) {
        Organization organization = null;
        ProposalSite proposalSite = developmentProposal.getApplicantOrganization();
        if (proposalSite != null) {
            organization = proposalSite.getOrganization();
        }
        return organization;
    }

    private NSFCoverPage13Document.NSFCoverPage13.NSFUnitConsideration getNSFUnitConsideration() {
        NSFCoverPage13Document.NSFCoverPage13.NSFUnitConsideration nsfConsideration = NSFCoverPage13Document.NSFCoverPage13.NSFUnitConsideration.Factory.newInstance();
        nsfConsideration.setDivisionCode(this.pdDoc.getDevelopmentProposal().getAgencyDivisionCode());
        nsfConsideration.setProgramCode(this.pdDoc.getDevelopmentProposal().getAgencyProgramCode());
        return nsfConsideration;
    }

    private AttachedFileDataType[] getAttachedFileDataTypes() {
        ArrayList<AttachedFileDataType> attachedFileDataTypeList = new ArrayList<AttachedFileDataType>();
        AttachedFileDataType attachedFileDataType = null;
        for (Narrative narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            int narrativeTypeCode;
            if (narrative.getNarrativeTypeCode() == null || (narrativeTypeCode = Integer.parseInt(narrative.getNarrativeTypeCode())) != 13 && narrativeTypeCode != 14 && narrativeTypeCode != 87 || (attachedFileDataType = this.getAttachedFileType(narrative)) == null) continue;
            attachedFileDataTypeList.add(attachedFileDataType);
        }
        return attachedFileDataTypeList.toArray(new AttachedFileDataType[attachedFileDataTypeList.size()]);
    }

    @Override
    public XmlObject getFormObject(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getNSFCoverPage13();
    }

    public XmlObject getFormObject(XmlObject xmlObject) {
        NSFCoverPage13Document.NSFCoverPage13 nsfCoverPage13 = (NSFCoverPage13Document.NSFCoverPage13)xmlObject;
        NSFCoverPage13Document nsfCoverPage13Document = NSFCoverPage13Document.Factory.newInstance();
        nsfCoverPage13Document.setNSFCoverPage13(nsfCoverPage13);
        return nsfCoverPage13Document;
    }

    @Override
    public String getFormName() {
        return "NSF_CoverPage_1_3-V1.3";
    }

    @Override
    public String getNamespace() {
        return "http://apply.grants.gov/forms/NSF_CoverPage_1_3-V1.3";
    }
}

