/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.forms.nasaPIandAORSupplementalDataSheetV10.FederalAgencyDataType;
import gov.grants.apply.forms.nasaPIandAORSupplementalDataSheetV10.NasaPIandAORSupplementalDataSheetDocument;
import gov.grants.apply.system.globalLibraryV20.HumanNameDataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.infrastructure.BudgetDecimalFormatter;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.questionnaire.answer.Answer;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.s2s.generator.S2SBaseFormGenerator;
import org.kuali.kra.s2s.generator.bo.DepartmentalPerson;
import org.kuali.kra.s2s.service.S2SBudgetCalculatorService;
import org.kuali.kra.s2s.service.S2SUtilService;

public class NasaPIandAORSupplementalDataSheetV1_0Generator
extends S2SBaseFormGenerator {
    private static final Log LOG = LogFactory.getLog(NasaPIandAORSupplementalDataSheetV1_0Generator.class);
    private S2SUtilService s2sUtilService = KraServiceLocator.getService(S2SUtilService.class);
    private S2SBudgetCalculatorService s2sBudgetCalculatorService = KraServiceLocator.getService(S2SBudgetCalculatorService.class);
    private static final String PI_PROPOSAL_YNQ_INTERNATIONAL_PARTICIPATION = "112";
    private static final String PI_PROPOSAL_YNQ_US_GOVERNMENT_PARTICIPATION_AMOUNT = "113";
    private static final String PI_SUB_PROPOSAL_YNQ_US_GOVERNMENT_PARTICIPATION_AMOUNT = "111";
    private static final String PI_PROPOSAL_YNQ_US_GOVERNMENT_PARTICIPATION = "110";
    private static final String NOT_ANSWERED = "No";
    List<AnswerHeader> answerHeaders;

    private NasaPIandAORSupplementalDataSheetDocument getnasapIandAORSupplementalDataSheetDocument() {
        NasaPIandAORSupplementalDataSheetDocument nasaPIandAORSupplementalDataSheetDocument = NasaPIandAORSupplementalDataSheetDocument.Factory.newInstance();
        NasaPIandAORSupplementalDataSheetDocument.NasaPIandAORSupplementalDataSheet nasapIandAORSupplementalDataSheet = NasaPIandAORSupplementalDataSheetDocument.NasaPIandAORSupplementalDataSheet.Factory.newInstance();
        nasapIandAORSupplementalDataSheet.setFormVersion("1.0");
        nasapIandAORSupplementalDataSheet.setAuthorizedRepresentativeName(this.getAuthorizedRep());
        nasapIandAORSupplementalDataSheet.setPrincipalInvestigatorName(this.getPrincipalInvestigator());
        nasaPIandAORSupplementalDataSheetDocument.setNasaPIandAORSupplementalDataSheet(nasapIandAORSupplementalDataSheet);
        return nasaPIandAORSupplementalDataSheetDocument;
    }

    private NasaPIandAORSupplementalDataSheetDocument.NasaPIandAORSupplementalDataSheet.AuthorizedRepresentativeName getAuthorizedRep() {
        NasaPIandAORSupplementalDataSheetDocument.NasaPIandAORSupplementalDataSheet.AuthorizedRepresentativeName authorizedRepresentativeName = NasaPIandAORSupplementalDataSheetDocument.NasaPIandAORSupplementalDataSheet.AuthorizedRepresentativeName.Factory.newInstance();
        DepartmentalPerson aorInfo = this.s2sUtilService.getDepartmentalPerson(this.pdDoc);
        authorizedRepresentativeName.setAORName(this.globLibV20Generator.getHumanNameDataType(aorInfo));
        return authorizedRepresentativeName;
    }

    private NasaPIandAORSupplementalDataSheetDocument.NasaPIandAORSupplementalDataSheet.PrincipalInvestigatorName getPrincipalInvestigator() {
        String answer;
        NasaPIandAORSupplementalDataSheetDocument.NasaPIandAORSupplementalDataSheet.PrincipalInvestigatorName principalInvestigatorName = NasaPIandAORSupplementalDataSheetDocument.NasaPIandAORSupplementalDataSheet.PrincipalInvestigatorName.Factory.newInstance();
        ProposalPerson PI = this.s2sUtilService.getPrincipalInvestigator(this.pdDoc);
        if (PI != null) {
            principalInvestigatorName.setPDPIName(this.globLibV20Generator.getHumanNameDataType(PI));
        } else {
            principalInvestigatorName.setPDPIName(HumanNameDataType.Factory.newInstance());
        }
        this.answerHeaders = this.getQuestionnaireAnswers(this.pdDoc.getDevelopmentProposal(), true);
        for (AnswerHeader answerHeader : this.answerHeaders) {
            for (Answer answers : answerHeader.getAnswers()) {
                if (answers.getQuestion().getQuestionId() == null || !answers.getQuestion().getQuestionId().equals(PI_PROPOSAL_YNQ_US_GOVERNMENT_PARTICIPATION)) continue;
                answer = null;
                String explanation = null;
                if (answers.getAnswer() == null || answers.getAnswer().equals(NOT_ANSWERED)) continue;
                answer = answers.getAnswer();
                if (this.getExplanation(PI_SUB_PROPOSAL_YNQ_US_GOVERNMENT_PARTICIPATION_AMOUNT) != null) {
                    explanation = this.getExplanation(PI_SUB_PROPOSAL_YNQ_US_GOVERNMENT_PARTICIPATION_AMOUNT);
                }
                if (answer == null) continue;
                if (answer.equals("Y")) {
                    principalInvestigatorName.setUSGovernmentParticipation(YesNoDataType.Y_YES);
                    FederalAgencyDataType.Enum FederalAgencyEnum = this.getFederalAgency(explanation);
                    principalInvestigatorName.setFederalAgency(FederalAgencyEnum);
                    principalInvestigatorName.setFederalAgencyDollar(this.getAmount(PI_PROPOSAL_YNQ_US_GOVERNMENT_PARTICIPATION_AMOUNT));
                    continue;
                }
                if (!answer.equals("N")) continue;
                principalInvestigatorName.setUSGovernmentParticipation(YesNoDataType.N_NO);
            }
        }
        block2: for (AnswerHeader answerHeader : this.answerHeaders) {
            for (Answer answers : answerHeader.getAnswers()) {
                if (answers.getQuestion().getQuestionId() == null || !answers.getQuestion().getQuestionId().equals(PI_PROPOSAL_YNQ_INTERNATIONAL_PARTICIPATION)) continue;
                answer = null;
                if (answers.getAnswer() == null || answers.getAnswer().equals(NOT_ANSWERED)) continue;
                answer = answers.getAnswer();
                if (answer == null) continue block2;
                if (answer.equals("Y")) {
                    principalInvestigatorName.setInternationalParticipation(YesNoDataType.Y_YES);
                    continue block2;
                }
                if (!answer.equals("N")) continue block2;
                principalInvestigatorName.setInternationalParticipation(YesNoDataType.N_NO);
                continue block2;
            }
        }
        return principalInvestigatorName;
    }

    private FederalAgencyDataType.Enum getFederalAgency(String explanation) {
        FederalAgencyDataType.Enum FederalAgencyEnum = null;
        if (explanation != null) {
            int federalAgencyCode = 0;
            try {
                federalAgencyCode = Integer.parseInt(explanation);
                if (federalAgencyCode > 99 && federalAgencyCode < 151) {
                    FederalAgencyEnum = FederalAgencyDataType.Enum.forInt((int)(federalAgencyCode - 100));
                }
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)"Comments entered should be number between 101 to 150", (Throwable)e);
            }
        }
        return FederalAgencyEnum;
    }

    @Override
    public XmlObject getFormObject(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getnasapIandAORSupplementalDataSheetDocument();
    }

    public XmlObject getFormObject(XmlObject xmlObject) {
        NasaPIandAORSupplementalDataSheetDocument nasapIandAORSupplementalDataSheetDocument = NasaPIandAORSupplementalDataSheetDocument.Factory.newInstance();
        NasaPIandAORSupplementalDataSheetDocument.NasaPIandAORSupplementalDataSheet nasapIandAORSupplementalDataSheet = (NasaPIandAORSupplementalDataSheetDocument.NasaPIandAORSupplementalDataSheet)xmlObject;
        nasapIandAORSupplementalDataSheetDocument.setNasaPIandAORSupplementalDataSheet(nasapIandAORSupplementalDataSheet);
        return nasapIandAORSupplementalDataSheetDocument;
    }

    private String getExplanation(String questionID) {
        String answer = null;
        if (this.answerHeaders != null && !this.answerHeaders.isEmpty()) {
            block0: for (AnswerHeader answerHeader : this.answerHeaders) {
                for (Answer answers : answerHeader.getAnswers()) {
                    if (answers.getQuestion().getQuestionId() == null || !questionID.equals(answers.getQuestion().getQuestionId())) continue;
                    answer = answers.getAnswer();
                    continue block0;
                }
            }
        }
        return answer;
    }

    private BigDecimal getAmount(String questionID) {
        BigDecimal amount = null;
        BudgetDecimalFormatter b = new BudgetDecimalFormatter();
        for (AnswerHeader answerHeader : this.answerHeaders) {
            for (Answer answers : answerHeader.getAnswers()) {
                String answer;
                if (answers.getQuestion().getQuestionId() == null || !questionID.equals(answers.getQuestion().getQuestionId()) || (answer = answers.getAnswer()) == null) continue;
                amount = new BigDecimal(Integer.parseInt(answer));
            }
        }
        return amount;
    }
}

