/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.forms.phs398CareerDevelopmentAwardSupV10.CitizenshipDataType;
import gov.grants.apply.forms.phs398CareerDevelopmentAwardSupV10.PHS398CareerDevelopmentAwardSupDocument;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.attachmentsV10.AttachmentGroupMin0Max100DataType;
import java.util.ArrayList;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.infrastructure.CitizenshipTypes;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.s2s.generator.impl.PHS398CareerDevelopmentAwardSupBaseGenerator;

public class PHS398CareerDevelopmentAwardSupV1_0Generator
extends PHS398CareerDevelopmentAwardSupBaseGenerator {
    private static final String PI_CUSTOM_DATA = "PI_CITIZENSHIP_FROM_CUSTOM_DATA";
    private static final String PROPOSAL_TYPE_TASK_ORDER = "6";

    private XmlObject getPHS398CareerDevelopmentAwardSup() {
        PHS398CareerDevelopmentAwardSupDocument phs398CareerDevelopmentAwardSupDocument = PHS398CareerDevelopmentAwardSupDocument.Factory.newInstance();
        PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup phs398CareerDevelopmentAwardSup = PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.Factory.newInstance();
        phs398CareerDevelopmentAwardSup.setFormVersion("1.0");
        phs398CareerDevelopmentAwardSup.setApplicationType(this.getApplicationType());
        phs398CareerDevelopmentAwardSup.setCitizenship(this.getCitizenshipDataType());
        phs398CareerDevelopmentAwardSup.setCareerDevelopmentAwardAttachments(this.getCareerDevelopmentAwardAttachments());
        phs398CareerDevelopmentAwardSupDocument.setPHS398CareerDevelopmentAwardSup(phs398CareerDevelopmentAwardSup);
        return phs398CareerDevelopmentAwardSupDocument;
    }

    private CitizenshipDataType.Enum getCitizenshipDataType() {
        for (ProposalPerson proposalPerson : this.pdDoc.getDevelopmentProposal().getProposalPersons()) {
            if (!proposalPerson.isInvestigator()) continue;
            CitizenshipTypes citizenShip = this.s2sUtilService.getCitizenship(proposalPerson);
            if (citizenShip.getCitizenShip().trim().equals(CitizenshipDataType.NON_U_S_CITIZEN_WITH_TEMPORARY_VISA.toString())) {
                return CitizenshipDataType.NON_U_S_CITIZEN_WITH_TEMPORARY_VISA;
            }
            if (citizenShip.getCitizenShip().trim().equals(CitizenshipDataType.PERMANENT_RESIDENT_OF_U_S.toString())) {
                return CitizenshipDataType.PERMANENT_RESIDENT_OF_U_S;
            }
            if (!citizenShip.getCitizenShip().trim().equals(CitizenshipDataType.U_S_CITIZEN_OR_NONCITIZEN_NATIONAL.toString())) continue;
            return CitizenshipDataType.U_S_CITIZEN_OR_NONCITIZEN_NATIONAL;
        }
        return CitizenshipDataType.PERMANENT_RESIDENT_OF_U_S;
    }

    private PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.ApplicationType getApplicationType() {
        PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.ApplicationType applicationType = PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.ApplicationType.Factory.newInstance();
        if (this.pdDoc.getDevelopmentProposal().getProposalTypeCode() != null && !this.pdDoc.getDevelopmentProposal().getProposalTypeCode().equals(PROPOSAL_TYPE_TASK_ORDER)) {
            applicationType.setTypeOfApplication(PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.ApplicationType.TypeOfApplication.Enum.forInt((int)Integer.parseInt(this.pdDoc.getDevelopmentProposal().getProposalTypeCode())));
        } else {
            applicationType.setTypeOfApplication(PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.ApplicationType.TypeOfApplication.NEW);
        }
        return applicationType;
    }

    private PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments getCareerDevelopmentAwardAttachments() {
        PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments careerDevelopmentAwardAttachments = PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.Factory.newInstance();
        AttachmentGroupMin0Max100DataType attachmentGroupMin0Max100DataType = AttachmentGroupMin0Max100DataType.Factory.newInstance();
        ArrayList<AttachedFileDataType> attachedFileList = new ArrayList<AttachedFileDataType>();
        AttachedFileDataType attachedFileDataType = null;
        for (Narrative narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            int narrativeType = Integer.parseInt(narrative.getNarrativeTypeCode());
            switch (narrativeType) {
                case 70: {
                    attachedFileDataType = this.getAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.IntroductionToApplication introductionToApplication = PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.IntroductionToApplication.Factory.newInstance();
                    introductionToApplication.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setIntroductionToApplication(introductionToApplication);
                    break;
                }
                case 71: {
                    attachedFileDataType = this.getAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.SpecificAims specificAims = PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.SpecificAims.Factory.newInstance();
                    specificAims.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setSpecificAims(specificAims);
                    break;
                }
                case 72: {
                    attachedFileDataType = this.getAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.BackgroundAndSignificance backgroundAndSignificance = PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.BackgroundAndSignificance.Factory.newInstance();
                    backgroundAndSignificance.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setBackgroundAndSignificance(backgroundAndSignificance);
                    break;
                }
                case 73: {
                    attachedFileDataType = this.getAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.ResearchDesignAndMethods researchDesignAndMethods = PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.ResearchDesignAndMethods.Factory.newInstance();
                    researchDesignAndMethods.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setResearchDesignAndMethods(researchDesignAndMethods);
                    break;
                }
                case 79: {
                    attachedFileDataType = this.getAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.InclusionEnrollmentReport inclusionEnrollmentReport = PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.InclusionEnrollmentReport.Factory.newInstance();
                    inclusionEnrollmentReport.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setInclusionEnrollmentReport(inclusionEnrollmentReport);
                    break;
                }
                case 80: {
                    attachedFileDataType = this.getAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.ProgressReportPublicationList progressReportPublicationList = PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.ProgressReportPublicationList.Factory.newInstance();
                    progressReportPublicationList.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setProgressReportPublicationList(progressReportPublicationList);
                    break;
                }
                case 74: {
                    attachedFileDataType = this.getAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.ProtectionOfHumanSubjects protectionOfHumanSubjects = PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.ProtectionOfHumanSubjects.Factory.newInstance();
                    protectionOfHumanSubjects.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setProtectionOfHumanSubjects(protectionOfHumanSubjects);
                    break;
                }
                case 75: {
                    attachedFileDataType = this.getAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.InclusionOfWomenAndMinorities inclusionOfWomenAndMinorities = PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.InclusionOfWomenAndMinorities.Factory.newInstance();
                    inclusionOfWomenAndMinorities.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setInclusionOfWomenAndMinorities(inclusionOfWomenAndMinorities);
                    break;
                }
                case 76: {
                    attachedFileDataType = this.getAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.TargetedPlannedEnrollment targetedPlannedEnrollment = PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.TargetedPlannedEnrollment.Factory.newInstance();
                    targetedPlannedEnrollment.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setTargetedPlannedEnrollment(targetedPlannedEnrollment);
                    break;
                }
                case 77: {
                    attachedFileDataType = this.getAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.InclusionOfChildren inclusionOfChildren = PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.InclusionOfChildren.Factory.newInstance();
                    inclusionOfChildren.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setInclusionOfChildren(inclusionOfChildren);
                    break;
                }
                case 78: {
                    attachedFileDataType = this.getAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.VertebrateAnimals vertebrateAnimals = PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.VertebrateAnimals.Factory.newInstance();
                    vertebrateAnimals.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setVertebrateAnimals(vertebrateAnimals);
                    break;
                }
                case 81: {
                    attachedFileDataType = this.getAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.SelectAgentResearch selectAgentResearch = PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.SelectAgentResearch.Factory.newInstance();
                    selectAgentResearch.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setSelectAgentResearch(selectAgentResearch);
                    break;
                }
                case 82: {
                    attachedFileDataType = this.getAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.PreliminaryStudiesProgressReport preliminaryStudiesProgressReport = PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.PreliminaryStudiesProgressReport.Factory.newInstance();
                    preliminaryStudiesProgressReport.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setPreliminaryStudiesProgressReport(preliminaryStudiesProgressReport);
                    break;
                }
                case 83: {
                    attachedFileDataType = this.getAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.ConsortiumContractualArrangements consortiumContractualArrangements = PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.ConsortiumContractualArrangements.Factory.newInstance();
                    consortiumContractualArrangements.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setConsortiumContractualArrangements(consortiumContractualArrangements);
                    break;
                }
                case 84: {
                    attachedFileDataType = this.getAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.ResourceSharingPlans resourceSharingPlans = PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.ResourceSharingPlans.Factory.newInstance();
                    resourceSharingPlans.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setResourceSharingPlans(resourceSharingPlans);
                    break;
                }
                case 62: {
                    attachedFileDataType = this.getAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.CandidateBackground candidateBackground = PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.CandidateBackground.Factory.newInstance();
                    candidateBackground.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setCandidateBackground(candidateBackground);
                    break;
                }
                case 63: {
                    attachedFileDataType = this.getAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.CareerGoalsAndObjectives careerGoalsAndObjectives = PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.CareerGoalsAndObjectives.Factory.newInstance();
                    careerGoalsAndObjectives.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setCareerGoalsAndObjectives(careerGoalsAndObjectives);
                    break;
                }
                case 64: {
                    attachedFileDataType = this.getAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.CareerDevelopmentAndTrainingActivities careerDevelopmentAndTrainingActivities = PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.CareerDevelopmentAndTrainingActivities.Factory.newInstance();
                    careerDevelopmentAndTrainingActivities.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setCareerDevelopmentAndTrainingActivities(careerDevelopmentAndTrainingActivities);
                    break;
                }
                case 65: {
                    attachedFileDataType = this.getAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.ResponsibleConductOfResearch responsibleConductOfResearch = PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.ResponsibleConductOfResearch.Factory.newInstance();
                    responsibleConductOfResearch.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setResponsibleConductOfResearch(responsibleConductOfResearch);
                    break;
                }
                case 66: {
                    attachedFileDataType = this.getAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.MentoringPlan mentoringPlan = PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.MentoringPlan.Factory.newInstance();
                    mentoringPlan.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setMentoringPlan(mentoringPlan);
                    break;
                }
                case 67: {
                    attachedFileDataType = this.getAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.StatementsOfSupport statementsOfSupport = PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.StatementsOfSupport.Factory.newInstance();
                    statementsOfSupport.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setStatementsOfSupport(statementsOfSupport);
                    break;
                }
                case 68: {
                    attachedFileDataType = this.getAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.InsitutionalEnvironment insitutionalEnvironment = PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.InsitutionalEnvironment.Factory.newInstance();
                    insitutionalEnvironment.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setInsitutionalEnvironment(insitutionalEnvironment);
                    break;
                }
                case 69: {
                    attachedFileDataType = this.getAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.InstitutionalCommitment institutionalCommitment = PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.CareerDevelopmentAwardAttachments.InstitutionalCommitment.Factory.newInstance();
                    institutionalCommitment.setAttFile(attachedFileDataType);
                    careerDevelopmentAwardAttachments.setInstitutionalCommitment(institutionalCommitment);
                    break;
                }
                case 85: {
                    attachedFileDataType = this.getAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    attachedFileList.add(attachedFileDataType);
                }
            }
        }
        attachmentGroupMin0Max100DataType.setAttachedFileArray(attachedFileList.toArray(new AttachedFileDataType[0]));
        careerDevelopmentAwardAttachments.setAppendix(attachmentGroupMin0Max100DataType);
        return careerDevelopmentAwardAttachments;
    }

    @Override
    public XmlObject getFormObject(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getPHS398CareerDevelopmentAwardSup();
    }

    public XmlObject getFormObject(XmlObject xmlObject) {
        PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup phs398CareerDevelopmentAwardSup = PHS398CareerDevelopmentAwardSupDocument.PHS398CareerDevelopmentAwardSup.Factory.newInstance();
        PHS398CareerDevelopmentAwardSupDocument phs398CareerDevelopmentAwardSupDocument = PHS398CareerDevelopmentAwardSupDocument.Factory.newInstance();
        phs398CareerDevelopmentAwardSupDocument.setPHS398CareerDevelopmentAwardSup(phs398CareerDevelopmentAwardSup);
        return phs398CareerDevelopmentAwardSupDocument;
    }
}

