/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.forms.phs398ChecklistV11.PHS398ChecklistDocument;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.globalLibraryV20.HumanNameDataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.distributionincome.BudgetProjectIncome;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.questionnaire.answer.Answer;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.s2s.S2SException;
import org.kuali.kra.s2s.generator.impl.PHS398ChecklistBaseGenerator;
import org.kuali.rice.krad.service.BusinessObjectService;

public class PHS398ChecklistV1_1Generator
extends PHS398ChecklistBaseGenerator {
    private static final Log LOG = LogFactory.getLog(PHS398ChecklistV1_1Generator.class);
    List<AnswerHeader> answerHeaders;

    private PHS398ChecklistDocument getPHS398Checklist() {
        PHS398ChecklistDocument phsChecklistDocument = PHS398ChecklistDocument.Factory.newInstance();
        PHS398ChecklistDocument.PHS398Checklist phsChecklist = PHS398ChecklistDocument.PHS398Checklist.Factory.newInstance();
        phsChecklist.setFormVersion("1.1");
        PHS398ChecklistDocument.PHS398Checklist.ApplicationType.Enum applicationEnum = null;
        this.answerHeaders = this.getQuestionnaireAnswers(this.pdDoc.getDevelopmentProposal(), true);
        if (this.pdDoc.getDevelopmentProposal().getProposalTypeCode() != null && Integer.parseInt(this.pdDoc.getDevelopmentProposal().getProposalTypeCode()) < 6) {
            applicationEnum = PHS398ChecklistDocument.PHS398Checklist.ApplicationType.Enum.forInt((int)Integer.parseInt(this.pdDoc.getDevelopmentProposal().getProposalTypeCode()));
        }
        phsChecklist.setApplicationType(applicationEnum);
        String federalId = this.s2sUtilService.getFederalId(this.pdDoc);
        if (federalId != null) {
            phsChecklist.setFederalID(federalId);
        }
        String pIChange = this.getAnswer("114");
        String pIChangeExplanation = this.getAnswer("115");
        if ("Y".equals(pIChange)) {
            BusinessObjectService businessObjectService;
            Rolodex rolodex;
            HumanNameDataType formerPDName;
            phsChecklist.setIsChangeOfPDPI(YesNoDataType.Y_YES);
            if (pIChangeExplanation != null && (formerPDName = this.globLibV20Generator.getHumanNameDataType(rolodex = (Rolodex)(businessObjectService = KraServiceLocator.getService(BusinessObjectService.class)).findBySinglePrimaryKey(Rolodex.class, (Object)pIChangeExplanation))) != null && formerPDName.getFirstName() != null && formerPDName.getLastName() != null) {
                phsChecklist.setFormerPDName(formerPDName);
            }
        } else {
            phsChecklist.setIsChangeOfPDPI(YesNoDataType.N_NO);
        }
        String institutionChange = this.getAnswer("116");
        String institutionChangeExplanation = this.getAnswer("117");
        if ("Y".equals(institutionChange)) {
            phsChecklist.setIsChangeOfInstitution(YesNoDataType.Y_YES);
            if (institutionChangeExplanation != null) {
                phsChecklist.setFormerInstitutionName(institutionChangeExplanation);
            }
        } else {
            phsChecklist.setIsChangeOfInstitution(YesNoDataType.N_NO);
        }
        String renewalApplication = this.getAnswer("118");
        boolean hasSubQuestionExplanation = false;
        if (renewalApplication != null && !renewalApplication.equals("No")) {
            if ("Y".equals(renewalApplication)) {
                String inventionsConceived = this.getAnswer("119");
                if ("Y".equals(inventionsConceived)) {
                    phsChecklist.setIsInventionsAndPatents(YesNoDataType.Y_YES);
                    String reportedPreviously = this.getAnswer("120");
                    if (reportedPreviously != null && !reportedPreviously.equals("No")) {
                        if ("Y".equals(reportedPreviously)) {
                            phsChecklist.setIsPreviouslyReported(YesNoDataType.Y_YES);
                        } else {
                            phsChecklist.setIsPreviouslyReported(YesNoDataType.N_NO);
                        }
                        hasSubQuestionExplanation = true;
                    }
                } else {
                    phsChecklist.setIsInventionsAndPatents(YesNoDataType.Y_YES);
                    if (hasSubQuestionExplanation) {
                        phsChecklist.setIsPreviouslyReported(YesNoDataType.N_NO);
                    }
                }
            } else {
                phsChecklist.setIsInventionsAndPatents(YesNoDataType.N_NO);
                if (hasSubQuestionExplanation) {
                    phsChecklist.setIsPreviouslyReported(YesNoDataType.N_NO);
                }
            }
        }
        Budget budget = null;
        try {
            BudgetDocument budgetDocument = this.s2sBudgetCalculatorService.getFinalBudgetVersion(this.pdDoc);
            budget = budgetDocument == null ? null : budgetDocument.getBudget();
        }
        catch (S2SException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return phsChecklistDocument;
        }
        if (budget != null && budget.getBudgetProjectIncomes().size() > 0) {
            this.setProjectIncome(phsChecklist, budget);
        } else {
            phsChecklist.setProgramIncome(YesNoDataType.N_NO);
        }
        AttachedFileDataType attachedFileDataType = null;
        for (Narrative narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeTypeCode() == null || Integer.parseInt(narrative.getNarrativeTypeCode()) != 38 || (attachedFileDataType = this.getAttachedFileType(narrative)) == null) continue;
            PHS398ChecklistDocument.PHS398Checklist.CertificationExplanation certExplanation = PHS398ChecklistDocument.PHS398Checklist.CertificationExplanation.Factory.newInstance();
            certExplanation.setCertifications(attachedFileDataType);
            phsChecklist.setCertificationExplanation(certExplanation);
        }
        phsChecklistDocument.setPHS398Checklist(phsChecklist);
        return phsChecklistDocument;
    }

    private String getAnswer(String questionId) {
        String answer = null;
        if (this.answerHeaders != null && !this.answerHeaders.isEmpty()) {
            for (AnswerHeader answerHeader : this.answerHeaders) {
                List<Answer> answerDetails = answerHeader.getAnswers();
                for (Answer answers : answerDetails) {
                    if (!questionId.equals(answers.getQuestion().getQuestionId())) continue;
                    answer = answers.getAnswer();
                    return answer;
                }
            }
        }
        return answer;
    }

    private void setProjectIncome(PHS398ChecklistDocument.PHS398Checklist phsChecklist, Budget budget) {
        TreeMap<Integer, PHS398ChecklistDocument.PHS398Checklist.IncomeBudgetPeriod> incomeBudgetPeriodMap = new TreeMap<Integer, PHS398ChecklistDocument.PHS398Checklist.IncomeBudgetPeriod>();
        for (BudgetProjectIncome projectIncome : budget.getBudgetProjectIncomes()) {
            BigDecimal anticipatedAmount;
            Integer budgetPeriodNumber = projectIncome.getBudgetPeriodNumber();
            PHS398ChecklistDocument.PHS398Checklist.IncomeBudgetPeriod incomeBudgPeriod = (PHS398ChecklistDocument.PHS398Checklist.IncomeBudgetPeriod)incomeBudgetPeriodMap.get(budgetPeriodNumber);
            if (incomeBudgPeriod == null) {
                incomeBudgPeriod = PHS398ChecklistDocument.PHS398Checklist.IncomeBudgetPeriod.Factory.newInstance();
                incomeBudgPeriod.setBudgetPeriod(budgetPeriodNumber.intValue());
                anticipatedAmount = BigDecimal.ZERO;
            } else {
                anticipatedAmount = incomeBudgPeriod.getAnticipatedAmount();
            }
            anticipatedAmount = anticipatedAmount.add(projectIncome.getProjectIncome().bigDecimalValue());
            incomeBudgPeriod.setAnticipatedAmount(anticipatedAmount);
            String description = this.getProjectIncomeDescription(projectIncome);
            if (description != null) {
                if (incomeBudgPeriod.getSource() != null) {
                    incomeBudgPeriod.setSource(incomeBudgPeriod.getSource() + ";" + description);
                } else {
                    incomeBudgPeriod.setSource(description);
                }
            }
            incomeBudgetPeriodMap.put(budgetPeriodNumber, incomeBudgPeriod);
        }
        Collection incomeBudgetPeriodCollection = incomeBudgetPeriodMap.values();
        phsChecklist.setIncomeBudgetPeriodArray(incomeBudgetPeriodCollection.toArray(new PHS398ChecklistDocument.PHS398Checklist.IncomeBudgetPeriod[0]));
    }

    protected String getProjectIncomeDescription(BudgetProjectIncome projectIncome) {
        String description = null;
        if (projectIncome.getDescription() != null) {
            description = projectIncome.getDescription().length() > 150 ? projectIncome.getDescription().substring(0, 150) : projectIncome.getDescription();
        }
        return description;
    }

    @Override
    public XmlObject getFormObject(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getPHS398Checklist();
    }

    public XmlObject getFormObject(XmlObject xmlObject) {
        PHS398ChecklistDocument.PHS398Checklist phsChecklist = (PHS398ChecklistDocument.PHS398Checklist)xmlObject;
        PHS398ChecklistDocument phsChecklistDocument = PHS398ChecklistDocument.Factory.newInstance();
        phsChecklistDocument.setPHS398Checklist(phsChecklist);
        return phsChecklistDocument;
    }
}

