/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.forms.phs398Checklist13V13.PHS398Checklist13Document;
import gov.grants.apply.system.globalLibraryV20.HumanNameDataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.budget.distributionincome.BudgetProjectIncome;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.questionnaire.answer.Answer;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.s2s.generator.impl.PHS398ChecklistBaseGenerator;
import org.kuali.rice.krad.service.BusinessObjectService;

public class PHS398ChecklistV1_3Generator
extends PHS398ChecklistBaseGenerator {
    private static final int ZERO = 0;
    private static final String YNQANSWER_121 = "121";
    private static final Log LOG = LogFactory.getLog(PHS398ChecklistV1_3Generator.class);
    List<AnswerHeader> answerHeaders;
    YesNoDataType.Enum ynqAnswer;

    private PHS398Checklist13Document getPHS398Checklist() {
        PHS398Checklist13Document phsChecklistDocument = PHS398Checklist13Document.Factory.newInstance();
        PHS398Checklist13Document.PHS398Checklist13 phsChecklist = PHS398Checklist13Document.PHS398Checklist13.Factory.newInstance();
        this.answerHeaders = this.getQuestionnaireAnswers(this.pdDoc.getDevelopmentProposal(), true);
        this.setPhsCheckListBasicProperties(phsChecklist);
        this.setFormerPDNameAndIsChangeOfPDPI(phsChecklist);
        this.setFormerInstitutionNameAndChangeOfInstitution(phsChecklist);
        this.setIsInventionsAndPatentsAndIsPreviouslyReported(phsChecklist);
        BudgetDocument budgetDoc = null;
        try {
            budgetDoc = this.s2sBudgetCalculatorService.getFinalBudgetVersion(this.pdDoc);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        if (budgetDoc != null && budgetDoc.getBudget() != null) {
            int numPeriods = budgetDoc.getBudget().getBudgetPeriods().size();
            PHS398ChecklistV1_3Generator.setIncomeBudgetPeriods(phsChecklist, budgetDoc.getBudget().getBudgetProjectIncomes(), numPeriods);
        } else {
            phsChecklist.setProgramIncome(YesNoDataType.N_NO);
        }
        this.ynqAnswer = this.getYNQAnswer(YNQANSWER_121);
        phsChecklist.setDisclosurePermission(this.ynqAnswer);
        phsChecklistDocument.setPHS398Checklist13(phsChecklist);
        return phsChecklistDocument;
    }

    private void setPhsCheckListBasicProperties(PHS398Checklist13Document.PHS398Checklist13 phsChecklist) {
        phsChecklist.setFormVersion("1.3");
        DevelopmentProposal developmentProposal = this.pdDoc.getDevelopmentProposal();
        PHS398Checklist13Document.PHS398Checklist13.ApplicationType.Enum applicationEnum = null;
        if (developmentProposal.getProposalTypeCode() != null && Integer.parseInt(developmentProposal.getProposalTypeCode()) < 6) {
            applicationEnum = PHS398Checklist13Document.PHS398Checklist13.ApplicationType.Enum.forInt((int)Integer.valueOf(developmentProposal.getProposalTypeCode()));
        }
        phsChecklist.setApplicationType(applicationEnum);
        String federalId = this.s2sUtilService.getFederalId(this.pdDoc);
        if (federalId != null) {
            phsChecklist.setFederalID(federalId);
        }
    }

    private static void setIncomeBudgetPeriods(PHS398Checklist13Document.PHS398Checklist13 phsChecklist, List<BudgetProjectIncome> projectIncomes, int numPeriods) {
        if (projectIncomes.isEmpty()) {
            phsChecklist.setProgramIncome(YesNoDataType.N_NO);
        } else {
            phsChecklist.setProgramIncome(YesNoDataType.Y_YES);
        }
        phsChecklist.setIncomeBudgetPeriodArray(PHS398ChecklistV1_3Generator.getIncomeBudgetPeriod(projectIncomes));
    }

    private static PHS398Checklist13Document.PHS398Checklist13.IncomeBudgetPeriod[] getIncomeBudgetPeriod(List<BudgetProjectIncome> projectIncomes) {
        TreeMap<Integer, PHS398Checklist13Document.PHS398Checklist13.IncomeBudgetPeriod> incomeBudgetPeriodMap = new TreeMap<Integer, PHS398Checklist13Document.PHS398Checklist13.IncomeBudgetPeriod>();
        for (BudgetProjectIncome projectIncome : projectIncomes) {
            BigDecimal anticipatedAmount;
            Integer budgetPeriodNumber = projectIncome.getBudgetPeriodNumber();
            PHS398Checklist13Document.PHS398Checklist13.IncomeBudgetPeriod incomeBudgPeriod = (PHS398Checklist13Document.PHS398Checklist13.IncomeBudgetPeriod)incomeBudgetPeriodMap.get(budgetPeriodNumber);
            if (incomeBudgPeriod == null) {
                incomeBudgPeriod = PHS398Checklist13Document.PHS398Checklist13.IncomeBudgetPeriod.Factory.newInstance();
                incomeBudgPeriod.setBudgetPeriod(budgetPeriodNumber.intValue());
                anticipatedAmount = BigDecimal.ZERO;
            } else {
                anticipatedAmount = incomeBudgPeriod.getAnticipatedAmount();
            }
            anticipatedAmount = anticipatedAmount.add(projectIncome.getProjectIncome().bigDecimalValue());
            incomeBudgPeriod.setAnticipatedAmount(anticipatedAmount);
            String description = PHS398ChecklistV1_3Generator.getProjectIncomeDescription(projectIncome);
            if (description != null) {
                if (incomeBudgPeriod.getSource() != null) {
                    incomeBudgPeriod.setSource(incomeBudgPeriod.getSource() + ";" + description);
                } else {
                    incomeBudgPeriod.setSource(description);
                }
            }
            incomeBudgetPeriodMap.put(budgetPeriodNumber, incomeBudgPeriod);
        }
        Collection incomeBudgetPeriodCollection = incomeBudgetPeriodMap.values();
        return incomeBudgetPeriodCollection.toArray(new PHS398Checklist13Document.PHS398Checklist13.IncomeBudgetPeriod[0]);
    }

    protected static String getProjectIncomeDescription(BudgetProjectIncome projectIncome) {
        String description = null;
        if (projectIncome.getDescription() != null) {
            description = projectIncome.getDescription().length() > 150 ? projectIncome.getDescription().substring(0, 150) : projectIncome.getDescription();
        }
        return description;
    }

    private void setIsInventionsAndPatentsAndIsPreviouslyReported(PHS398Checklist13Document.PHS398Checklist13 phsChecklist) {
        String answer = this.getAnswer("118");
        if (answer != null && !answer.equals("No") && "Y".equals(answer)) {
            String explanation = this.getAnswer("119");
            if (explanation != null && !explanation.equals("No")) {
                if ("Y".equals(explanation)) {
                    phsChecklist.setIsInventionsAndPatents(YesNoDataType.Y_YES);
                    String subQuestionExplanation = this.getAnswer("120");
                    if (subQuestionExplanation != null && !subQuestionExplanation.equals("No")) {
                        if ("Y".equals(subQuestionExplanation)) {
                            phsChecklist.setIsPreviouslyReported(YesNoDataType.Y_YES);
                        } else if ("N".equals(subQuestionExplanation)) {
                            phsChecklist.setIsPreviouslyReported(YesNoDataType.N_NO);
                        }
                    } else {
                        phsChecklist.setIsPreviouslyReported(null);
                    }
                } else if ("N".equals(explanation)) {
                    phsChecklist.setIsInventionsAndPatents(YesNoDataType.N_NO);
                }
            } else {
                phsChecklist.setIsInventionsAndPatents(null);
            }
        }
    }

    private void setFormerInstitutionNameAndChangeOfInstitution(PHS398Checklist13Document.PHS398Checklist13 phsChecklist) {
        String answer = this.getAnswer("116");
        String explanation = this.getAnswer("117");
        if ("Y".equals(answer)) {
            phsChecklist.setIsChangeOfInstitution(YesNoDataType.Y_YES);
            if (explanation != null) {
                phsChecklist.setFormerInstitutionName(explanation);
            } else {
                phsChecklist.setFormerInstitutionName(null);
            }
        } else {
            phsChecklist.setIsChangeOfInstitution(YesNoDataType.N_NO);
        }
    }

    private void setFormerPDNameAndIsChangeOfPDPI(PHS398Checklist13Document.PHS398Checklist13 phsChecklist) {
        String answer = this.getAnswer("114");
        String explanation = this.getAnswer("115");
        if ("Y".equals(answer)) {
            phsChecklist.setIsChangeOfPDPI(YesNoDataType.Y_YES);
            if (explanation != null) {
                BusinessObjectService businessObjectService = KraServiceLocator.getService(BusinessObjectService.class);
                Rolodex rolodex = (Rolodex)businessObjectService.findBySinglePrimaryKey(Rolodex.class, (Object)explanation);
                HumanNameDataType formerPDName = this.globLibV20Generator.getHumanNameDataType(rolodex);
                if (formerPDName != null && formerPDName.getFirstName() != null && formerPDName.getLastName() != null) {
                    phsChecklist.setFormerPDName(formerPDName);
                }
            } else {
                phsChecklist.setFormerPDName(null);
            }
        } else {
            phsChecklist.setIsChangeOfPDPI(YesNoDataType.N_NO);
        }
    }

    private YesNoDataType.Enum getYNQAnswer(String questionID) {
        YesNoDataType.Enum answerType = null;
        String answer = this.getAnswer(questionID);
        if (answer != null && !answer.equals("No")) {
            answerType = "Y".equals(answer) ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
            return answerType;
        }
        return null;
    }

    private String getAnswer(String questionId) {
        String answer = null;
        if (this.answerHeaders != null && !this.answerHeaders.isEmpty()) {
            for (AnswerHeader answerHeader : this.answerHeaders) {
                List<Answer> answerDetails = answerHeader.getAnswers();
                for (Answer answers : answerDetails) {
                    if (!questionId.equals(answers.getQuestion().getQuestionId())) continue;
                    answer = answers.getAnswer();
                    return answer;
                }
            }
        }
        return answer;
    }

    @Override
    public XmlObject getFormObject(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getPHS398Checklist();
    }

    public XmlObject getFormObject(XmlObject xmlObject) {
        PHS398Checklist13Document.PHS398Checklist13 phsChecklist = (PHS398Checklist13Document.PHS398Checklist13)xmlObject;
        PHS398Checklist13Document phsChecklistDocument = PHS398Checklist13Document.Factory.newInstance();
        phsChecklistDocument.setPHS398Checklist13(phsChecklist);
        return phsChecklistDocument;
    }
}

