/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.forms.phs398CoverPageSupplementV10.PHS398CoverPageSupplementDocument;
import gov.grants.apply.system.globalLibraryV10.YesNoDataType;
import java.util.List;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonDegree;
import org.kuali.kra.proposaldevelopment.bo.ProposalYnq;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.questionnaire.answer.Answer;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.s2s.generator.bo.DepartmentalPerson;
import org.kuali.kra.s2s.generator.impl.PHS398CoverPageSupplementBaseGenerator;

public class PHS398CoverPageSupplementV1_0Generator
extends PHS398CoverPageSupplementBaseGenerator {
    List<AnswerHeader> answerHeaders;

    private PHS398CoverPageSupplementDocument getCoverPageSupplement() {
        PHS398CoverPageSupplementDocument coverPageSupplementDocument = PHS398CoverPageSupplementDocument.Factory.newInstance();
        PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement coverPageSupplement = PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.Factory.newInstance();
        this.answerHeaders = this.getQuestionnaireAnswers(this.pdDoc.getDevelopmentProposal(), true);
        coverPageSupplement.setFormVersion("1.0");
        coverPageSupplement.setPDPI(this.getPDPI());
        coverPageSupplement.setClinicalTrial(this.getClinicalTrial());
        coverPageSupplement.setContactPersonInfo(this.getContactPersonInfo(this.pdDoc));
        PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.StemCells stemCells = this.getStemCells();
        coverPageSupplement.setStemCells(stemCells);
        coverPageSupplementDocument.setPHS398CoverPageSupplement(coverPageSupplement);
        return coverPageSupplementDocument;
    }

    private PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.PDPI getPDPI() {
        PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.PDPI pdpi = PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.PDPI.Factory.newInstance();
        ProposalPerson PI = this.s2sUtilService.getPrincipalInvestigator(this.pdDoc);
        pdpi.setPDPIName(this.globLibV10Generator.getHumanNameDataType(PI));
        pdpi.setIsNewInvestigator(YesNoDataType.NO);
        if (PI != null) {
            ProposalYnq proposalYnq = this.getProposalYnQ("13");
            if (proposalYnq != null) {
                YesNoDataType.Enum answer = null;
                if (proposalYnq.getAnswer() != null) {
                    answer = proposalYnq.getAnswer().equals("Y") ? YesNoDataType.YES : YesNoDataType.NO;
                    pdpi.setIsNewInvestigator(answer);
                }
            }
            String[] degreeArr = null;
            if (PI.getProposalPersonDegrees() != null) {
                degreeArr = new String[PI.getProposalPersonDegrees().size()];
            }
            int size = 0;
            for (ProposalPersonDegree personDegree : PI.getProposalPersonDegrees()) {
                if (size > 3) break;
                if (personDegree.getDegree() == null) continue;
                degreeArr[size] = personDegree.getDegree().length() > 10 ? personDegree.getDegree().substring(0, 10) : personDegree.getDegree();
                ++size;
            }
            pdpi.setDegreesArray(degreeArr);
        }
        return pdpi;
    }

    private PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.ClinicalTrial getClinicalTrial() {
        PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.ClinicalTrial clinicalTrial = PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.ClinicalTrial.Factory.newInstance();
        String answer = null;
        String subAnswer = null;
        answer = this.getAnswer("2");
        if (answer != null && !answer.equals("No")) {
            if ("Y".equals(answer)) {
                clinicalTrial.setIsClinicalTrial(YesNoDataType.YES);
                subAnswer = this.getAnswer("3");
                if (subAnswer != null && !subAnswer.equals("No")) {
                    if ("Y".equals(subAnswer)) {
                        clinicalTrial.setIsPhaseIIIClinicalTrial(YesNoDataType.YES);
                    } else {
                        clinicalTrial.setIsPhaseIIIClinicalTrial(YesNoDataType.NO);
                    }
                }
            } else {
                clinicalTrial.setIsClinicalTrial(YesNoDataType.NO);
            }
        }
        return clinicalTrial;
    }

    private PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.ContactPersonInfo getContactPersonInfo(ProposalDevelopmentDocument pdDoc) {
        PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.ContactPersonInfo contactPersonInfo = PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.ContactPersonInfo.Factory.newInstance();
        DepartmentalPerson contactPerson = this.s2sUtilService.getContactPerson(pdDoc);
        if (contactPerson != null) {
            contactPersonInfo.setContactName(this.globLibV10Generator.getHumanNameDataType(contactPerson));
            contactPersonInfo.setContactPhone(contactPerson.getOfficePhone());
            if (contactPerson.getFaxNumber() != null && !contactPerson.getFaxNumber().equals("")) {
                contactPersonInfo.setContactFax(contactPerson.getFaxNumber());
            }
            if (contactPerson.getEmailAddress() != null && !contactPerson.getEmailAddress().equals("")) {
                contactPersonInfo.setContactEmail(contactPerson.getEmailAddress());
            }
            contactPersonInfo.setContactTitle(contactPerson.getPrimaryTitle());
            contactPersonInfo.setContactAddress(this.globLibV10Generator.getAddressRequireCountryDataType(contactPerson));
        }
        return contactPersonInfo;
    }

    private PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.StemCells getStemCells() {
        PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.StemCells stemCells = PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.StemCells.Factory.newInstance();
        YesNoDataType.Enum answers = YesNoDataType.NO;
        String childAnswer = null;
        String answer = this.getAnswer("5");
        if (answer != null && !answer.equals("No")) {
            YesNoDataType.Enum enum_ = answers = "Y".equals(this.getAnswer("5")) ? YesNoDataType.YES : YesNoDataType.NO;
            if ("Y".equals(answer)) {
                stemCells.setIsHumanStemCellsInvolved(YesNoDataType.YES);
                String subAnswer = this.getAnswer("6");
                if (subAnswer != null && !subAnswer.equals("No")) {
                    if ("Y".equals(subAnswer)) {
                        stemCells.setStemCellsIndicator(YesNoDataType.NO);
                        childAnswer = this.getAnswers("7");
                    } else {
                        stemCells.setStemCellsIndicator(YesNoDataType.YES);
                    }
                }
                if (childAnswer != null) {
                    if ("Unknown".equalsIgnoreCase(childAnswer)) {
                        stemCells.setStemCellsIndicator(answers);
                    } else {
                        List<String> cellLines = this.getCellLines(childAnswer);
                        if (cellLines.size() > 0) {
                            stemCells.setCellLinesArray(cellLines.toArray(new String[0]));
                        }
                    }
                }
            } else {
                stemCells.setIsHumanStemCellsInvolved(YesNoDataType.NO);
            }
        }
        return stemCells;
    }

    private String getAnswer(String questionId) {
        String answer = null;
        if (this.answerHeaders != null && !this.answerHeaders.isEmpty()) {
            for (AnswerHeader answerHeader : this.answerHeaders) {
                List<Answer> answerDetails = answerHeader.getAnswers();
                for (Answer answers : answerDetails) {
                    if (!questionId.equals(answers.getQuestion().getQuestionId())) continue;
                    answer = answers.getAnswer();
                }
            }
        }
        return answer;
    }

    private String getAnswers(String questionId) {
        String answer = null;
        String childAnswer = null;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.answerHeaders != null && !this.answerHeaders.isEmpty()) {
            for (AnswerHeader answerHeader : this.answerHeaders) {
                List<Answer> answerDetails = answerHeader.getAnswers();
                for (Answer answers : answerDetails) {
                    if (!questionId.equals(answers.getQuestion().getQuestionId())) continue;
                    answer = answers.getAnswer();
                    if (answer != null && !answer.equals("No")) {
                        stringBuilder.append(answer);
                        stringBuilder.append(",");
                    }
                    childAnswer = stringBuilder.toString();
                }
            }
        }
        return childAnswer;
    }

    @Override
    public XmlObject getFormObject(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getCoverPageSupplement();
    }

    public XmlObject getFormObject(XmlObject xmlObject) {
        PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement phsCoverPageSupplement = (PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement)xmlObject;
        PHS398CoverPageSupplementDocument phsCoverPageSupplementDocument = PHS398CoverPageSupplementDocument.Factory.newInstance();
        phsCoverPageSupplementDocument.setPHS398CoverPageSupplement(phsCoverPageSupplement);
        return phsCoverPageSupplementDocument;
    }
}

