/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.forms.phs398CoverPageSupplementV11.PHS398CoverPageSupplementDocument;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.util.List;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonDegree;
import org.kuali.kra.proposaldevelopment.bo.ProposalYnq;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.questionnaire.answer.Answer;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.s2s.generator.bo.DepartmentalPerson;
import org.kuali.kra.s2s.generator.impl.PHS398CoverPageSupplementBaseGenerator;
import org.kuali.kra.s2s.service.S2SUtilService;

public class PHS398CoverPageSupplementV1_1Generator
extends PHS398CoverPageSupplementBaseGenerator {
    List<AnswerHeader> answerHeaders;
    private static final String OSP_ADMINISTRATOR = "2";

    public PHS398CoverPageSupplementV1_1Generator() {
        this.s2sUtilService = KraServiceLocator.getService(S2SUtilService.class);
    }

    private PHS398CoverPageSupplementDocument getCoverPageSupplement() {
        PHS398CoverPageSupplementDocument coverPageSupplementDocument = PHS398CoverPageSupplementDocument.Factory.newInstance();
        PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement coverPageSupplement = PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.Factory.newInstance();
        this.answerHeaders = this.getQuestionnaireAnswers(this.pdDoc.getDevelopmentProposal(), true);
        coverPageSupplement.setFormVersion("1.1");
        coverPageSupplement.setPDPI(this.getPDPI());
        coverPageSupplement.setClinicalTrial(this.getClinicalTrial());
        coverPageSupplement.setContactPersonInfo(this.getContactPersonInfo());
        PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.StemCells stemCells = this.getStemCells();
        coverPageSupplement.setStemCells(stemCells);
        coverPageSupplementDocument.setPHS398CoverPageSupplement(coverPageSupplement);
        return coverPageSupplementDocument;
    }

    private PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.PDPI getPDPI() {
        PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.PDPI pdpi = PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.PDPI.Factory.newInstance();
        ProposalPerson PI = this.s2sUtilService.getPrincipalInvestigator(this.pdDoc);
        pdpi.setPDPIName(this.globLibV20Generator.getHumanNameDataType(PI));
        pdpi.setIsNewInvestigator(YesNoDataType.N_NO);
        ProposalYnq proposalYnq = this.getProposalYnQ("13");
        if (PI != null) {
            if (proposalYnq != null) {
                YesNoDataType.Enum answer = null;
                if (proposalYnq.getAnswer() != null) {
                    answer = proposalYnq.getAnswer().equals("Y") ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
                    pdpi.setIsNewInvestigator(answer);
                }
            }
            String[] degreeArr = null;
            if (PI.getProposalPersonDegrees() != null) {
                degreeArr = new String[PI.getProposalPersonDegrees().size()];
            }
            int size = 0;
            for (ProposalPersonDegree personDegree : PI.getProposalPersonDegrees()) {
                if (size > 3) break;
                if (personDegree.getDegree() == null) continue;
                degreeArr[size] = personDegree.getDegree().length() > 10 ? personDegree.getDegree().substring(0, 10) : personDegree.getDegree();
                ++size;
            }
            pdpi.setDegreesArray(degreeArr);
        }
        return pdpi;
    }

    private PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.ClinicalTrial getClinicalTrial() {
        PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.ClinicalTrial clinicalTrial = PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.ClinicalTrial.Factory.newInstance();
        String answer = null;
        String subAnswer = null;
        answer = this.getAnswer(OSP_ADMINISTRATOR);
        if (answer != null && !answer.equals("No")) {
            if ("Y".equals(answer)) {
                clinicalTrial.setIsClinicalTrial(YesNoDataType.Y_YES);
                subAnswer = this.getAnswer("3");
                if (subAnswer != null && !subAnswer.equals("No")) {
                    if ("Y".equals(subAnswer)) {
                        clinicalTrial.setIsPhaseIIIClinicalTrial(YesNoDataType.Y_YES);
                    } else {
                        clinicalTrial.setIsPhaseIIIClinicalTrial(YesNoDataType.N_NO);
                    }
                }
            } else {
                clinicalTrial.setIsClinicalTrial(YesNoDataType.N_NO);
            }
        }
        return clinicalTrial;
    }

    private PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.ContactPersonInfo getContactPersonInfo() {
        PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.ContactPersonInfo contactPersonInfo = PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.ContactPersonInfo.Factory.newInstance();
        DepartmentalPerson person = this.s2sUtilService.getContactPerson(this.pdDoc);
        contactPersonInfo.setContactName(this.globLibV20Generator.getHumanNameDataType(person));
        contactPersonInfo.setContactPhone(person.getOfficePhone());
        if (person.getFaxNumber() != null && !person.getFaxNumber().equals("")) {
            contactPersonInfo.setContactFax(person.getFaxNumber());
        }
        if (person.getEmailAddress() != null && !person.getEmailAddress().equals("")) {
            contactPersonInfo.setContactEmail(person.getEmailAddress());
        }
        contactPersonInfo.setContactTitle(person.getPrimaryTitle());
        contactPersonInfo.setContactAddress(this.globLibV20Generator.getAddressDataType(person));
        return contactPersonInfo;
    }

    private PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.StemCells getStemCells() {
        PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.StemCells stemCells = PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.StemCells.Factory.newInstance();
        YesNoDataType.Enum answers = YesNoDataType.N_NO;
        String childAnswer = null;
        String answer = this.getAnswer("5");
        if (answer != null && !answer.equals("No")) {
            YesNoDataType.Enum enum_ = answers = "Y".equals(this.getAnswer("5")) ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
            if ("Y".equals(answer)) {
                stemCells.setIsHumanStemCellsInvolved(YesNoDataType.Y_YES);
                String subAnswer = this.getAnswer("6");
                if (subAnswer != null && !subAnswer.equals("No")) {
                    if ("Y".equals(subAnswer)) {
                        stemCells.setStemCellsIndicator(YesNoDataType.N_NO);
                        childAnswer = this.getAnswers("7");
                    } else {
                        stemCells.setStemCellsIndicator(YesNoDataType.Y_YES);
                    }
                }
                if (childAnswer != null) {
                    if ("Unknown".equalsIgnoreCase(childAnswer)) {
                        stemCells.setStemCellsIndicator(answers);
                    } else {
                        List<String> cellLines = this.getCellLines(childAnswer);
                        if (cellLines.size() > 0) {
                            stemCells.setCellLinesArray(cellLines.toArray(new String[0]));
                        }
                    }
                }
            } else {
                stemCells.setIsHumanStemCellsInvolved(YesNoDataType.N_NO);
            }
        }
        return stemCells;
    }

    private String getAnswer(String questionId) {
        String answer = null;
        if (this.answerHeaders != null && !this.answerHeaders.isEmpty()) {
            for (AnswerHeader answerHeader : this.answerHeaders) {
                List<Answer> answerDetails = answerHeader.getAnswers();
                for (Answer answers : answerDetails) {
                    if (!questionId.equals(answers.getQuestion().getQuestionId())) continue;
                    answer = answers.getAnswer();
                }
            }
        }
        return answer;
    }

    private String getAnswers(String questionId) {
        String answer = null;
        String childAnswer = null;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.answerHeaders != null && !this.answerHeaders.isEmpty()) {
            for (AnswerHeader answerHeader : this.answerHeaders) {
                List<Answer> answerDetails = answerHeader.getAnswers();
                for (Answer answers : answerDetails) {
                    if (!questionId.equals(answers.getQuestion().getQuestionId())) continue;
                    answer = answers.getAnswer();
                    if (answer != null && !answer.equals("No")) {
                        stringBuilder.append(answer);
                        stringBuilder.append(",");
                    }
                    childAnswer = stringBuilder.toString();
                }
            }
        }
        return childAnswer;
    }

    @Override
    public XmlObject getFormObject(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getCoverPageSupplement();
    }

    public XmlObject getFormObject(XmlObject xmlObject) {
        PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement coverPageSupplement = (PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement)xmlObject;
        PHS398CoverPageSupplementDocument coverPageSupplementDocument = PHS398CoverPageSupplementDocument.Factory.newInstance();
        coverPageSupplementDocument.setPHS398CoverPageSupplement(coverPageSupplement);
        return coverPageSupplementDocument;
    }
}

