/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.forms.phsFellowshipSupplemental11V11.CitizenshipDataType;
import gov.grants.apply.forms.phsFellowshipSupplemental11V11.DegreeTypeDataType;
import gov.grants.apply.forms.phsFellowshipSupplemental11V11.FieldOfTrainingDataType;
import gov.grants.apply.forms.phsFellowshipSupplemental11V11.PHSFellowshipSupplemental11Document;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.attachmentsV10.AttachmentGroupMin0Max100DataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.io.ByteArrayInputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.infrastructure.CitizenshipTypes;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.ProposalDevelopmentUtils;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.service.ProposalDevelopmentS2sQuestionnaireService;
import org.kuali.kra.proposaldevelopment.specialreview.ProposalSpecialReview;
import org.kuali.kra.questionnaire.Questionnaire;
import org.kuali.kra.questionnaire.QuestionnaireQuestion;
import org.kuali.kra.questionnaire.answer.Answer;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.questionnaire.question.Question;
import org.kuali.kra.s2s.S2SException;
import org.kuali.kra.s2s.generator.impl.PHS398FellowshipSupplementalBaseGenerator;

public class PHS398FellowshipSupplementalV1_1Generator
extends PHS398FellowshipSupplementalBaseGenerator {
    private static final Log LOG = LogFactory.getLog(PHS398FellowshipSupplementalV1_1Generator.class);
    private static final int HUMAN = 1;
    private static final int VERT = 4;
    private static final int CLINICAL = 2;
    private static final int PHASE3CLINICAL = 3;
    private static final int STEMCELLS = 5;
    private static final int KIRST_START_KNOWN = 43;
    private static final int KIRST_END_KNOWN = 49;
    private static final int KIRST_START_DT = 44;
    private static final int KIRST_END_DT = 45;
    private static final int KIRST_GRANT_KNOWN = 46;
    private static final int KIRST_GRANT_NUM = 27;
    private static final int PRE_OR_POST = 32;
    private static final int IND_OR_INST = 33;
    private static final int STEMCELLLINES = 7;
    private static final int CELLLINEIND = 6;
    private static final int DEGREE_TYPE_SOUGHT = 15;
    private static final int DEG_EXP_COMP_DATE = 35;
    private static final int NRSA_SUPPORT = 24;
    private static final int FIELD_TRAINING = 22;
    private static final int BROAD_TRAINING = 23;
    private static final int OTHER_MASTERS = 16;
    private static final int OTHER_DOCT = 17;
    private static final int OTHER_DDOT = 18;
    private static final int OTHER_VDOT = 19;
    private static final int OTHER_DBOTH = 20;
    private static final int OTHER_MDOT = 21;
    private static final int SUBMITTED_DIFF_INST = 28;
    private static final int FORMER_INST = 29;
    private static final int SENIOR_FELL = 36;
    private static final int OTHER_SUPP_SOURCE = 37;
    private static final int SUPP_FUNDING_AMT = 38;
    private static final int SUPP_MONTHS = 51;
    private static final int SUPP_SOURCE = 41;
    private static final int SUPP_TYPE = 40;
    private static final int SALARY_MONTH = 50;
    private static final int ACAD_PERIOD = 48;
    private static final int BASE_SALARY = 47;
    private static final int APPENDIX = 96;

    private PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11 getPHSFellowshipSupplemental11() {
        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11 phsFellowshipSupplemental = PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.Factory.newInstance();
        phsFellowshipSupplemental.setFormVersion("1.1");
        phsFellowshipSupplemental.setApplicationType(this.getApplicationType());
        phsFellowshipSupplemental.setAppendix(this.getAppendix());
        phsFellowshipSupplemental.setAdditionalInformation(this.getAdditionalInformation());
        phsFellowshipSupplemental.setResearchTrainingPlan(this.getResearchTrainingPlan());
        phsFellowshipSupplemental.setBudget(this.getBudget());
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(phsFellowshipSupplemental.toString().getBytes());
        this.sortAttachments(byteArrayInputStream);
        return phsFellowshipSupplemental;
    }

    private PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.Budget getBudget() {
        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.Budget budget = PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.Budget.Factory.newInstance();
        HashMap<Integer, String> budgetMap = new HashMap<Integer, String>();
        for (Answer questionnaireAnswer : this.s2sUtilService.getQuestionnaireAnswers(this.pdDoc.getDevelopmentProposal(), this.getNamespace(), this.getFormName())) {
            String answer = questionnaireAnswer.getAnswer();
            if (answer == null) continue;
            switch (questionnaireAnswer.getQuestion().getQuestionIdAsInteger()) {
                case 36: {
                    budgetMap.put(36, answer);
                    break;
                }
                case 37: {
                    budgetMap.put(37, answer);
                    break;
                }
                case 41: {
                    budgetMap.put(41, answer);
                    break;
                }
                case 38: {
                    budgetMap.put(38, answer);
                    break;
                }
                case 51: {
                    budgetMap.put(51, answer);
                    break;
                }
                case 40: {
                    budgetMap.put(40, answer);
                    break;
                }
                case 50: {
                    budgetMap.put(50, answer);
                    break;
                }
                case 48: {
                    budgetMap.put(48, answer);
                    break;
                }
                case 47: {
                    budgetMap.put(47, answer);
                    break;
                }
            }
        }
        budget.setTuitionAndFeesRequested(YesNoDataType.N_NO);
        if (this.getInstitutionalBaseSalary(budgetMap) != null) {
            budget.setInstitutionalBaseSalary(this.getInstitutionalBaseSalary(budgetMap));
        }
        budget.setFederalStipendRequested(this.getFederalStipendRequested());
        if (this.getSupplementationFromOtherSources(budgetMap) != null) {
            budget.setSupplementationFromOtherSources(this.getSupplementationFromOtherSources(budgetMap));
        }
        this.setTutionRequestedYears(budget);
        return budget;
    }

    private void setTutionRequestedYears(PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.Budget budget) {
        BudgetDocument budgetDoc = this.getBudgetDocument();
        if (budgetDoc == null) {
            return;
        }
        BudgetDecimal tutionTotal = BudgetDecimal.ZERO;
        for (BudgetPeriod budgetPeriod : budgetDoc.getBudget().getBudgetPeriods()) {
            BudgetDecimal tution = BudgetDecimal.ZERO;
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                if (!this.getCostElementsByParam("TUITION_COST_ELEMENTS").contains(budgetLineItem.getCostElementBO().getCostElement())) continue;
                tution = (BudgetDecimal)tution.add(budgetLineItem.getLineItemCost());
            }
            tutionTotal = (BudgetDecimal)tutionTotal.add(tution);
            switch (budgetPeriod.getBudgetPeriod()) {
                case 1: {
                    budget.setTuitionRequestedYear1(tution.bigDecimalValue());
                    break;
                }
                case 2: {
                    budget.setTuitionRequestedYear2(tution.bigDecimalValue());
                    break;
                }
                case 3: {
                    budget.setTuitionRequestedYear3(tution.bigDecimalValue());
                    break;
                }
                case 4: {
                    budget.setTuitionRequestedYear4(tution.bigDecimalValue());
                    break;
                }
                case 5: {
                    budget.setTuitionRequestedYear5(tution.bigDecimalValue());
                    break;
                }
                case 6: {
                    budget.setTuitionRequestedYear6(tution.bigDecimalValue());
                    break;
                }
            }
        }
        budget.setTuitionRequestedTotal(tutionTotal.bigDecimalValue());
        if (!tutionTotal.equals((Object)BudgetDecimal.ZERO)) {
            budget.setTuitionAndFeesRequested(YesNoDataType.Y_YES);
        }
    }

    private PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.Budget.SupplementationFromOtherSources getSupplementationFromOtherSources(Map<Integer, String> budgetMap) {
        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.Budget.SupplementationFromOtherSources supplementationFromOtherSources = null;
        if (budgetMap.get(37) != null && budgetMap.get(37).toString().equals("Y")) {
            supplementationFromOtherSources = PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.Budget.SupplementationFromOtherSources.Factory.newInstance();
            if (budgetMap.get(41) != null) {
                supplementationFromOtherSources.setSource(budgetMap.get(41).toString());
            }
            if (budgetMap.get(38) != null) {
                supplementationFromOtherSources.setAmount(new BigDecimal(budgetMap.get(38).toString()));
            } else {
                supplementationFromOtherSources.setAmount(null);
            }
            if (budgetMap.get(51) != null) {
                supplementationFromOtherSources.setNumberOfMonths(new BigDecimal(budgetMap.get(51).toString()));
            }
            if (budgetMap.get(40) != null) {
                supplementationFromOtherSources.setType(budgetMap.get(40).toString());
            }
        }
        return supplementationFromOtherSources;
    }

    private PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.Budget.FederalStipendRequested getFederalStipendRequested() {
        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.Budget.FederalStipendRequested federalStipendRequested = PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.Budget.FederalStipendRequested.Factory.newInstance();
        BudgetDocument budgetDoc = this.getBudgetDocument();
        if (budgetDoc == null) {
            return federalStipendRequested;
        }
        Budget budget = budgetDoc.getBudget();
        BudgetDecimal sumOfLineItemCost = BudgetDecimal.ZERO;
        BudgetDecimal numberOfMonths = BudgetDecimal.ZERO;
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            if (budgetPeriod.getBudgetPeriod() != 1) continue;
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                if (!this.getCostElementsByParam("STIPEND_COST_ELEMENTS").contains(budgetLineItem.getCostElementBO().getCostElement())) continue;
                sumOfLineItemCost = (BudgetDecimal)sumOfLineItemCost.add(budgetLineItem.getLineItemCost());
                numberOfMonths = (BudgetDecimal)numberOfMonths.add(this.getNumberOfMonths(budgetLineItem.getStartDate(), budgetLineItem.getEndDate()));
            }
        }
        federalStipendRequested.setAmount(sumOfLineItemCost.bigDecimalValue());
        federalStipendRequested.setNumberOfMonths(numberOfMonths.bigDecimalValue());
        return federalStipendRequested;
    }

    private BudgetDocument getBudgetDocument() {
        BudgetDocument budgetDoc = null;
        try {
            budgetDoc = this.s2SBudgetCalculatorService.getFinalBudgetVersion(this.pdDoc);
        }
        catch (S2SException e) {
            LOG.error((Object)"Error while getting Budget", (Throwable)e);
        }
        return budgetDoc;
    }

    private PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.Budget.InstitutionalBaseSalary getInstitutionalBaseSalary(Map<Integer, String> budgetMap) {
        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.Budget.InstitutionalBaseSalary institutionalBaseSalary = null;
        if (budgetMap.get(36) != null && budgetMap.get(36).toString().equals("Y")) {
            institutionalBaseSalary = PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.Budget.InstitutionalBaseSalary.Factory.newInstance();
            if (budgetMap.get(47) != null) {
                institutionalBaseSalary.setAmount(new BigDecimal(budgetMap.get(47).toString()));
            } else {
                institutionalBaseSalary.setAmount(null);
            }
            if (budgetMap.get(48) != null) {
                institutionalBaseSalary.setAcademicPeriod(PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.Budget.InstitutionalBaseSalary.AcademicPeriod.Enum.forString((String)budgetMap.get(48).toString()));
            }
            if (budgetMap.get(50) != null) {
                institutionalBaseSalary.setNumberOfMonths(new BigDecimal(budgetMap.get(50).toString()));
            }
        }
        return institutionalBaseSalary;
    }

    private PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan getResearchTrainingPlan() {
        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan researchTrainingPlan = PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.Factory.newInstance();
        this.setHumanSubjectInvolvedAndVertebrateAnimalUsed(researchTrainingPlan);
        this.setQuestionnareAnswerForResearchTrainingPlan(researchTrainingPlan);
        this.setNarrativeDataForResearchTrainingPlan(researchTrainingPlan);
        return researchTrainingPlan;
    }

    private void setNarrativeDataForResearchTrainingPlan(PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan researchTrainingPlan) {
        AttachedFileDataType attachedFileDataType = null;
        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.SpecificAims specificAims = PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.SpecificAims.Factory.newInstance();
        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.ResearchStrategy researchStrategy = PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.ResearchStrategy.Factory.newInstance();
        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.RespectiveContributions respectiveContributions = PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.RespectiveContributions.Factory.newInstance();
        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.SelectionOfSponsorAndInstitution selectionOfSponsorAndInstitution = PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.SelectionOfSponsorAndInstitution.Factory.newInstance();
        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.ResponsibleConductOfResearch responsibleConductOfResearch = PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.ResponsibleConductOfResearch.Factory.newInstance();
        for (Narrative narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeTypeCode() != null) {
                switch (Integer.parseInt(narrative.getNarrativeTypeCode())) {
                    case 97: {
                        attachedFileDataType = this.getAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.IntroductionToApplication introductionToApplication = PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.IntroductionToApplication.Factory.newInstance();
                        introductionToApplication.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setIntroductionToApplication(introductionToApplication);
                        break;
                    }
                    case 98: {
                        attachedFileDataType = this.getAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        specificAims.setAttFile(attachedFileDataType);
                        break;
                    }
                    case 102: {
                        attachedFileDataType = this.getAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.InclusionEnrollmentReport inclusionEnrollmentReport = PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.InclusionEnrollmentReport.Factory.newInstance();
                        inclusionEnrollmentReport.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setInclusionEnrollmentReport(inclusionEnrollmentReport);
                        break;
                    }
                    case 103: {
                        attachedFileDataType = this.getAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.ProgressReportPublicationList progressReportPublicationList = PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.ProgressReportPublicationList.Factory.newInstance();
                        progressReportPublicationList.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setProgressReportPublicationList(progressReportPublicationList);
                        break;
                    }
                    case 104: {
                        attachedFileDataType = this.getAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.ProtectionOfHumanSubjects protectionOfHumanSubjects = PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.ProtectionOfHumanSubjects.Factory.newInstance();
                        protectionOfHumanSubjects.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setProtectionOfHumanSubjects(protectionOfHumanSubjects);
                        break;
                    }
                    case 105: {
                        attachedFileDataType = this.getAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.InclusionOfWomenAndMinorities inclusionOfWomenAndMinorities = PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.InclusionOfWomenAndMinorities.Factory.newInstance();
                        inclusionOfWomenAndMinorities.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setInclusionOfWomenAndMinorities(inclusionOfWomenAndMinorities);
                        break;
                    }
                    case 106: {
                        attachedFileDataType = this.getAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.TargetedPlannedEnrollment tarPlannedEnrollmentTable = PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.TargetedPlannedEnrollment.Factory.newInstance();
                        tarPlannedEnrollmentTable.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setTargetedPlannedEnrollment(tarPlannedEnrollmentTable);
                        break;
                    }
                    case 107: {
                        attachedFileDataType = this.getAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.InclusionOfChildren inclusionOfChildren = PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.InclusionOfChildren.Factory.newInstance();
                        inclusionOfChildren.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setInclusionOfChildren(inclusionOfChildren);
                        break;
                    }
                    case 108: {
                        attachedFileDataType = this.getAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.VertebrateAnimals vertebrateAnimals = PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.VertebrateAnimals.Factory.newInstance();
                        vertebrateAnimals.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setVertebrateAnimals(vertebrateAnimals);
                        break;
                    }
                    case 109: {
                        attachedFileDataType = this.getAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.SelectAgentResearch selectAgentResearch = PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.SelectAgentResearch.Factory.newInstance();
                        selectAgentResearch.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setSelectAgentResearch(selectAgentResearch);
                        break;
                    }
                    case 110: {
                        attachedFileDataType = this.getAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.ResourceSharingPlan resourceSharingPlan = PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan.ResourceSharingPlan.Factory.newInstance();
                        resourceSharingPlan.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setResourceSharingPlan(resourceSharingPlan);
                        break;
                    }
                    case 88: {
                        attachedFileDataType = this.getAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        respectiveContributions.setAttFile(attachedFileDataType);
                        break;
                    }
                    case 89: {
                        attachedFileDataType = this.getAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        selectionOfSponsorAndInstitution.setAttFile(attachedFileDataType);
                        break;
                    }
                    case 90: {
                        attachedFileDataType = this.getAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        responsibleConductOfResearch.setAttFile(attachedFileDataType);
                        break;
                    }
                    case 127: {
                        attachedFileDataType = this.getAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        researchStrategy.setAttFile(attachedFileDataType);
                        break;
                    }
                }
            }
        }
        researchTrainingPlan.setSpecificAims(specificAims);
        researchTrainingPlan.setResearchStrategy(researchStrategy);
        researchTrainingPlan.setRespectiveContributions(respectiveContributions);
        researchTrainingPlan.setSelectionOfSponsorAndInstitution(selectionOfSponsorAndInstitution);
        researchTrainingPlan.setResponsibleConductOfResearch(responsibleConductOfResearch);
    }

    private void setQuestionnareAnswerForResearchTrainingPlan(PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan researchTrainingPlan) {
        researchTrainingPlan.setHumanSubjectsIndefinite(YesNoDataType.N_NO);
        researchTrainingPlan.setVertebrateAnimalsIndefinite(YesNoDataType.N_NO);
        researchTrainingPlan.setHumanSubjectsIndefinite(YesNoDataType.N_NO);
        researchTrainingPlan.setClinicalTrial(YesNoDataType.N_NO);
        researchTrainingPlan.setPhase3ClinicalTrial(YesNoDataType.N_NO);
        for (Answer questionnaireAnswer : this.s2sUtilService.getQuestionnaireAnswers(this.pdDoc.getDevelopmentProposal(), this.getNamespace(), this.getFormName())) {
            String answer = questionnaireAnswer.getAnswer();
            if (answer == null) continue;
            switch (questionnaireAnswer.getQuestionnaireQuestion().getQuestion().getQuestionIdAsInteger()) {
                case 1: {
                    researchTrainingPlan.setHumanSubjectsIndefinite(answer.equals("Y") ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    break;
                }
                case 4: {
                    researchTrainingPlan.setVertebrateAnimalsIndefinite(answer.equals("Y") ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    break;
                }
                case 2: {
                    researchTrainingPlan.setClinicalTrial(answer.equals("Y") ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    break;
                }
                case 3: {
                    researchTrainingPlan.setPhase3ClinicalTrial(answer.equals("Y") ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    break;
                }
            }
        }
    }

    private void setHumanSubjectInvolvedAndVertebrateAnimalUsed(PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ResearchTrainingPlan researchTrainingPlan) {
        researchTrainingPlan.setHumanSubjectsInvolved(YesNoDataType.N_NO);
        researchTrainingPlan.setVertebrateAnimalsUsed(YesNoDataType.N_NO);
        for (ProposalSpecialReview propSpecialReview : this.pdDoc.getDevelopmentProposal().getPropSpecialReviews()) {
            switch (Integer.parseInt(propSpecialReview.getSpecialReviewTypeCode())) {
                case 1: {
                    researchTrainingPlan.setHumanSubjectsInvolved(YesNoDataType.Y_YES);
                    break;
                }
                case 2: {
                    researchTrainingPlan.setVertebrateAnimalsUsed(YesNoDataType.Y_YES);
                    break;
                }
            }
        }
    }

    private PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation getAdditionalInformation() {
        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation additionalInformation = PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.Factory.newInstance();
        additionalInformation.setCitizenship(CitizenshipDataType.U_S_CITIZEN_OR_NONCITIZEN_NATIONAL);
        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.StemCells stemCells = PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.StemCells.Factory.newInstance();
        stemCells.setIsHumanStemCellsInvolved(YesNoDataType.N_NO);
        stemCells.setStemCellsIndicator(YesNoDataType.N_NO);
        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.GraduateDegreeSought graduateDegreeSought = PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.GraduateDegreeSought.Factory.newInstance();
        ProposalPerson principalInvestigator = this.s2sUtilService.getPrincipalInvestigator(this.pdDoc);
        ArrayList<String> cellLinesList = new ArrayList<String>(Arrays.asList(stemCells.getCellLinesArray()));
        QuestionnaireQuestion questionnaireQuestion = null;
        AnswerHeader answerHeader = null;
        for (ProposalPerson proposalPerson : this.pdDoc.getDevelopmentProposal().getProposalPersons()) {
            if (!proposalPerson.isInvestigator()) continue;
            CitizenshipTypes citizenShip = this.s2sUtilService.getCitizenship(proposalPerson);
            if (citizenShip.getCitizenShip().trim().equals(CitizenshipDataType.NON_U_S_CITIZEN_WITH_TEMPORARY_VISA.toString())) {
                additionalInformation.setCitizenship(CitizenshipDataType.NON_U_S_CITIZEN_WITH_TEMPORARY_VISA);
                continue;
            }
            if (citizenShip.getCitizenShip().trim().equals(CitizenshipDataType.PERMANENT_RESIDENT_OF_U_S.toString())) {
                additionalInformation.setCitizenship(CitizenshipDataType.PERMANENT_RESIDENT_OF_U_S);
                continue;
            }
            if (citizenShip.getCitizenShip().trim().equals(CitizenshipDataType.U_S_CITIZEN_OR_NONCITIZEN_NATIONAL.toString())) {
                additionalInformation.setCitizenship(CitizenshipDataType.U_S_CITIZEN_OR_NONCITIZEN_NATIONAL);
                continue;
            }
            if (!citizenShip.getCitizenShip().trim().equals(CitizenshipDataType.PERMANENT_RESIDENT_OF_U_S_PENDING.toString())) continue;
            additionalInformation.setCitizenship(CitizenshipDataType.PERMANENT_RESIDENT_OF_U_S_PENDING);
        }
        if (principalInvestigator != null && principalInvestigator.getMobilePhoneNumber() != null) {
            additionalInformation.setAlernatePhoneNumber(principalInvestigator.getMobilePhoneNumber());
        }
        for (Answer questionnaireAnswer : this.s2sUtilService.getQuestionnaireAnswers(this.pdDoc.getDevelopmentProposal(), this.getNamespace(), this.getFormName())) {
            String answer = questionnaireAnswer.getAnswer();
            questionnaireQuestion = questionnaireAnswer.getQuestionnaireQuestion();
            answerHeader = questionnaireAnswer.getAnswerHeader();
            if (questionnaireAnswer.getQuestionnaireQuestion().getQuestion().getQuestionIdAsInteger().equals(7)) {
                List<Answer> answerList = this.getAnswers(questionnaireQuestion, answerHeader);
                for (Answer questionnaireAnswerBO : answerList) {
                    String questionnaireSubAnswer = questionnaireAnswerBO.getAnswer();
                    if (questionnaireSubAnswer == null) continue;
                    cellLinesList.add(questionnaireSubAnswer);
                    stemCells.addCellLines(questionnaireSubAnswer);
                }
            }
            if (answer == null) continue;
            switch (questionnaireAnswer.getQuestionnaireQuestion().getQuestion().getQuestionIdAsInteger()) {
                case 22: 
                case 23: {
                    if (answer.toUpperCase().equals("SUB CATEGORY NOT FOUND")) break;
                    FieldOfTrainingDataType.Enum e = FieldOfTrainingDataType.Enum.forString((String)answer);
                    additionalInformation.setFieldOfTraining(e);
                    break;
                }
                case 24: {
                    additionalInformation.setCurrentPriorNRSASupportIndicator(answer.equals("Y") ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    break;
                }
                case 28: {
                    additionalInformation.setChangeOfInstitution(answer.equals("Y") ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    break;
                }
                case 29: {
                    additionalInformation.setFormerInstitution(answer);
                    break;
                }
                case 5: {
                    stemCells.setIsHumanStemCellsInvolved(answer.equals("Y") ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    break;
                }
                case 6: {
                    stemCells.setStemCellsIndicator(answer.equals("Y") ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    break;
                }
                case 15: {
                    graduateDegreeSought.setDegreeType(DegreeTypeDataType.Enum.forString((String)answer));
                    break;
                }
                case 35: {
                    graduateDegreeSought.setDegreeDate(answer.substring(6, 10) + '-' + answer.substring(0, 2));
                    break;
                }
                case 16: {
                    graduateDegreeSought.setOtherDegreeTypeText(answer);
                    break;
                }
                case 17: {
                    graduateDegreeSought.setOtherDegreeTypeText(answer);
                    break;
                }
                case 18: {
                    graduateDegreeSought.setDegreeType(DegreeTypeDataType.DDOT_OTHER_DOCTOR_OF_MEDICAL_DENTISTRY);
                    graduateDegreeSought.setOtherDegreeTypeText(answer);
                    break;
                }
                case 19: {
                    graduateDegreeSought.setDegreeType(DegreeTypeDataType.VDOT_OTHER_DOCTOR_OF_VETERINARY_MEDICINE);
                    graduateDegreeSought.setOtherDegreeTypeText(answer);
                    break;
                }
                case 20: {
                    graduateDegreeSought.setDegreeType(DegreeTypeDataType.DBOTH_OTHER_DOUBLE_DEGREE_PROGRAM);
                    graduateDegreeSought.setOtherDegreeTypeText(answer);
                    break;
                }
                case 21: {
                    graduateDegreeSought.setDegreeType(DegreeTypeDataType.MDOT_OTHER_DOCTOR_OF_MEDICINE);
                    graduateDegreeSought.setOtherDegreeTypeText(answer);
                    break;
                }
            }
        }
        additionalInformation.setStemCells(stemCells);
        if (graduateDegreeSought.getDegreeType() != null) {
            additionalInformation.setGraduateDegreeSought(graduateDegreeSought);
        }
        additionalInformation.setCurrentPriorNRSASupportArray(this.getCurrentPriorNRSASupportArray());
        additionalInformation.setConcurrentSupport(YesNoDataType.N_NO);
        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.FellowshipTrainingAndCareerGoals fellowshipTrainingAndCareerGoals = PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.FellowshipTrainingAndCareerGoals.Factory.newInstance();
        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.ActivitiesPlannedUnderThisAward activitiesPlannedUnderThisAward = PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.ActivitiesPlannedUnderThisAward.Factory.newInstance();
        AttachedFileDataType attachedFileDataType = null;
        for (Narrative narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeTypeCode() != null) {
                switch (Integer.parseInt(narrative.getNarrativeTypeCode())) {
                    case 91: {
                        attachedFileDataType = this.getAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.ConcurrentSupportDescription concurrentSupportDescription = PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.ConcurrentSupportDescription.Factory.newInstance();
                        concurrentSupportDescription.setAttFile(attachedFileDataType);
                        additionalInformation.setConcurrentSupport(YesNoDataType.Y_YES);
                        additionalInformation.setConcurrentSupportDescription(concurrentSupportDescription);
                        break;
                    }
                    case 92: {
                        attachedFileDataType = this.getAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        fellowshipTrainingAndCareerGoals.setAttFile(attachedFileDataType);
                        break;
                    }
                    case 93: {
                        attachedFileDataType = this.getAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.DissertationAndResearchExperience dissertationAndResearchExperience = PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.DissertationAndResearchExperience.Factory.newInstance();
                        dissertationAndResearchExperience.setAttFile(attachedFileDataType);
                        additionalInformation.setDissertationAndResearchExperience(dissertationAndResearchExperience);
                        break;
                    }
                    case 94: {
                        attachedFileDataType = this.getAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        activitiesPlannedUnderThisAward.setAttFile(attachedFileDataType);
                        break;
                    }
                }
            }
        }
        additionalInformation.setFellowshipTrainingAndCareerGoals(fellowshipTrainingAndCareerGoals);
        additionalInformation.setActivitiesPlannedUnderThisAward(activitiesPlannedUnderThisAward);
        return additionalInformation;
    }

    private PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.CurrentPriorNRSASupport[] getCurrentPriorNRSASupportArray() {
        ArrayList<PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.CurrentPriorNRSASupport> currentPriorNRSASupportList = new ArrayList<PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.CurrentPriorNRSASupport>();
        ArrayList<Answer> answerList = new ArrayList<Answer>();
        String nsrSupport = null;
        List<AnswerHeader> answers = this.findQuestionnaireWithAnswers(this.pdDoc.getDevelopmentProposal());
        for (AnswerHeader answerHeader : answers) {
            Questionnaire questionnaire = answerHeader.getQuestionnaire();
            List<QuestionnaireQuestion> questionnaireQuestions = questionnaire.getQuestionnaireQuestions();
            for (QuestionnaireQuestion questionnaireQuestion : questionnaireQuestions) {
                Answer answerBO = this.getAnswer(questionnaireQuestion, answerHeader);
                String answer = answerBO.getAnswer();
                Question question = questionnaireQuestion.getQuestion();
                int questionId = question.getQuestionIdAsInteger();
                if (answer == null) continue;
                switch (questionId) {
                    case 27: 
                    case 32: 
                    case 33: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 49: {
                        if (questionId == 43) {
                            if (!answer.equals("N")) break;
                            answer = "Unknown";
                            questionId = 44;
                        }
                        if (questionId == 49) {
                            if (!answer.equals("N")) break;
                            answer = "Unknown";
                            questionId = 45;
                        }
                        if (questionId == 46) {
                            if (!answer.equals("N")) break;
                            answer = "Unknown";
                            questionId = 27;
                        }
                        Answer quesAnswer = new Answer();
                        quesAnswer.setAnswer(answer);
                        quesAnswer.setQuestionNumber(questionId);
                        answerList.add(quesAnswer);
                        break;
                    }
                    case 24: {
                        nsrSupport = answer.equals("Y") ? "Yes" : "No";
                        break;
                    }
                }
            }
        }
        Collections.sort(answerList, new Comparator<Answer>(){

            @Override
            public int compare(Answer answer1, Answer answer2) {
                return answer1.getQuestionNumber().compareTo(answer2.getQuestionNumber());
            }
        });
        ArrayList<PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.CurrentPriorNRSASupport.Level.Enum> levelList = new ArrayList<PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.CurrentPriorNRSASupport.Level.Enum>();
        ArrayList<PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.CurrentPriorNRSASupport.Type.Enum> typeList = new ArrayList<PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.CurrentPriorNRSASupport.Type.Enum>();
        ArrayList<Calendar> startDateList = new ArrayList<Calendar>();
        ArrayList<Calendar> endDateList = new ArrayList<Calendar>();
        ArrayList<String> grantNumberList = new ArrayList<String>();
        for (Answer questionnaireAnswer : answerList) {
            if (nsrSupport == null || !nsrSupport.equals("Yes")) continue;
            if (questionnaireAnswer.getQuestionNumber() == 32) {
                levelList.add(PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.CurrentPriorNRSASupport.Level.Enum.forString((String)questionnaireAnswer.getAnswer()));
            }
            if (questionnaireAnswer.getQuestionNumber() == 33) {
                typeList.add(PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.CurrentPriorNRSASupport.Type.Enum.forString((String)questionnaireAnswer.getAnswer()));
            }
            if (questionnaireAnswer.getQuestionNumber() == 44) {
                if (questionnaireAnswer.getAnswer().equals("Unknown")) {
                    startDateList.add(null);
                } else {
                    startDateList.add(this.s2sUtilService.convertDateStringToCalendar(questionnaireAnswer.getAnswer()));
                }
            }
            if (questionnaireAnswer.getQuestionNumber() == 45) {
                if (questionnaireAnswer.getAnswer().equals("Unknown")) {
                    endDateList.add(null);
                } else {
                    endDateList.add(this.s2sUtilService.convertDateStringToCalendar(questionnaireAnswer.getAnswer()));
                }
            }
            if (questionnaireAnswer.getQuestionNumber() != 27) continue;
            grantNumberList.add(questionnaireAnswer.getAnswer());
        }
        for (int index = 0; levelList.size() > index; ++index) {
            PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.CurrentPriorNRSASupport currentPriorNRSASupport = PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.CurrentPriorNRSASupport.Factory.newInstance();
            currentPriorNRSASupport.setLevel((PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.CurrentPriorNRSASupport.Level.Enum)levelList.get(index));
            currentPriorNRSASupport.setType((PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.CurrentPriorNRSASupport.Type.Enum)typeList.get(index));
            if (!startDateList.isEmpty() && startDateList.get(index) != null) {
                currentPriorNRSASupport.setStartDate((Calendar)startDateList.get(index));
            }
            if (!endDateList.isEmpty() && endDateList.get(index) != null) {
                currentPriorNRSASupport.setEndDate((Calendar)endDateList.get(index));
            }
            currentPriorNRSASupport.setGrantNumber((String)grantNumberList.get(index));
            currentPriorNRSASupportList.add(currentPriorNRSASupport);
        }
        return currentPriorNRSASupportList.toArray(new PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.AdditionalInformation.CurrentPriorNRSASupport[currentPriorNRSASupportList.size()]);
    }

    private Answer getAnswer(QuestionnaireQuestion questionnaireQuestion, AnswerHeader answerHeader) {
        List<Answer> answers = answerHeader.getAnswers();
        for (Answer answer : answers) {
            if (!answer.getQuestionnaireQuestionsIdFk().equals(questionnaireQuestion.getQuestionnaireQuestionsId())) continue;
            return answer;
        }
        return null;
    }

    private AttachmentGroupMin0Max100DataType getAppendix() {
        AttachmentGroupMin0Max100DataType attachmentGroupType = AttachmentGroupMin0Max100DataType.Factory.newInstance();
        ArrayList<AttachedFileDataType> attachedFileDataTypeList = new ArrayList<AttachedFileDataType>();
        AttachedFileDataType attachedFileDataType = null;
        for (Narrative narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeTypeCode() == null || Integer.parseInt(narrative.getNarrativeTypeCode()) != 96 || (attachedFileDataType = this.getAttachedFileType(narrative)) == null) continue;
            attachedFileDataTypeList.add(attachedFileDataType);
        }
        attachmentGroupType.setAttachedFileArray(attachedFileDataTypeList.toArray(new AttachedFileDataType[attachedFileDataTypeList.size()]));
        return attachmentGroupType;
    }

    private PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ApplicationType getApplicationType() {
        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ApplicationType applicationType = PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ApplicationType.Factory.newInstance();
        applicationType.setTypeOfApplication(this.getTypeOfApplication());
        return applicationType;
    }

    private PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ApplicationType.TypeOfApplication.Enum getTypeOfApplication() {
        String proposalTypeCode = this.pdDoc.getDevelopmentProposal().getProposalTypeCode();
        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ApplicationType.TypeOfApplication.Enum typeOfApplication = null;
        if (proposalTypeCode != null) {
            if (proposalTypeCode.equals(ProposalDevelopmentUtils.getProposalDevelopmentDocumentParameter("PROPOSAL_TYPE_CODE_NEW"))) {
                typeOfApplication = PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ApplicationType.TypeOfApplication.NEW;
            } else if (proposalTypeCode.equals(ProposalDevelopmentUtils.getProposalDevelopmentDocumentParameter("PROPOSAL_TYPE_CODE_CONTINUATION"))) {
                typeOfApplication = PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ApplicationType.TypeOfApplication.CONTINUATION;
            } else if (proposalTypeCode.equals(ProposalDevelopmentUtils.getProposalDevelopmentDocumentParameter("PROPOSAL_TYPE_CODE_REVISION"))) {
                typeOfApplication = PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ApplicationType.TypeOfApplication.REVISION;
            } else if (proposalTypeCode.equals(ProposalDevelopmentUtils.getProposalDevelopmentDocumentParameter("PROPOSAL_TYPE_CODE_RENEWAL"))) {
                typeOfApplication = PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ApplicationType.TypeOfApplication.RENEWAL;
            } else if (proposalTypeCode.equals(ProposalDevelopmentUtils.getProposalDevelopmentDocumentParameter("PROPOSAL_TYPE_CODE_RESUBMISSION"))) {
                typeOfApplication = PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ApplicationType.TypeOfApplication.RESUBMISSION;
            } else if (proposalTypeCode.equals("7")) {
                typeOfApplication = PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11.ApplicationType.TypeOfApplication.NEW;
            }
        }
        return typeOfApplication;
    }

    private BudgetDecimal getNumberOfMonths(Date dateStart, Date dateEnd) {
        BudgetDecimal monthCount = BudgetDecimal.ZERO;
        int fullMonthCount = 0;
        Calendar startDate = Calendar.getInstance();
        Calendar endDate = Calendar.getInstance();
        startDate.setTime(dateStart);
        endDate.setTime(dateEnd);
        startDate.clear(10);
        startDate.clear(12);
        startDate.clear(13);
        startDate.clear(14);
        endDate.clear(10);
        endDate.clear(12);
        endDate.clear(13);
        endDate.clear(14);
        if (startDate.after(endDate)) {
            return BudgetDecimal.ZERO;
        }
        int startMonthDays = startDate.getActualMaximum(5) - startDate.get(5);
        int startMonthMaxDays = startDate.getActualMaximum(5);
        BudgetDecimal startMonthFraction = new BudgetDecimal(++startMonthDays).divide(new BudgetDecimal(startMonthMaxDays));
        int endMonthDays = endDate.get(5);
        int endMonthMaxDays = endDate.getActualMaximum(5);
        BudgetDecimal endMonthFraction = new BudgetDecimal(endMonthDays).divide(new BudgetDecimal(endMonthMaxDays));
        startDate.set(5, 1);
        endDate.set(5, 1);
        while (startDate.getTimeInMillis() < endDate.getTimeInMillis()) {
            startDate.set(2, startDate.get(2) + 1);
            ++fullMonthCount;
        }
        monthCount = (BudgetDecimal)((BudgetDecimal)((BudgetDecimal)monthCount.add(new BudgetDecimal(--fullMonthCount))).add(startMonthFraction)).add(endMonthFraction);
        return monthCount;
    }

    @Override
    public XmlObject getFormObject(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11 phsFellowshipSupplemental = this.getPHSFellowshipSupplemental11();
        PHSFellowshipSupplemental11Document phsFellowshipSupplementalDocument = PHSFellowshipSupplemental11Document.Factory.newInstance();
        phsFellowshipSupplementalDocument.setPHSFellowshipSupplemental11(phsFellowshipSupplemental);
        return phsFellowshipSupplementalDocument;
    }

    public XmlObject getFormObject(XmlObject xmlObject) {
        PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11 phsFellowshipSupplemental = (PHSFellowshipSupplemental11Document.PHSFellowshipSupplemental11)xmlObject;
        PHSFellowshipSupplemental11Document phsFellowshipSupplementalDocument = PHSFellowshipSupplemental11Document.Factory.newInstance();
        phsFellowshipSupplementalDocument.setPHSFellowshipSupplemental11(phsFellowshipSupplemental);
        return phsFellowshipSupplementalDocument;
    }

    @Override
    public String getFormName() {
        return "PHS_Fellowship_Supplemental_1_1-V1.1";
    }

    @Override
    public String getNamespace() {
        return "http://apply.grants.gov/forms/PHS_Fellowship_Supplemental_1_1-V1.1";
    }

    private List<Answer> getAnswers(QuestionnaireQuestion questionnaireQuestion, AnswerHeader answerHeader) {
        ArrayList<Answer> returnAnswers = new ArrayList<Answer>();
        if (answerHeader != null) {
            List<Answer> answers = answerHeader.getAnswers();
            for (Answer answer : answers) {
                if (!answer.getQuestionnaireQuestionsIdFk().equals(questionnaireQuestion.getQuestionnaireQuestionsId())) continue;
                returnAnswers.add(answer);
            }
        }
        return returnAnswers;
    }

    private List<AnswerHeader> findQuestionnaireWithAnswers(DevelopmentProposal developmentProposal) {
        ProposalDevelopmentS2sQuestionnaireService questionnaireAnswerService = this.getProposalDevelopmentS2sQuestionnaireService();
        return questionnaireAnswerService.getProposalAnswerHeaderForForm(developmentProposal, "http://apply.grants.gov/forms/PHS_Fellowship_Supplemental_1_1-V1.1", "PHS_Fellowship_Supplemental_1_1-V1.1");
    }

    private ProposalDevelopmentS2sQuestionnaireService getProposalDevelopmentS2sQuestionnaireService() {
        return KraServiceLocator.getService(ProposalDevelopmentS2sQuestionnaireService.class);
    }
}

