/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.forms.phsFellowshipSupplemental12V12.CitizenshipDataType;
import gov.grants.apply.forms.phsFellowshipSupplemental12V12.DegreeTypeDataType;
import gov.grants.apply.forms.phsFellowshipSupplemental12V12.FieldOfTrainingDataType;
import gov.grants.apply.forms.phsFellowshipSupplemental12V12.PHSFellowshipSupplemental12Document;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.attachmentsV10.AttachmentGroupMin0Max100DataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.calculator.QueryList;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.infrastructure.CitizenshipTypes;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.ProposalDevelopmentUtils;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.service.ProposalDevelopmentS2sQuestionnaireService;
import org.kuali.kra.proposaldevelopment.specialreview.ProposalSpecialReview;
import org.kuali.kra.questionnaire.Questionnaire;
import org.kuali.kra.questionnaire.QuestionnaireQuestion;
import org.kuali.kra.questionnaire.answer.Answer;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.questionnaire.question.Question;
import org.kuali.kra.s2s.S2SException;
import org.kuali.kra.s2s.generator.impl.PHS398FellowshipSupplementalBaseGenerator;

public class PHS398FellowshipSupplementalV1_2Generator
extends PHS398FellowshipSupplementalBaseGenerator {
    private static final Log LOG = LogFactory.getLog(PHS398FellowshipSupplementalV1_2Generator.class);
    private static final int HUMAN = 1;
    private static final int VERT = 4;
    private static final int CLINICAL = 2;
    private static final int PHASE3CLINICAL = 3;
    private static final int STEMCELLS = 5;
    private static final int KIRST_START_KNOWN = 43;
    private static final int KIRST_END_KNOWN = 49;
    private static final int KIRST_START_DT = 44;
    private static final int KIRST_END_DT = 45;
    private static final int KIRST_GRANT_KNOWN = 46;
    private static final int KIRST_GRANT_NUM = 27;
    private static final int PRE_OR_POST = 32;
    private static final int IND_OR_INST = 33;
    private static final int STEMCELLLINES = 7;
    private static final int CELLLINEIND = 6;
    private static final int DEGREE_TYPE_SOUGHT = 99;
    private static final int DEG_EXP_COMP_DATE = 35;
    private static final int NRSA_SUPPORT = 24;
    private static final int FIELD_TRAINING = 22;
    private static final int BROAD_TRAINING = 23;
    private static final int OTHER_MASTERS = 16;
    private static final int OTHER_DOCT = 17;
    private static final int OTHER_DDOT = 18;
    private static final int OTHER_VDOT = 19;
    private static final int OTHER_DBOTH = 100;
    private static final int OTHER_MDOT = 21;
    private static final int SUBMITTED_DIFF_INST = 28;
    private static final int SENIOR_FELL = 36;
    private static final int OTHER_SUPP_SOURCE = 37;
    private static final int SUPP_FUNDING_AMT = 38;
    private static final int SUPP_MONTHS = 51;
    private static final int SUPP_SOURCE = 41;
    private static final int SUPP_TYPE = 40;
    private static final int BASE_SALARY = 47;
    private static final int ACAD_PERIOD = 48;
    private static final int SALARY_MONTHS = 50;
    private static final int APPENDIX = 96;
    private static final int SPONSOR_COSPONSOR = 134;
    private static final String ANSWER_YES = "Yes";
    private static final String ANSWER_NO = "No";
    private static final String ANSWER_Y = "Y";
    private static final String ANSWER_N = "N";

    private PHSFellowshipSupplemental12Document getPHSFellowshipSupplemental12() {
        PHSFellowshipSupplemental12Document phsFellowshipSupplementalDocument = PHSFellowshipSupplemental12Document.Factory.newInstance();
        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12 phsFellowshipSupplemental = phsFellowshipSupplementalDocument.addNewPHSFellowshipSupplemental12();
        phsFellowshipSupplemental.setFormVersion("1.2");
        phsFellowshipSupplemental.setApplicationType(this.getApplicationType());
        phsFellowshipSupplemental.setAppendix(this.getAppendix());
        this.setQuestionnaireData(phsFellowshipSupplemental);
        return phsFellowshipSupplementalDocument;
    }

    private List<Answer> getAnswers(QuestionnaireQuestion questionnaireQuestion, AnswerHeader answerHeader) {
        ArrayList<Answer> returnAnswers = new ArrayList<Answer>();
        if (answerHeader != null) {
            List<Answer> answers = answerHeader.getAnswers();
            for (Answer answer : answers) {
                if (!answer.getQuestionnaireQuestionsIdFk().equals(questionnaireQuestion.getQuestionnaireQuestionsId())) continue;
                returnAnswers.add(answer);
            }
        }
        return returnAnswers;
    }

    private void setQuestionnaireData(PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12 phsFellowshipSupplemental) {
        HashMap<Integer, String> hmBudgetQuestions = new HashMap<Integer, String>();
        List<AnswerHeader> answers = this.findQuestionnaireWithAnswers(this.pdDoc.getDevelopmentProposal());
        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan researchTrainingPlan = phsFellowshipSupplemental.addNewResearchTrainingPlan();
        this.setHumanSubjectInvolvedAndVertebrateAnimalUsed(researchTrainingPlan);
        this.setNarrativeDataForResearchTrainingPlan(phsFellowshipSupplemental, researchTrainingPlan);
        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation additionalInfoType = phsFellowshipSupplemental.addNewAdditionalInformation();
        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.GraduateDegreeSought graduateDegreeSought = PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.GraduateDegreeSought.Factory.newInstance();
        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.StemCells stemCellstype = PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.StemCells.Factory.newInstance();
        QueryList<KirschsteinBean> cvKirsch = new QueryList<KirschsteinBean>();
        for (AnswerHeader answerHeader : answers) {
            Questionnaire questionnaire = answerHeader.getQuestionnaire();
            List<QuestionnaireQuestion> questionnaireQuestions = questionnaire.getQuestionnaireQuestions();
            block55: for (QuestionnaireQuestion questionnaireQuestion : questionnaireQuestions) {
                Answer answerBO = this.getAnswer(questionnaireQuestion, answerHeader);
                String answer = answerBO.getAnswer();
                Question question = questionnaireQuestion.getQuestion();
                Integer questionNumber = questionnaireQuestion.getQuestionNumber();
                Integer parentQuestionNumber = questionnaireQuestion.getParentQuestionNumber();
                Integer questionId = question.getQuestionIdAsInteger();
                if (answer != null) {
                    if (!answer.equalsIgnoreCase(ANSWER_YES) || !answer.equalsIgnoreCase(ANSWER_NO)) {
                        switch (questionId) {
                            case 1: {
                                researchTrainingPlan.setHumanSubjectsIndefinite(this.getYesNoEnum(answer));
                                break;
                            }
                            case 4: {
                                if (answer == null) break;
                                researchTrainingPlan.setVertebrateAnimalsIndefinite(this.getYesNoEnum(answer));
                                break;
                            }
                            case 2: {
                                if (answer == null) break;
                                researchTrainingPlan.setClinicalTrial(this.getYesNoEnum(answer));
                                break;
                            }
                            case 3: {
                                if (answer == null) break;
                                researchTrainingPlan.setPhase3ClinicalTrial(this.getYesNoEnum(answer));
                                break;
                            }
                            case 5: {
                                if (answer == null) break;
                                stemCellstype.setIsHumanStemCellsInvolved(this.getYesNoEnum(answer));
                                break;
                            }
                            case 6: {
                                if (answer == null) break;
                                stemCellstype.setStemCellsIndicator(this.getYesNoEnum(answer));
                                break;
                            }
                            case 7: {
                                List<Answer> answerList = this.getAnswers(questionnaireQuestion, answerHeader);
                                for (Answer questionnaireAnswerBO : answerList) {
                                    String questionnaireSubAnswer = questionnaireAnswerBO.getAnswer();
                                    if (questionnaireSubAnswer == null) continue;
                                    stemCellstype.addCellLines(questionnaireAnswerBO.getAnswer());
                                }
                                break;
                            }
                            case 99: {
                                graduateDegreeSought.setDegreeType(DegreeTypeDataType.Enum.forString((String)answer));
                                break;
                            }
                            case 35: {
                                graduateDegreeSought.setDegreeDate(answer.substring(6, 10) + '-' + answer.substring(0, 2));
                                break;
                            }
                            case 16: {
                                graduateDegreeSought.setOtherDegreeTypeText(answer);
                                graduateDegreeSought.setOtherDegreeTypeText(answer);
                                graduateDegreeSought.setOtherDegreeTypeText(answer);
                                break;
                            }
                            case 18: {
                                graduateDegreeSought.setDegreeType(DegreeTypeDataType.DDOT_OTHER_DOCTOR_OF_MEDICAL_DENTISTRY);
                                graduateDegreeSought.setOtherDegreeTypeText(answer);
                                break;
                            }
                            case 19: {
                                graduateDegreeSought.setDegreeType(DegreeTypeDataType.VDOT_OTHER_DOCTOR_OF_VETERINARY_MEDICINE);
                                graduateDegreeSought.setOtherDegreeTypeText(answer);
                                break;
                            }
                            case 21: {
                                graduateDegreeSought.setDegreeType(DegreeTypeDataType.MDOT_OTHER_DOCTOR_OF_MEDICINE);
                                graduateDegreeSought.setOtherDegreeTypeText(answer);
                                break;
                            }
                            case 22: 
                            case 23: {
                                if (answer.toUpperCase().equals("SUB CATEGORY NOT FOUND")) break;
                                additionalInfoType.setFieldOfTraining(FieldOfTrainingDataType.Enum.forString((String)answer));
                                break;
                            }
                            case 24: {
                                additionalInfoType.setCurrentPriorNRSASupportIndicator(this.getYesNoEnum(answer));
                                break;
                            }
                            case 27: 
                            case 32: 
                            case 33: 
                            case 43: 
                            case 44: 
                            case 45: 
                            case 46: 
                            case 49: {
                                if (questionId == 43) {
                                    if (!answer.equals(ANSWER_N)) break;
                                    answer = "Unknown";
                                    questionId = 44;
                                }
                                if (questionId == 49) {
                                    if (!answer.equals(ANSWER_N)) break;
                                    answer = "Unknown";
                                    questionId = 45;
                                }
                                if (questionId == 46) {
                                    if (!answer.equals(ANSWER_N)) break;
                                    answer = "Unknown";
                                    questionId = 27;
                                }
                                KirschsteinBean cbKirschstein = new KirschsteinBean();
                                cbKirschstein.setAnswer(answer);
                                cbKirschstein.setQuestionId(questionId);
                                cbKirschstein.setQuestionNumber(questionNumber);
                                cbKirschstein.setParentQuestionNumber(parentQuestionNumber);
                                cvKirsch.add(cbKirschstein);
                                break;
                            }
                            case 28: {
                                additionalInfoType.setChangeOfInstitution(this.getYesNoEnum(answer));
                                break;
                            }
                            case 29: {
                                additionalInfoType.setFormerInstitution(answer);
                                break;
                            }
                            case 36: {
                                hmBudgetQuestions.put(36, answer);
                                break;
                            }
                            case 37: {
                                hmBudgetQuestions.put(37, answer);
                                break;
                            }
                            case 41: {
                                hmBudgetQuestions.put(41, answer);
                                break;
                            }
                            case 38: {
                                hmBudgetQuestions.put(38, answer);
                                break;
                            }
                            case 51: {
                                hmBudgetQuestions.put(51, answer);
                                break;
                            }
                            case 40: {
                                hmBudgetQuestions.put(40, answer);
                                break;
                            }
                            case 50: {
                                hmBudgetQuestions.put(50, answer);
                                break;
                            }
                            case 48: {
                                hmBudgetQuestions.put(48, answer);
                                break;
                            }
                            case 47: {
                                hmBudgetQuestions.put(47, answer);
                                break;
                            }
                        }
                    }
                    if (!answer.equalsIgnoreCase(ANSWER_YES) && !answer.equalsIgnoreCase(ANSWER_NO)) continue;
                    switch (questionId) {
                        case 1: {
                            researchTrainingPlan.setHumanSubjectsIndefinite(null);
                            researchTrainingPlan.setHumanSubjectsInvolved(null);
                            continue block55;
                        }
                        case 4: {
                            researchTrainingPlan.setVertebrateAnimalsIndefinite(null);
                            researchTrainingPlan.setVertebrateAnimalsUsed(null);
                            continue block55;
                        }
                        case 2: {
                            researchTrainingPlan.setClinicalTrial(null);
                            continue block55;
                        }
                        case 3: {
                            if (researchTrainingPlan.getClinicalTrial() == null) continue block55;
                            if (researchTrainingPlan.getClinicalTrial().equals(this.getYesNoEnum(ANSWER_N))) {
                                researchTrainingPlan.setPhase3ClinicalTrial(this.getYesNoEnum(answer));
                                continue block55;
                            }
                            researchTrainingPlan.setPhase3ClinicalTrial(null);
                            continue block55;
                        }
                        case 22: {
                            additionalInfoType.setFieldOfTraining(null);
                            continue block55;
                        }
                        case 5: {
                            stemCellstype.setIsHumanStemCellsInvolved(null);
                            continue block55;
                        }
                        case 24: {
                            additionalInfoType.setCurrentPriorNRSASupportIndicator(null);
                            continue block55;
                        }
                    }
                    continue;
                }
                if (answer != null) continue;
                switch (questionId) {
                    case 1: {
                        researchTrainingPlan.setHumanSubjectsIndefinite(null);
                        researchTrainingPlan.setHumanSubjectsInvolved(null);
                        break;
                    }
                    case 4: {
                        researchTrainingPlan.setVertebrateAnimalsIndefinite(null);
                        researchTrainingPlan.setVertebrateAnimalsUsed(null);
                        break;
                    }
                    case 2: {
                        researchTrainingPlan.setClinicalTrial(null);
                        break;
                    }
                    case 3: {
                        if (researchTrainingPlan.getClinicalTrial() != YesNoDataType.Y_YES) break;
                        researchTrainingPlan.setPhase3ClinicalTrial(null);
                        break;
                    }
                    case 22: {
                        additionalInfoType.setFieldOfTraining(null);
                        break;
                    }
                    case 5: {
                        stemCellstype.setIsHumanStemCellsInvolved(null);
                        break;
                    }
                    case 24: {
                        additionalInfoType.setCurrentPriorNRSASupportIndicator(null);
                        break;
                    }
                }
            }
        }
        if (stemCellstype != null) {
            additionalInfoType.setStemCells(stemCellstype);
        }
        if (graduateDegreeSought.getDegreeType() != null) {
            additionalInfoType.setGraduateDegreeSought(graduateDegreeSought);
        }
        QueryList<KirschsteinBean> cvType = new QueryList<KirschsteinBean>();
        QueryList<KirschsteinBean> cvStart = new QueryList<KirschsteinBean>();
        QueryList<KirschsteinBean> cvEnd = new QueryList<KirschsteinBean>();
        QueryList<KirschsteinBean> cvLevel = new QueryList<KirschsteinBean>();
        QueryList<KirschsteinBean> cvGrant = new QueryList<KirschsteinBean>();
        KirschsteinBean kbBean1 = new KirschsteinBean();
        KirschsteinBean kbBean2 = new KirschsteinBean();
        KirschsteinBean kbBean3 = new KirschsteinBean();
        KirschsteinBean kbBean4 = new KirschsteinBean();
        KirschsteinBean kbBean5 = new KirschsteinBean();
        if (additionalInfoType.getCurrentPriorNRSASupportIndicator() != null) {
            if (additionalInfoType.getCurrentPriorNRSASupportIndicator().equals(YesNoDataType.Y_YES)) {
                KirschsteinBean kbBean = new KirschsteinBean();
                cvKirsch.sort("questionNumber");
                block57: for (int i = 0; i < cvKirsch.size(); ++i) {
                    kbBean = (KirschsteinBean)cvKirsch.get(i);
                    switch (kbBean.getQuestionId()) {
                        case 32: {
                            cvLevel.add(kbBean);
                            continue block57;
                        }
                        case 33: {
                            cvType.add(kbBean);
                            continue block57;
                        }
                        case 44: {
                            cvStart.add(kbBean);
                            continue block57;
                        }
                        case 45: {
                            cvEnd.add(kbBean);
                            continue block57;
                        }
                        case 27: {
                            cvGrant.add(kbBean);
                        }
                    }
                }
            }
            ArrayList<PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.CurrentPriorNRSASupport> currentPriorNRSASupportList = new ArrayList<PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.CurrentPriorNRSASupport>();
            int numberRepeats = cvLevel.size();
            if (numberRepeats > 0) {
                for (int j = 0; j < numberRepeats; ++j) {
                    kbBean1 = (KirschsteinBean)cvLevel.get(j);
                    kbBean2 = (KirschsteinBean)cvType.get(j);
                    kbBean3 = (KirschsteinBean)cvStart.get(j);
                    kbBean4 = (KirschsteinBean)cvEnd.get(j);
                    kbBean5 = (KirschsteinBean)cvGrant.get(j);
                    PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.CurrentPriorNRSASupport nrsaSupportType = PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.CurrentPriorNRSASupport.Factory.newInstance();
                    nrsaSupportType.setLevel(PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.CurrentPriorNRSASupport.Level.Enum.forString((String)kbBean1.getAnswer()));
                    nrsaSupportType.setType(PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.CurrentPriorNRSASupport.Type.Enum.forString((String)kbBean2.getAnswer()));
                    if (!kbBean3.getAnswer().equals("Unknown")) {
                        nrsaSupportType.setStartDate(this.s2sUtilService.convertDateStringToCalendar(kbBean3.getAnswer()));
                    }
                    if (!kbBean4.getAnswer().equals("Unknown")) {
                        nrsaSupportType.setEndDate(this.s2sUtilService.convertDateStringToCalendar(kbBean4.getAnswer().toString()));
                    }
                    nrsaSupportType.setGrantNumber(kbBean5.getAnswer());
                    currentPriorNRSASupportList.add(nrsaSupportType);
                }
            }
            additionalInfoType.setCurrentPriorNRSASupportArray(currentPriorNRSASupportList.toArray(new PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.CurrentPriorNRSASupport[0]));
        }
        phsFellowshipSupplemental.setBudget(this.getBudget(hmBudgetQuestions));
        this.setAdditionalInformation(additionalInfoType);
    }

    private YesNoDataType.Enum getYesNoEnum(String answer) {
        return answer.equals(ANSWER_Y) ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
    }

    private PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.Budget getBudget(Map<Integer, String> budgetMap) {
        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.Budget budget = PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.Budget.Factory.newInstance();
        budget.setTuitionAndFeesRequested(YesNoDataType.N_NO);
        this.getInstitutionalBaseSalary(budget, budgetMap);
        this.getFederalStipendRequested(budget);
        this.getSupplementationFromOtherSources(budget, budgetMap);
        this.setTuitionRequestedYears(budget);
        return budget;
    }

    private void setTuitionRequestedYears(PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.Budget budget) {
        BudgetDocument budgetDoc = this.getBudgetDocument();
        if (budgetDoc == null) {
            return;
        }
        BudgetDecimal tuitionTotal = BudgetDecimal.ZERO;
        for (BudgetPeriod budgetPeriod : budgetDoc.getBudget().getBudgetPeriods()) {
            BudgetDecimal tuition = BudgetDecimal.ZERO;
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                if (!this.getCostElementsByParam("TUITION_COST_ELEMENTS").contains(budgetLineItem.getCostElementBO().getCostElement())) continue;
                tuition = (BudgetDecimal)tuition.add(budgetLineItem.getLineItemCost());
            }
            tuitionTotal = (BudgetDecimal)tuitionTotal.add(tuition);
            switch (budgetPeriod.getBudgetPeriod()) {
                case 1: {
                    budget.setTuitionRequestedYear1(tuition.bigDecimalValue());
                    break;
                }
                case 2: {
                    budget.setTuitionRequestedYear2(tuition.bigDecimalValue());
                    break;
                }
                case 3: {
                    budget.setTuitionRequestedYear3(tuition.bigDecimalValue());
                    break;
                }
                case 4: {
                    budget.setTuitionRequestedYear4(tuition.bigDecimalValue());
                    break;
                }
                case 5: {
                    budget.setTuitionRequestedYear5(tuition.bigDecimalValue());
                    break;
                }
                case 6: {
                    budget.setTuitionRequestedYear6(tuition.bigDecimalValue());
                    break;
                }
            }
        }
        budget.setTuitionRequestedTotal(tuitionTotal.bigDecimalValue());
        if (!tuitionTotal.equals((Object)BudgetDecimal.ZERO)) {
            budget.setTuitionAndFeesRequested(YesNoDataType.Y_YES);
        }
    }

    private void getSupplementationFromOtherSources(PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.Budget budget, Map<Integer, String> hmBudgetQuestions) {
        if (!hmBudgetQuestions.isEmpty() && hmBudgetQuestions.get(37) != null && hmBudgetQuestions.get(37).toString().toUpperCase().equals(ANSWER_Y)) {
            PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.Budget.SupplementationFromOtherSources supplementationFromOtherSources = budget.addNewSupplementationFromOtherSources();
            if (hmBudgetQuestions.get(41) != null) {
                supplementationFromOtherSources.setSource(hmBudgetQuestions.get(41).toString());
                supplementationFromOtherSources.setAmount(new BigDecimal(hmBudgetQuestions.get(38).toString()));
                try {
                    supplementationFromOtherSources.setNumberOfMonths(new BigDecimal(hmBudgetQuestions.get(51).toString()));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                supplementationFromOtherSources.setType(hmBudgetQuestions.get(40).toString());
            }
        }
    }

    private void getFederalStipendRequested(PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.Budget budget) {
        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.Budget.FederalStipendRequested federalStipendRequested = PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.Budget.FederalStipendRequested.Factory.newInstance();
        BudgetDocument budgetDoc = this.getBudgetDocument();
        if (budgetDoc != null) {
            Budget pBudget = budgetDoc.getBudget();
            BudgetDecimal sumOfLineItemCost = BudgetDecimal.ZERO;
            BudgetDecimal numberOfMonths = BudgetDecimal.ZERO;
            for (BudgetPeriod budgetPeriod : pBudget.getBudgetPeriods()) {
                if (budgetPeriod.getBudgetPeriod() != 1) continue;
                for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                    if (!this.getCostElementsByParam("STIPEND_COST_ELEMENTS").contains(budgetLineItem.getCostElementBO().getCostElement())) continue;
                    sumOfLineItemCost = (BudgetDecimal)sumOfLineItemCost.add(budgetLineItem.getLineItemCost());
                    numberOfMonths = (BudgetDecimal)numberOfMonths.add(this.getNumberOfMonths(budgetLineItem.getStartDate(), budgetLineItem.getEndDate()));
                }
            }
            federalStipendRequested.setAmount(sumOfLineItemCost.bigDecimalValue());
            federalStipendRequested.setNumberOfMonths(numberOfMonths.bigDecimalValue());
            budget.setFederalStipendRequested(federalStipendRequested);
        }
    }

    private BudgetDocument getBudgetDocument() {
        BudgetDocument budgetDoc = null;
        try {
            budgetDoc = this.s2SBudgetCalculatorService.getFinalBudgetVersion(this.pdDoc);
        }
        catch (S2SException e) {
            LOG.error((Object)"Error while getting Budget", (Throwable)e);
        }
        return budgetDoc;
    }

    private void getInstitutionalBaseSalary(PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.Budget budget, Map<Integer, String> budgetMap) {
        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.Budget.InstitutionalBaseSalary institutionalBaseSalary = PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.Budget.InstitutionalBaseSalary.Factory.newInstance();
        if (budgetMap.get(36) != null && budgetMap.get(36).toString().equals(ANSWER_Y)) {
            if (budgetMap.get(47) != null) {
                institutionalBaseSalary.setAmount(new BigDecimal(budgetMap.get(47).toString()));
            }
            if (budgetMap.get(48) != null) {
                institutionalBaseSalary.setAcademicPeriod(PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.Budget.InstitutionalBaseSalary.AcademicPeriod.Enum.forString((String)budgetMap.get(48).toString()));
            }
            if (budgetMap.get(50) != null) {
                institutionalBaseSalary.setNumberOfMonths(new BigDecimal(budgetMap.get(50).toString()));
            }
            budget.setInstitutionalBaseSalary(institutionalBaseSalary);
        }
    }

    private void setNarrativeDataForResearchTrainingPlan(PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12 phsFellowshipSupplemental, PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan researchTrainingPlan) {
        AttachedFileDataType attachedFileDataType = null;
        researchTrainingPlan.addNewSpecificAims();
        researchTrainingPlan.addNewResearchStrategy();
        researchTrainingPlan.addNewRespectiveContributions();
        researchTrainingPlan.addNewSelectionOfSponsorAndInstitution();
        researchTrainingPlan.addNewResponsibleConductOfResearch();
        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.Sponsors sponsors = phsFellowshipSupplemental.addNewSponsors();
        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.Sponsors.SponsorCosponsorInformation sponsorCosponsorInfo = sponsors.addNewSponsorCosponsorInformation();
        for (Narrative narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeTypeCode() != null) {
                switch (Integer.parseInt(narrative.getNarrativeTypeCode())) {
                    case 97: {
                        attachedFileDataType = this.getAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.IntroductionToApplication introductionToApplication = PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.IntroductionToApplication.Factory.newInstance();
                        introductionToApplication.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setIntroductionToApplication(introductionToApplication);
                        break;
                    }
                    case 98: {
                        attachedFileDataType = this.getAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.SpecificAims specificAims = PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.SpecificAims.Factory.newInstance();
                        specificAims.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setSpecificAims(specificAims);
                        break;
                    }
                    case 127: {
                        attachedFileDataType = this.getAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.ResearchStrategy researchStrategy = PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.ResearchStrategy.Factory.newInstance();
                        researchStrategy.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setResearchStrategy(researchStrategy);
                        break;
                    }
                    case 102: {
                        attachedFileDataType = this.getAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.InclusionEnrollmentReport inclusionEnrollmentReport = PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.InclusionEnrollmentReport.Factory.newInstance();
                        inclusionEnrollmentReport.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setInclusionEnrollmentReport(inclusionEnrollmentReport);
                        break;
                    }
                    case 103: {
                        attachedFileDataType = this.getAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.ProgressReportPublicationList progressReportPublicationList = PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.ProgressReportPublicationList.Factory.newInstance();
                        progressReportPublicationList.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setProgressReportPublicationList(progressReportPublicationList);
                        break;
                    }
                    case 104: {
                        attachedFileDataType = this.getAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.ProtectionOfHumanSubjects protectionOfHumanSubjects = PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.ProtectionOfHumanSubjects.Factory.newInstance();
                        protectionOfHumanSubjects.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setProtectionOfHumanSubjects(protectionOfHumanSubjects);
                        break;
                    }
                    case 105: {
                        attachedFileDataType = this.getAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.InclusionOfWomenAndMinorities inclusionOfWomenAndMinorities = PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.InclusionOfWomenAndMinorities.Factory.newInstance();
                        inclusionOfWomenAndMinorities.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setInclusionOfWomenAndMinorities(inclusionOfWomenAndMinorities);
                        break;
                    }
                    case 106: {
                        attachedFileDataType = this.getAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.TargetedPlannedEnrollment tarPlannedEnrollmentTable = PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.TargetedPlannedEnrollment.Factory.newInstance();
                        tarPlannedEnrollmentTable.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setTargetedPlannedEnrollment(tarPlannedEnrollmentTable);
                        break;
                    }
                    case 107: {
                        attachedFileDataType = this.getAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.InclusionOfChildren inclusionOfChildren = PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.InclusionOfChildren.Factory.newInstance();
                        inclusionOfChildren.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setInclusionOfChildren(inclusionOfChildren);
                        break;
                    }
                    case 108: {
                        attachedFileDataType = this.getAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.VertebrateAnimals vertebrateAnimals = PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.VertebrateAnimals.Factory.newInstance();
                        vertebrateAnimals.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setVertebrateAnimals(vertebrateAnimals);
                        break;
                    }
                    case 109: {
                        attachedFileDataType = this.getAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.SelectAgentResearch selectAgentResearch = PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.SelectAgentResearch.Factory.newInstance();
                        selectAgentResearch.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setSelectAgentResearch(selectAgentResearch);
                        break;
                    }
                    case 110: {
                        attachedFileDataType = this.getAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.ResourceSharingPlan resourceSharingPlan = PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.ResourceSharingPlan.Factory.newInstance();
                        resourceSharingPlan.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setResourceSharingPlan(resourceSharingPlan);
                        break;
                    }
                    case 88: {
                        attachedFileDataType = this.getAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.RespectiveContributions respectiveContributions = PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.RespectiveContributions.Factory.newInstance();
                        respectiveContributions.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setRespectiveContributions(respectiveContributions);
                        break;
                    }
                    case 89: {
                        attachedFileDataType = this.getAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.SelectionOfSponsorAndInstitution selectionOfSponsorAndInstitution = PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.SelectionOfSponsorAndInstitution.Factory.newInstance();
                        selectionOfSponsorAndInstitution.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setSelectionOfSponsorAndInstitution(selectionOfSponsorAndInstitution);
                        break;
                    }
                    case 90: {
                        attachedFileDataType = this.getAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.ResponsibleConductOfResearch responsibleConductOfResearch = PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan.ResponsibleConductOfResearch.Factory.newInstance();
                        responsibleConductOfResearch.setAttFile(attachedFileDataType);
                        researchTrainingPlan.setResponsibleConductOfResearch(responsibleConductOfResearch);
                        break;
                    }
                    case 134: {
                        attachedFileDataType = this.getAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        sponsorCosponsorInfo.setAttFile(attachedFileDataType);
                        break;
                    }
                }
            }
        }
    }

    private PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.Sponsors setSponsorsInfo() {
        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.Sponsors sponsors = PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.Sponsors.Factory.newInstance();
        AttachedFileDataType attachedFileDataType = null;
        for (Narrative narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            int typeCode = Integer.parseInt(narrative.getNarrativeTypeCode());
            if (narrative.getNarrativeTypeCode() == null || typeCode != 134 || (attachedFileDataType = this.getAttachedFileType(narrative)) == null) continue;
            PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.Sponsors.SponsorCosponsorInformation sponsorCosponsorInfo = PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.Sponsors.SponsorCosponsorInformation.Factory.newInstance();
            sponsorCosponsorInfo.setAttFile(attachedFileDataType);
            sponsors.setSponsorCosponsorInformation(sponsorCosponsorInfo);
            break;
        }
        return sponsors;
    }

    private void setHumanSubjectInvolvedAndVertebrateAnimalUsed(PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ResearchTrainingPlan researchTrainingPlan) {
        researchTrainingPlan.setHumanSubjectsInvolved(YesNoDataType.N_NO);
        researchTrainingPlan.setVertebrateAnimalsUsed(YesNoDataType.N_NO);
        for (ProposalSpecialReview propSpecialReview : this.pdDoc.getDevelopmentProposal().getPropSpecialReviews()) {
            switch (Integer.parseInt(propSpecialReview.getSpecialReviewTypeCode())) {
                case 1: {
                    researchTrainingPlan.setHumanSubjectsInvolved(YesNoDataType.Y_YES);
                    break;
                }
                case 2: {
                    researchTrainingPlan.setVertebrateAnimalsUsed(YesNoDataType.Y_YES);
                    break;
                }
            }
        }
    }

    private List<AnswerHeader> findQuestionnaireWithAnswers(DevelopmentProposal developmentProposal) {
        ProposalDevelopmentS2sQuestionnaireService questionnaireAnswerService = this.getProposalDevelopmentS2sQuestionnaireService();
        return questionnaireAnswerService.getProposalAnswerHeaderForForm(developmentProposal, "http://apply.grants.gov/forms/PHS_Fellowship_Supplemental_1_2-V1.2", "PHS_Fellowship_Supplemental_1_2-V1.2");
    }

    private ProposalDevelopmentS2sQuestionnaireService getProposalDevelopmentS2sQuestionnaireService() {
        return KraServiceLocator.getService(ProposalDevelopmentS2sQuestionnaireService.class);
    }

    private Answer getAnswer(QuestionnaireQuestion questionnaireQuestion, AnswerHeader answerHeader) {
        List<Answer> answers = answerHeader.getAnswers();
        for (Answer answer : answers) {
            if (!answer.getQuestionnaireQuestionsIdFk().equals(questionnaireQuestion.getQuestionnaireQuestionsId())) continue;
            return answer;
        }
        return null;
    }

    private void setAdditionalInformation(PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation additionalInformation) {
        Boolean hasInvestigator = false;
        additionalInformation.addNewFellowshipTrainingAndCareerGoals();
        additionalInformation.addNewActivitiesPlannedUnderThisAward();
        ProposalPerson principalInvestigator = this.s2sUtilService.getPrincipalInvestigator(this.pdDoc);
        for (ProposalPerson proposalPerson : this.pdDoc.getDevelopmentProposal().getProposalPersons()) {
            if (!proposalPerson.isInvestigator()) continue;
            hasInvestigator = true;
            CitizenshipTypes citizenShip = this.s2sUtilService.getCitizenship(proposalPerson);
            if (citizenShip.getCitizenShip().trim().equals(CitizenshipDataType.NON_U_S_CITIZEN_WITH_TEMPORARY_VISA.toString())) {
                additionalInformation.setCitizenship(CitizenshipDataType.NON_U_S_CITIZEN_WITH_TEMPORARY_VISA);
                continue;
            }
            if (citizenShip.getCitizenShip().trim().equals(CitizenshipDataType.PERMANENT_RESIDENT_OF_U_S.toString())) {
                additionalInformation.setCitizenship(CitizenshipDataType.PERMANENT_RESIDENT_OF_U_S);
                continue;
            }
            if (citizenShip.getCitizenShip().trim().equals(CitizenshipDataType.U_S_CITIZEN_OR_NONCITIZEN_NATIONAL.toString())) {
                additionalInformation.setCitizenship(CitizenshipDataType.U_S_CITIZEN_OR_NONCITIZEN_NATIONAL);
                continue;
            }
            if (!citizenShip.getCitizenShip().trim().equals(CitizenshipDataType.PERMANENT_RESIDENT_OF_U_S_PENDING.toString())) continue;
            additionalInformation.setCitizenship(CitizenshipDataType.PERMANENT_RESIDENT_OF_U_S_PENDING);
        }
        if (principalInvestigator != null && principalInvestigator.getMobilePhoneNumber() != null) {
            additionalInformation.setAlernatePhoneNumber(principalInvestigator.getMobilePhoneNumber());
        }
        if (!hasInvestigator.booleanValue()) {
            additionalInformation.setCitizenship(null);
        }
        additionalInformation.setConcurrentSupport(YesNoDataType.N_NO);
        AttachedFileDataType attachedFileDataType = null;
        for (Narrative narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeTypeCode() != null) {
                switch (Integer.parseInt(narrative.getNarrativeTypeCode())) {
                    case 91: {
                        attachedFileDataType = this.getAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.ConcurrentSupportDescription concurrentSupportDescription = PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.ConcurrentSupportDescription.Factory.newInstance();
                        concurrentSupportDescription.setAttFile(attachedFileDataType);
                        additionalInformation.setConcurrentSupport(YesNoDataType.Y_YES);
                        additionalInformation.setConcurrentSupportDescription(concurrentSupportDescription);
                        break;
                    }
                    case 92: {
                        attachedFileDataType = this.getAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.FellowshipTrainingAndCareerGoals fellowshipTrainingAndCareerGoals = PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.FellowshipTrainingAndCareerGoals.Factory.newInstance();
                        fellowshipTrainingAndCareerGoals.setAttFile(attachedFileDataType);
                        additionalInformation.setFellowshipTrainingAndCareerGoals(fellowshipTrainingAndCareerGoals);
                        break;
                    }
                    case 93: {
                        attachedFileDataType = this.getAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.DissertationAndResearchExperience dissertationAndResearchExperience = PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.DissertationAndResearchExperience.Factory.newInstance();
                        dissertationAndResearchExperience.setAttFile(attachedFileDataType);
                        additionalInformation.setDissertationAndResearchExperience(dissertationAndResearchExperience);
                        break;
                    }
                    case 94: {
                        attachedFileDataType = this.getAttachedFileType(narrative);
                        if (attachedFileDataType == null) break;
                        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.ActivitiesPlannedUnderThisAward activitiesPlannedUnderThisAward = PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.AdditionalInformation.ActivitiesPlannedUnderThisAward.Factory.newInstance();
                        activitiesPlannedUnderThisAward.setAttFile(attachedFileDataType);
                        additionalInformation.setActivitiesPlannedUnderThisAward(activitiesPlannedUnderThisAward);
                        break;
                    }
                }
            }
        }
    }

    private AttachmentGroupMin0Max100DataType getAppendix() {
        AttachmentGroupMin0Max100DataType attachmentGroupType = AttachmentGroupMin0Max100DataType.Factory.newInstance();
        ArrayList<AttachedFileDataType> attachedFileDataTypeList = new ArrayList<AttachedFileDataType>();
        AttachedFileDataType attachedFileDataType = null;
        for (Narrative narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeTypeCode() == null || Integer.parseInt(narrative.getNarrativeTypeCode()) != 96 || (attachedFileDataType = this.getAttachedFileType(narrative)) == null) continue;
            attachedFileDataTypeList.add(attachedFileDataType);
        }
        attachmentGroupType.setAttachedFileArray(attachedFileDataTypeList.toArray(new AttachedFileDataType[attachedFileDataTypeList.size()]));
        return attachmentGroupType;
    }

    private PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ApplicationType getApplicationType() {
        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ApplicationType applicationType = PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ApplicationType.Factory.newInstance();
        applicationType.setTypeOfApplication(this.getTypeOfApplication());
        return applicationType;
    }

    private PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ApplicationType.TypeOfApplication.Enum getTypeOfApplication() {
        String proposalTypeCode = this.pdDoc.getDevelopmentProposal().getProposalTypeCode();
        PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ApplicationType.TypeOfApplication.Enum typeOfApplication = null;
        if (proposalTypeCode != null) {
            if (proposalTypeCode.equals(ProposalDevelopmentUtils.getProposalDevelopmentDocumentParameter("PROPOSAL_TYPE_CODE_NEW"))) {
                typeOfApplication = PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ApplicationType.TypeOfApplication.NEW;
            } else if (proposalTypeCode.equals(ProposalDevelopmentUtils.getProposalDevelopmentDocumentParameter("PROPOSAL_TYPE_CODE_CONTINUATION"))) {
                typeOfApplication = PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ApplicationType.TypeOfApplication.CONTINUATION;
            } else if (proposalTypeCode.equals(ProposalDevelopmentUtils.getProposalDevelopmentDocumentParameter("PROPOSAL_TYPE_CODE_REVISION"))) {
                typeOfApplication = PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ApplicationType.TypeOfApplication.REVISION;
            } else if (proposalTypeCode.equals(ProposalDevelopmentUtils.getProposalDevelopmentDocumentParameter("PROPOSAL_TYPE_CODE_RENEWAL"))) {
                typeOfApplication = PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ApplicationType.TypeOfApplication.RENEWAL;
            } else if (proposalTypeCode.equals(ProposalDevelopmentUtils.getProposalDevelopmentDocumentParameter("PROPOSAL_TYPE_CODE_RESUBMISSION"))) {
                typeOfApplication = PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ApplicationType.TypeOfApplication.RESUBMISSION;
            } else if (proposalTypeCode.equals("7")) {
                typeOfApplication = PHSFellowshipSupplemental12Document.PHSFellowshipSupplemental12.ApplicationType.TypeOfApplication.NEW;
            }
        }
        return typeOfApplication;
    }

    private BudgetDecimal getNumberOfMonths(Date dateStart, Date dateEnd) {
        BudgetDecimal monthCount = BudgetDecimal.ZERO;
        int fullMonthCount = 0;
        Calendar startDate = Calendar.getInstance();
        Calendar endDate = Calendar.getInstance();
        startDate.setTime(dateStart);
        endDate.setTime(dateEnd);
        startDate.clear(10);
        startDate.clear(12);
        startDate.clear(13);
        startDate.clear(14);
        endDate.clear(10);
        endDate.clear(12);
        endDate.clear(13);
        endDate.clear(14);
        if (startDate.after(endDate)) {
            return BudgetDecimal.ZERO;
        }
        int startMonthDays = startDate.getActualMaximum(5) - startDate.get(5);
        int startMonthMaxDays = startDate.getActualMaximum(5);
        BudgetDecimal startMonthFraction = new BudgetDecimal(++startMonthDays).divide(new BudgetDecimal(startMonthMaxDays));
        int endMonthDays = endDate.get(5);
        int endMonthMaxDays = endDate.getActualMaximum(5);
        BudgetDecimal endMonthFraction = new BudgetDecimal(endMonthDays).divide(new BudgetDecimal(endMonthMaxDays));
        startDate.set(5, 1);
        endDate.set(5, 1);
        while (startDate.getTimeInMillis() < endDate.getTimeInMillis()) {
            startDate.set(2, startDate.get(2) + 1);
            ++fullMonthCount;
        }
        monthCount = (BudgetDecimal)((BudgetDecimal)((BudgetDecimal)monthCount.add(new BudgetDecimal(--fullMonthCount))).add(startMonthFraction)).add(endMonthFraction);
        return monthCount;
    }

    @Override
    public XmlObject getFormObject(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getPHSFellowshipSupplemental12();
    }

    @Override
    public String getFormName() {
        return "PHS_Fellowship_Supplemental_1_2-V1.2";
    }

    @Override
    public String getNamespace() {
        return "http://apply.grants.gov/forms/PHS_Fellowship_Supplemental_1_2-V1.2";
    }

    public class KirschsteinBean {
        String answer;
        Integer questionId;
        Integer questionNumber;
        Integer parentQuestionNumber;

        public String getAnswer() {
            return this.answer;
        }

        public void setAnswer(String answer) {
            this.answer = answer;
        }

        public Integer getQuestionId() {
            return this.questionId;
        }

        public void setQuestionId(Integer questionId) {
            this.questionId = questionId;
        }

        public Integer getQuestionNumber() {
            return this.questionNumber;
        }

        public void setQuestionNumber(Integer questionNumber) {
            this.questionNumber = questionNumber;
        }

        public Integer getParentQuestionNumber() {
            return this.parentQuestionNumber;
        }

        public void setParentQuestionNumber(Integer parentQuestionNumber) {
            this.parentQuestionNumber = parentQuestionNumber;
        }
    }
}

